/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.oss.driver.api.core.CqlSession;
import io.vertx.core.shareddata.Shareable;
import java.util.Objects;

public final class SessionHolder
implements Shareable {
    final CqlSession session;
    final int refCount;

    SessionHolder() {
        this.session = null;
        this.refCount = 1;
    }

    public int refCount() {
        return this.refCount;
    }

    private SessionHolder(CqlSession session, int refCount) {
        this.session = session;
        this.refCount = refCount;
    }

    SessionHolder connected(CqlSession session) {
        Objects.requireNonNull(session);
        if (this.session != null) {
            throw new IllegalStateException();
        }
        return new SessionHolder(session, this.refCount);
    }

    SessionHolder increment() {
        return new SessionHolder(this.session, this.refCount + 1);
    }

    SessionHolder decrement() {
        if (this.refCount < 1) {
            throw new IllegalArgumentException();
        }
        return new SessionHolder(this.session, this.refCount - 1);
    }
}

