/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl.tracing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import java.util.stream.Collectors;

public class QueryRequest {
    public final String address;
    public final String keyspace;
    public final String cql;

    public QueryRequest(CqlSession session, Statement statement) {
        Metadata metadata = session.getMetadata();
        this.address = metadata.getNodes().values().stream().map(Node::getEndPoint).map(EndPoint::asMetricPrefix).collect(Collectors.joining(",", "[", "]"));
        this.keyspace = session.getKeyspace().map(CqlIdentifier::toString).orElse("");
        if (statement instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)statement;
            this.cql = simpleStatement.getQuery();
        } else if (statement instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement;
            this.cql = boundStatement.getPreparedStatement().getQuery();
        } else {
            this.cql = statement instanceof BatchStatement ? "_batch_" : "unknown statement type";
        }
    }

    public String toString() {
        return "QueryRequest{address='" + this.address + "', keyspace='" + this.keyspace + "', cql='" + this.cql + "'}";
    }
}

