/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl.tracing;

import io.vertx.cassandra.impl.tracing.QueryRequest;
import io.vertx.core.spi.tracing.TagExtractor;
import java.util.function.Function;

public enum RequestTags {
    PEER_ADDRESS("network.peer.address", q -> q.address),
    SPAN_KIND("span.kind", q -> "client"),
    DB_NAMESPACE("db.namespace", q -> q.keyspace),
    DB_QUERY_TEXT("db.query.text", q -> q.cql),
    DB_SYSTEM("db.system", q -> "cassandra");

    final String name;
    final Function<QueryRequest, String> fn;
    public static final TagExtractor<QueryRequest> REQUEST_TAG_EXTRACTOR;

    private RequestTags(String name, Function<QueryRequest, String> fn) {
        this.name = name;
        this.fn = fn;
    }

    static {
        REQUEST_TAG_EXTRACTOR = new TagExtractor<QueryRequest>(){
            private final RequestTags[] TAGS = RequestTags.values();

            public int len(QueryRequest obj) {
                return this.TAGS.length;
            }

            public String name(QueryRequest obj, int index) {
                return this.TAGS[index].name;
            }

            public String value(QueryRequest obj, int index) {
                return this.TAGS[index].fn.apply(obj);
            }
        };
    }
}

