/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.impl.CircuitBreakerMetrics;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class CircuitBreakerImpl
implements CircuitBreaker {
    private static final Handler<Void> NOOP = v -> {};
    private final Vertx vertx;
    private final CircuitBreakerOptions options;
    private final String name;
    private final long periodicUpdateTask;
    private Handler<Void> openHandler = NOOP;
    private Handler<Void> halfOpenHandler = NOOP;
    private Handler<Void> closeHandler = NOOP;
    private Function fallback = null;
    private CircuitBreakerState state = CircuitBreakerState.CLOSED;
    private long failures = 0L;
    private final AtomicInteger passed = new AtomicInteger();
    private CircuitBreakerMetrics metrics;

    public CircuitBreakerImpl(String name, Vertx vertx, CircuitBreakerOptions options) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(vertx);
        this.vertx = vertx;
        this.name = name;
        this.options = options == null ? new CircuitBreakerOptions() : new CircuitBreakerOptions(options);
        this.metrics = new CircuitBreakerMetrics(vertx, this, options);
        this.sendUpdateOnEventBus();
        this.periodicUpdateTask = this.options.getNotificationPeriod() > 0L ? vertx.setPeriodic(this.options.getNotificationPeriod(), l -> this.sendUpdateOnEventBus()) : -1L;
    }

    @Override
    public CircuitBreaker close() {
        if (this.periodicUpdateTask != -1L) {
            this.vertx.cancelTimer(this.periodicUpdateTask);
        }
        this.metrics.close();
        return this;
    }

    @Override
    public synchronized CircuitBreaker openHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.openHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker halfOpenHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.halfOpenHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker closeHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.closeHandler = handler;
        return this;
    }

    @Override
    public <T> CircuitBreaker fallback(Function<Throwable, T> handler) {
        Objects.requireNonNull(handler);
        this.fallback = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker reset() {
        this.failures = 0L;
        if (this.state == CircuitBreakerState.CLOSED) {
            return this;
        }
        this.state = CircuitBreakerState.CLOSED;
        this.closeHandler.handle(null);
        this.sendUpdateOnEventBus();
        return this;
    }

    private synchronized void sendUpdateOnEventBus() {
        String address = this.options.getNotificationAddress();
        if (address != null) {
            this.vertx.eventBus().publish(address, (Object)this.metrics.toJson());
        }
    }

    @Override
    public synchronized CircuitBreaker open() {
        this.state = CircuitBreakerState.OPEN;
        this.openHandler.handle(null);
        this.sendUpdateOnEventBus();
        long period = this.options.getResetTimeout();
        if (period != -1L) {
            this.vertx.setTimer(period, l -> this.attemptReset());
        }
        return this;
    }

    @Override
    public synchronized long failureCount() {
        return this.failures;
    }

    @Override
    public synchronized CircuitBreakerState state() {
        return this.state;
    }

    private synchronized CircuitBreaker attemptReset() {
        if (this.state == CircuitBreakerState.OPEN) {
            this.passed.set(0);
            this.state = CircuitBreakerState.HALF_OPEN;
            this.halfOpenHandler.handle(null);
            this.sendUpdateOnEventBus();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CircuitBreaker executeAndReportWithFallback(Future<T> userFuture, Handler<Future<T>> command, Function<Throwable, T> fallback) {
        CircuitBreakerState currentState;
        CircuitBreakerImpl circuitBreakerImpl = this;
        synchronized (circuitBreakerImpl) {
            currentState = this.state;
        }
        CircuitBreakerMetrics.Operation call = this.metrics.enqueue();
        Future operationResult = Future.future();
        operationResult.setHandler(event -> {
            if (event.failed()) {
                this.incrementFailures();
                call.failed();
                if (this.options.isFallbackOnFailure()) {
                    this.invokeFallback(event.cause(), userFuture, fallback, call);
                } else {
                    userFuture.fail(event.cause());
                }
            } else {
                call.complete();
                this.reset();
                userFuture.complete(event.result());
            }
        });
        if (currentState == CircuitBreakerState.CLOSED) {
            if (this.options.getMaxRetries() > 0) {
                this.executeOperation(command, this.retryFuture(1, command, operationResult, call), call);
            } else {
                this.executeOperation(command, operationResult, call);
            }
        } else if (currentState == CircuitBreakerState.OPEN) {
            call.shortCircuited();
            this.invokeFallback(new RuntimeException("open circuit"), userFuture, fallback, call);
        } else if (currentState == CircuitBreakerState.HALF_OPEN) {
            if (this.passed.incrementAndGet() == 1) {
                operationResult.setHandler(event -> {
                    if (event.failed()) {
                        this.open();
                        if (this.options.isFallbackOnFailure()) {
                            this.invokeFallback(event.cause(), userFuture, fallback, call);
                        } else {
                            userFuture.fail(event.cause());
                        }
                    } else {
                        this.reset();
                        userFuture.complete(event.result());
                    }
                });
                this.executeOperation(command, operationResult, call);
            } else {
                call.shortCircuited();
                this.invokeFallback(new RuntimeException("open circuit"), userFuture, fallback, call);
            }
        }
        return this;
    }

    private <T> Future<T> retryFuture(int retryCount, Handler<Future<T>> command, Future<T> operationResult, CircuitBreakerMetrics.Operation call) {
        Future retry = Future.future();
        retry.setHandler(event -> {
            CircuitBreakerState currentState;
            if (event.succeeded()) {
                this.reset();
                operationResult.complete(event.result());
                return;
            }
            CircuitBreakerImpl circuitBreakerImpl = this;
            synchronized (circuitBreakerImpl) {
                currentState = this.state;
            }
            if (currentState == CircuitBreakerState.CLOSED) {
                if (retryCount < this.options.getMaxRetries() - 1) {
                    this.executeOperation(command, this.retryFuture(retryCount + 1, command, operationResult, null), call);
                } else {
                    this.executeOperation(command, operationResult, call);
                }
            } else {
                operationResult.fail((Throwable)new RuntimeException("open circuit"));
            }
        });
        return retry;
    }

    private <T> void invokeFallback(Throwable reason, Future<T> userFuture, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation operation) {
        if (fallback == null) {
            userFuture.fail(reason);
            return;
        }
        try {
            T apply = fallback.apply(reason);
            operation.fallbackSucceed();
            userFuture.complete(apply);
        }
        catch (Exception e) {
            userFuture.fail((Throwable)e);
            operation.fallbackFailed();
        }
    }

    private <T> void executeOperation(Handler<Future<T>> operation, Future<T> operationResult, CircuitBreakerMetrics.Operation call) {
        block4: {
            if (this.options.getTimeout() != -1L) {
                this.vertx.setTimer(this.options.getTimeout(), l -> {
                    if (!operationResult.isComplete()) {
                        if (call != null) {
                            call.timeout();
                        }
                        operationResult.fail("operation timeout");
                    }
                });
            }
            try {
                Future passedFuture = Future.future();
                passedFuture.setHandler(ar -> {
                    if (ar.failed()) {
                        if (!operationResult.isComplete()) {
                            operationResult.fail(ar.cause());
                        }
                    } else if (!operationResult.isComplete()) {
                        operationResult.complete(ar.result());
                    }
                });
                operation.handle((Object)passedFuture);
            }
            catch (Throwable e) {
                if (operationResult.isComplete()) break block4;
                if (call != null) {
                    call.error();
                }
                operationResult.fail(e);
            }
        }
    }

    @Override
    public <T> Future<T> executeWithFallback(Handler<Future<T>> operation, Function<Throwable, T> fallback) {
        Future future = Future.future();
        this.executeAndReportWithFallback(future, operation, fallback);
        return future;
    }

    @Override
    public <T> Future<T> execute(Handler<Future<T>> operation) {
        return this.executeWithFallback(operation, this.fallback);
    }

    @Override
    public <T> CircuitBreaker executeAndReport(Future<T> resultFuture, Handler<Future<T>> operation) {
        return this.executeAndReportWithFallback(resultFuture, operation, this.fallback);
    }

    @Override
    public String name() {
        return this.name;
    }

    private synchronized void incrementFailures() {
        ++this.failures;
        if (this.failures >= (long)this.options.getMaxFailures()) {
            if (this.state != CircuitBreakerState.OPEN) {
                this.open();
            } else {
                this.sendUpdateOnEventBus();
            }
        } else {
            this.sendUpdateOnEventBus();
        }
    }

    public CircuitBreakerMetrics getMetrics() {
        return this.metrics;
    }

    public CircuitBreakerOptions options() {
        return this.options;
    }
}

