/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker;

import io.vertx.circuitbreaker.CircuitBreakerOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true)
public class CircuitBreakerOptions {
    public static final long DEFAULT_TIMEOUT = 10000L;
    public static final int DEFAULT_MAX_FAILURES = 5;
    public static final boolean DEFAULT_FALLBACK_ON_FAILURE = false;
    public static final long DEFAULT_RESET_TIMEOUT = 30000L;
    public static final String DEFAULT_NOTIFICATION_ADDRESS = "vertx.circuit-breaker";
    public static final long DEFAULT_NOTIFICATION_PERIOD = 2000L;
    public static final long DEFAULT_METRICS_ROLLING_WINDOW = 10000L;
    private static final int DEFAULT_MAX_RETRIES = 0;
    private long timeout = 10000L;
    private int maxFailures = 5;
    private boolean fallbackOnFailure = false;
    private long resetTimeout = 30000L;
    private String notificationAddress = "vertx.circuit-breaker";
    private long notificationPeriod = 2000L;
    private int maxRetries = 0;
    private long metricsRollingWindow = 10000L;

    public CircuitBreakerOptions() {
    }

    public CircuitBreakerOptions(CircuitBreakerOptions other) {
        this.timeout = other.timeout;
        this.maxFailures = other.maxFailures;
        this.fallbackOnFailure = other.fallbackOnFailure;
        this.notificationAddress = other.notificationAddress;
        this.notificationPeriod = other.notificationPeriod;
        this.resetTimeout = other.resetTimeout;
        this.maxRetries = other.maxRetries;
    }

    public CircuitBreakerOptions(JsonObject json) {
        this();
        CircuitBreakerOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CircuitBreakerOptionsConverter.toJson(this, json);
        return json;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public CircuitBreakerOptions setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CircuitBreakerOptions setTimeout(long timeoutInMs) {
        this.timeout = timeoutInMs;
        return this;
    }

    public boolean isFallbackOnFailure() {
        return this.fallbackOnFailure;
    }

    public CircuitBreakerOptions setFallbackOnFailure(boolean fallbackOnFailure) {
        this.fallbackOnFailure = fallbackOnFailure;
        return this;
    }

    public long getResetTimeout() {
        return this.resetTimeout;
    }

    public CircuitBreakerOptions setResetTimeout(long resetTimeout) {
        this.resetTimeout = resetTimeout;
        return this;
    }

    public String getNotificationAddress() {
        return this.notificationAddress;
    }

    public CircuitBreakerOptions setNotificationAddress(String notificationAddress) {
        this.notificationAddress = notificationAddress;
        return this;
    }

    public long getNotificationPeriod() {
        return this.notificationPeriod;
    }

    public CircuitBreakerOptions setNotificationPeriod(long notificationPeriod) {
        this.notificationPeriod = notificationPeriod;
        return this;
    }

    public long getMetricsRollingWindow() {
        return this.metricsRollingWindow;
    }

    public CircuitBreakerOptions setMetricsRollingWindow(long metricsRollingWindow) {
        this.metricsRollingWindow = metricsRollingWindow;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public CircuitBreakerOptions setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }
}

