/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.OpenCircuitException;
import io.vertx.circuitbreaker.RetryPolicy;
import io.vertx.circuitbreaker.TimeoutException;
import io.vertx.circuitbreaker.impl.CircuitBreakerMetrics;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class CircuitBreakerImpl
implements CircuitBreaker {
    private static final Handler<Void> NOOP = v -> {};
    private final Vertx vertx;
    private final CircuitBreakerOptions options;
    private final String name;
    private final long periodicUpdateTask;
    private Handler<Void> openHandler = NOOP;
    private Handler<Void> halfOpenHandler = NOOP;
    private Handler<Void> closeHandler = NOOP;
    private Function fallback = null;
    private CircuitBreakerState state = CircuitBreakerState.CLOSED;
    private RollingCounter rollingFailures;
    private final AtomicInteger passed = new AtomicInteger();
    private final CircuitBreakerMetrics metrics;
    private RetryPolicy retryPolicy = (failure, retryCount) -> 0L;

    public CircuitBreakerImpl(String name, Vertx vertx, CircuitBreakerOptions options) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(vertx);
        this.vertx = vertx;
        this.name = name;
        this.options = options == null ? new CircuitBreakerOptions() : new CircuitBreakerOptions(options);
        this.rollingFailures = new RollingCounter(this.options.getFailuresRollingWindow() / 1000L, TimeUnit.SECONDS);
        if (this.options.getNotificationAddress() != null) {
            this.metrics = new CircuitBreakerMetrics(vertx, this, this.options);
            this.sendUpdateOnEventBus();
            this.periodicUpdateTask = this.options.getNotificationPeriod() > 0L ? vertx.setPeriodic(this.options.getNotificationPeriod(), l -> this.sendUpdateOnEventBus()) : -1L;
        } else {
            this.metrics = null;
            this.periodicUpdateTask = -1L;
        }
    }

    @Override
    public CircuitBreaker close() {
        if (this.metrics != null) {
            if (this.periodicUpdateTask != -1L) {
                this.vertx.cancelTimer(this.periodicUpdateTask);
            }
            this.metrics.close();
        }
        return this;
    }

    @Override
    public synchronized CircuitBreaker openHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.openHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker halfOpenHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.halfOpenHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker closeHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.closeHandler = handler;
        return this;
    }

    @Override
    public <T> CircuitBreaker fallback(Function<Throwable, T> handler) {
        Objects.requireNonNull(handler);
        this.fallback = handler;
        return this;
    }

    public synchronized CircuitBreaker reset(boolean force) {
        this.rollingFailures.reset();
        if (this.state == CircuitBreakerState.CLOSED) {
            return this;
        }
        if (!force && this.state == CircuitBreakerState.OPEN) {
            return this;
        }
        this.state = CircuitBreakerState.CLOSED;
        this.closeHandler.handle(null);
        this.sendUpdateOnEventBus();
        return this;
    }

    @Override
    public synchronized CircuitBreaker reset() {
        return this.reset(false);
    }

    private synchronized void sendUpdateOnEventBus() {
        if (this.metrics != null) {
            DeliveryOptions deliveryOptions = new DeliveryOptions().setLocalOnly(this.options.isNotificationLocalOnly());
            this.vertx.eventBus().publish(this.options.getNotificationAddress(), (Object)this.metrics.toJson(), deliveryOptions);
        }
    }

    @Override
    public synchronized CircuitBreaker open() {
        this.state = CircuitBreakerState.OPEN;
        this.openHandler.handle(null);
        this.sendUpdateOnEventBus();
        long period = this.options.getResetTimeout();
        if (period != -1L) {
            this.vertx.setTimer(period, l -> this.attemptReset());
        }
        return this;
    }

    @Override
    public synchronized long failureCount() {
        return this.rollingFailures.count();
    }

    @Override
    public synchronized CircuitBreakerState state() {
        return this.state;
    }

    private synchronized CircuitBreaker attemptReset() {
        if (this.state == CircuitBreakerState.OPEN) {
            this.passed.set(0);
            this.state = CircuitBreakerState.HALF_OPEN;
            this.halfOpenHandler.handle(null);
            this.sendUpdateOnEventBus();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CircuitBreaker executeAndReportWithFallback(Promise<T> userFuture, Handler<Promise<T>> command, Function<Throwable, T> fallback) {
        CircuitBreakerState currentState;
        Context context = this.vertx.getOrCreateContext();
        CircuitBreakerImpl circuitBreakerImpl = this;
        synchronized (circuitBreakerImpl) {
            currentState = this.state;
        }
        CircuitBreakerMetrics.Operation call = this.metrics != null ? this.metrics.enqueue() : null;
        Promise operationResult = Promise.promise();
        if (currentState == CircuitBreakerState.CLOSED) {
            operationResult.future().onComplete(event -> context.runOnContext(v -> {
                if (event.failed()) {
                    this.incrementFailures();
                    if (call != null) {
                        call.failed();
                    }
                    if (this.options.isFallbackOnFailure()) {
                        this.invokeFallback(event.cause(), userFuture, fallback, call);
                    } else {
                        userFuture.fail(event.cause());
                    }
                } else {
                    if (call != null) {
                        call.complete();
                    }
                    this.reset();
                    userFuture.complete(event.result());
                }
            }));
            if (this.options.getMaxRetries() > 0) {
                this.executeOperation(context, command, this.retryFuture(context, 0, command, operationResult, call), call);
            } else {
                this.executeOperation(context, command, operationResult, call);
            }
        } else if (currentState == CircuitBreakerState.OPEN) {
            if (call != null) {
                call.shortCircuited();
            }
            this.invokeFallback(OpenCircuitException.INSTANCE, userFuture, fallback, call);
        } else if (currentState == CircuitBreakerState.HALF_OPEN) {
            if (this.passed.incrementAndGet() == 1) {
                operationResult.future().onComplete(event -> context.runOnContext(v -> {
                    if (event.failed()) {
                        this.open();
                        if (call != null) {
                            call.failed();
                        }
                        if (this.options.isFallbackOnFailure()) {
                            this.invokeFallback(event.cause(), userFuture, fallback, call);
                        } else {
                            userFuture.fail(event.cause());
                        }
                    } else {
                        if (call != null) {
                            call.complete();
                        }
                        this.reset();
                        userFuture.complete(event.result());
                    }
                }));
                this.executeOperation(context, command, operationResult, call);
            } else {
                if (call != null) {
                    call.shortCircuited();
                }
                this.invokeFallback(OpenCircuitException.INSTANCE, userFuture, fallback, call);
            }
        }
        return this;
    }

    private <T> Promise<T> retryFuture(Context context, int retryCount, Handler<Promise<T>> command, Promise<T> operationResult, CircuitBreakerMetrics.Operation call) {
        Promise retry = Promise.promise();
        retry.future().onComplete(event -> {
            CircuitBreakerState currentState;
            if (event.succeeded()) {
                this.reset();
                context.runOnContext(v -> operationResult.complete(event.result()));
                return;
            }
            CircuitBreakerImpl circuitBreakerImpl = this;
            synchronized (circuitBreakerImpl) {
                currentState = this.state;
            }
            if (currentState == CircuitBreakerState.CLOSED) {
                if (retryCount < this.options.getMaxRetries() - 1) {
                    this.executeRetryWithTimeout(event.cause(), retryCount, (Handler<Void>)((Handler)l -> context.runOnContext(v -> this.executeOperation(context, command, this.retryFuture(context, retryCount + 1, command, operationResult, null), call))));
                } else {
                    this.executeRetryWithTimeout(event.cause(), retryCount, (Handler<Void>)((Handler)l -> context.runOnContext(v -> this.executeOperation(context, command, operationResult, call))));
                }
            } else {
                context.runOnContext(v -> operationResult.fail((Throwable)OpenCircuitException.INSTANCE));
            }
        });
        return retry;
    }

    private void executeRetryWithTimeout(Throwable failure, int retryCount, Handler<Void> action) {
        long retryTimeout = this.retryPolicy.delay(failure, retryCount + 1);
        if (retryTimeout > 0L) {
            this.vertx.setTimer(retryTimeout, l -> action.handle(null));
        } else {
            action.handle(null);
        }
    }

    private <T> void invokeFallback(Throwable reason, Promise<T> userFuture, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation operation) {
        block4: {
            if (fallback == null) {
                userFuture.fail(reason);
                return;
            }
            try {
                T apply = fallback.apply(reason);
                if (operation != null) {
                    operation.fallbackSucceed();
                }
                userFuture.complete(apply);
            }
            catch (Exception e) {
                userFuture.fail((Throwable)e);
                if (operation == null) break block4;
                operation.fallbackFailed();
            }
        }
    }

    private <T> void executeOperation(Context context, Handler<Promise<T>> operation, Promise<T> operationResult, CircuitBreakerMetrics.Operation call) {
        Promise passedFuture = Promise.promise();
        if (this.options.getTimeout() != -1L) {
            long timerId = this.vertx.setTimer(this.options.getTimeout(), l -> context.runOnContext(v -> {
                if (!operationResult.future().isComplete()) {
                    if (call != null) {
                        call.timeout();
                    }
                    operationResult.fail((Throwable)TimeoutException.INSTANCE);
                }
            }));
            passedFuture.future().onComplete(v -> this.vertx.cancelTimer(timerId));
        }
        try {
            passedFuture.future().onComplete(ar -> context.runOnContext(v -> {
                if (ar.failed()) {
                    if (!operationResult.future().isComplete()) {
                        operationResult.fail(ar.cause());
                    }
                } else if (!operationResult.future().isComplete()) {
                    operationResult.complete(ar.result());
                }
            }));
            operation.handle((Object)passedFuture);
        }
        catch (Throwable e) {
            context.runOnContext(v -> {
                if (!operationResult.future().isComplete()) {
                    if (call != null) {
                        call.error();
                    }
                    operationResult.fail(e);
                }
            });
        }
    }

    @Override
    public <T> Future<T> executeWithFallback(Handler<Promise<T>> operation, Function<Throwable, T> fallback) {
        Promise future = Promise.promise();
        this.executeAndReportWithFallback(future, operation, fallback);
        return future.future();
    }

    @Override
    public <T> Future<T> execute(Handler<Promise<T>> operation) {
        return this.executeWithFallback(operation, this.fallback);
    }

    @Override
    public <T> CircuitBreaker executeAndReport(Promise<T> resultFuture, Handler<Promise<T>> operation) {
        return this.executeAndReportWithFallback(resultFuture, operation, this.fallback);
    }

    @Override
    public String name() {
        return this.name;
    }

    private synchronized void incrementFailures() {
        this.rollingFailures.increment();
        if (this.rollingFailures.count() >= (long)this.options.getMaxFailures()) {
            if (this.state != CircuitBreakerState.OPEN) {
                this.open();
            } else {
                this.sendUpdateOnEventBus();
            }
        } else {
            this.sendUpdateOnEventBus();
        }
    }

    public JsonObject getMetrics() {
        return this.metrics.toJson();
    }

    public CircuitBreakerOptions options() {
        return this.options;
    }

    @Override
    public CircuitBreaker retryPolicy(Function<Integer, Long> retryPolicy) {
        this.retryPolicy = (failure, retryCount) -> (Long)retryPolicy.apply(retryCount);
        return this;
    }

    @Override
    public CircuitBreaker retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public static class RollingCounter {
        private Map<Long, Long> window;
        private long timeUnitsInWindow;
        private TimeUnit windowTimeUnit;

        public RollingCounter(long timeUnitsInWindow, TimeUnit windowTimeUnit) {
            this.windowTimeUnit = windowTimeUnit;
            this.window = new LinkedHashMap<Long, Long>((int)timeUnitsInWindow + 1);
            this.timeUnitsInWindow = timeUnitsInWindow;
        }

        public void increment() {
            Iterator<Long> iterator;
            long timeSlot = this.windowTimeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            Long current = this.window.getOrDefault(timeSlot, 0L);
            current = current + 1L;
            this.window.put(timeSlot, current);
            if ((long)this.window.size() > this.timeUnitsInWindow && (iterator = this.window.keySet().iterator()).hasNext()) {
                this.window.remove(iterator.next());
            }
        }

        public long count() {
            long windowStartTime = this.windowTimeUnit.convert(System.currentTimeMillis() - this.windowTimeUnit.toMillis(this.timeUnitsInWindow), TimeUnit.MILLISECONDS);
            return this.window.entrySet().stream().filter(entry -> (Long)entry.getKey() >= windowStartTime).mapToLong(entry -> (Long)entry.getValue()).sum();
        }

        public void reset() {
            this.window.clear();
        }
    }
}

