/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.HystrixMetricHandler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class HystrixMetricEventStream
implements HystrixMetricHandler {
    private final List<HttpServerResponse> connections = Collections.synchronizedList(new LinkedList());
    private AtomicInteger counter = new AtomicInteger();

    public HystrixMetricEventStream(Vertx vertx, String address, boolean localOnly) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(address);
        EventBus eventBus = vertx.eventBus();
        MessageConsumer consumer = localOnly ? eventBus.localConsumer(address) : eventBus.consumer(address);
        consumer.handler(message -> {
            JsonObject json = this.build((JsonObject)message.body());
            int id = this.counter.incrementAndGet();
            String chunk = json.encode() + "\n\n";
            this.connections.forEach(resp -> {
                try {
                    resp.write("id: " + id + "\n");
                    resp.write("data:" + chunk);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        });
    }

    private JsonObject build(JsonObject body) {
        String state = body.getString("state");
        JsonObject json = new JsonObject();
        json.put("type", (Object)"HystrixCommand");
        json.put("name", (Object)body.getString("name"));
        json.put("group", (Object)body.getString("node"));
        json.put("currentTime", (Object)System.currentTimeMillis());
        json.put("isCircuitBreakerOpen", (Object)state.equalsIgnoreCase(CircuitBreakerState.OPEN.toString()));
        json.put("errorPercentage", (Object)body.getInteger("rollingErrorPercentage", Integer.valueOf(0)));
        json.put("errorCount", (Object)body.getInteger("rollingErrorCount", Integer.valueOf(0)));
        json.put("requestCount", (Object)body.getInteger("rollingOperationCount", Integer.valueOf(0)));
        json.put("rollingCountCollapsedRequests", (Object)0);
        json.put("rollingCountExceptionsThrown", (Object)body.getInteger("rollingExceptionCount", Integer.valueOf(0)));
        json.put("rollingCountFailure", (Object)body.getInteger("rollingFailureCount", Integer.valueOf(0)));
        json.put("rollingCountTimeout", (Object)body.getInteger("rollingTimeoutCount", Integer.valueOf(0)));
        json.put("rollingCountFallbackFailure", (Object)body.getInteger("rollingFallbackFailureCount", Integer.valueOf(0)));
        json.put("rollingCountFallbackRejection", (Object)body.getInteger("fallbackRejection", Integer.valueOf(0)));
        json.put("rollingCountFallbackSuccess", (Object)body.getInteger("rollingFallbackSuccessCount", Integer.valueOf(0)));
        json.put("rollingCountResponsesFromCache", (Object)0);
        json.put("rollingCountSemaphoreRejected", (Object)0);
        json.put("rollingCountShortCircuited", (Object)body.getInteger("rollingShortCircuitedCount", Integer.valueOf(0)));
        json.put("rollingCountSuccess", (Object)body.getInteger("rollingSuccessCount", Integer.valueOf(0)));
        json.put("rollingCountThreadPoolRejected", (Object)0);
        json.put("rollingCountTimeout", (Object)body.getInteger("rollingTimeoutCount", Integer.valueOf(0)));
        json.put("rollingCountBadRequests", (Object)0);
        json.put("rollingCountEmit", (Object)0);
        json.put("rollingCountFallbackEmit", (Object)0);
        json.put("rollingCountFallbackMissing", (Object)0);
        json.put("rollingMaxConcurrentExecutionCount", (Object)0);
        json.put("currentConcurrentExecutionCount", (Object)0);
        json.put("latencyExecute_mean", (Object)body.getInteger("rollingLatencyMean", Integer.valueOf(0)));
        json.put("latencyExecute", (Object)body.getJsonObject("rollingLatency", new JsonObject()));
        json.put("latencyTotal_mean", (Object)body.getInteger("totalLatencyMean", Integer.valueOf(0)));
        json.put("latencyTotal", (Object)body.getJsonObject("totalLatency", new JsonObject()));
        json.put("propertyValue_circuitBreakerRequestVolumeThreshold", (Object)0);
        json.put("propertyValue_circuitBreakerSleepWindowInMilliseconds", (Object)body.getLong("resetTimeout", Long.valueOf(0L)));
        json.put("propertyValue_circuitBreakerErrorThresholdPercentage", (Object)0);
        json.put("propertyValue_circuitBreakerForceOpen", (Object)false);
        json.put("propertyValue_circuitBreakerForceClosed", (Object)false);
        json.put("propertyValue_circuitBreakerEnabled", (Object)true);
        json.put("propertyValue_executionIsolationStrategy", (Object)"THREAD");
        json.put("propertyValue_executionIsolationThreadTimeoutInMilliseconds", (Object)body.getLong("timeout", Long.valueOf(0L)));
        json.put("propertyValue_executionIsolationThreadInterruptOnTimeout", (Object)true);
        json.put("propertyValue_executionIsolationThreadPoolKeyOverride", (Object)"");
        json.put("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", (Object)0);
        json.put("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", (Object)0);
        json.put("propertyValue_metricsRollingStatisticalWindowInMilliseconds", (Object)body.getLong("metricRollingWindow", Long.valueOf(0L)));
        json.put("propertyValue_requestCacheEnabled", (Object)false);
        json.put("propertyValue_requestLogEnabled", (Object)false);
        json.put("reportingHosts", (Object)1);
        return json;
    }

    public void handle(RoutingContext rc) {
        HttpServerResponse response = rc.response();
        response.setChunked(true).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream").putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        rc.request().connection().closeHandler(v -> {
            this.connections.remove(response);
            HystrixMetricEventStream.endQuietly(response);
        }).exceptionHandler(t -> {
            this.connections.remove(response);
            rc.fail(t);
        });
        this.connections.add(response);
    }

    private static void endQuietly(HttpServerResponse response) {
        if (response.ended()) {
            return;
        }
        try {
            response.end();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

