/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker;

import io.vertx.circuitbreaker.CircuitBreakerOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class CircuitBreakerOptions {
    public static final long DEFAULT_TIMEOUT = 10000L;
    public static final int DEFAULT_MAX_FAILURES = 5;
    public static final boolean DEFAULT_FALLBACK_ON_FAILURE = false;
    public static final long DEFAULT_RESET_TIMEOUT = 30000L;
    public static final boolean DEFAULT_NOTIFICATION_LOCAL_ONLY = true;
    public static final String DEFAULT_NOTIFICATION_ADDRESS = "vertx.circuit-breaker";
    public static final long DEFAULT_NOTIFICATION_PERIOD = 2000L;
    public static final long DEFAULT_METRICS_ROLLING_WINDOW = 10000L;
    public static final int DEFAULT_METRICS_ROLLING_BUCKETS = 10;
    private static final int DEFAULT_MAX_RETRIES = 0;
    private static final int DEFAULT_FAILURES_ROLLING_WINDOW = 10000;
    private long timeout = 10000L;
    private int maxFailures = 5;
    private boolean fallbackOnFailure = false;
    private long resetTimeout = 30000L;
    private boolean notificationLocalOnly = true;
    private String notificationAddress = null;
    private long notificationPeriod = 2000L;
    private int maxRetries = 0;
    private long metricsRollingWindow = 10000L;
    private int metricsRollingBuckets = 10;
    private long failuresRollingWindow = 10000L;

    public CircuitBreakerOptions() {
    }

    public CircuitBreakerOptions(CircuitBreakerOptions other) {
        this.timeout = other.timeout;
        this.maxFailures = other.maxFailures;
        this.fallbackOnFailure = other.fallbackOnFailure;
        this.notificationLocalOnly = other.notificationLocalOnly;
        this.notificationAddress = other.notificationAddress;
        this.notificationPeriod = other.notificationPeriod;
        this.resetTimeout = other.resetTimeout;
        this.maxRetries = other.maxRetries;
        this.metricsRollingBuckets = other.metricsRollingBuckets;
        this.metricsRollingWindow = other.metricsRollingWindow;
        this.failuresRollingWindow = other.failuresRollingWindow;
    }

    public CircuitBreakerOptions(JsonObject json) {
        this();
        CircuitBreakerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CircuitBreakerOptionsConverter.toJson(this, json);
        return json;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public CircuitBreakerOptions setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CircuitBreakerOptions setTimeout(long timeoutInMs) {
        this.timeout = timeoutInMs;
        return this;
    }

    public boolean isFallbackOnFailure() {
        return this.fallbackOnFailure;
    }

    public CircuitBreakerOptions setFallbackOnFailure(boolean fallbackOnFailure) {
        this.fallbackOnFailure = fallbackOnFailure;
        return this;
    }

    public long getResetTimeout() {
        return this.resetTimeout;
    }

    public CircuitBreakerOptions setResetTimeout(long resetTimeout) {
        this.resetTimeout = resetTimeout;
        return this;
    }

    public boolean isNotificationLocalOnly() {
        return this.notificationLocalOnly;
    }

    public CircuitBreakerOptions setNotificationLocalOnly(boolean notificationLocalOnly) {
        this.notificationLocalOnly = notificationLocalOnly;
        return this;
    }

    public String getNotificationAddress() {
        return this.notificationAddress;
    }

    public CircuitBreakerOptions setNotificationAddress(String notificationAddress) {
        this.notificationAddress = notificationAddress;
        return this;
    }

    public long getNotificationPeriod() {
        return this.notificationPeriod;
    }

    public CircuitBreakerOptions setNotificationPeriod(long notificationPeriod) {
        this.notificationPeriod = notificationPeriod;
        return this;
    }

    public long getMetricsRollingWindow() {
        return this.metricsRollingWindow;
    }

    public CircuitBreakerOptions setMetricsRollingWindow(long metricsRollingWindow) {
        this.metricsRollingWindow = metricsRollingWindow;
        return this;
    }

    public long getFailuresRollingWindow() {
        return this.failuresRollingWindow;
    }

    public CircuitBreakerOptions setFailuresRollingWindow(long failureRollingWindow) {
        this.failuresRollingWindow = failureRollingWindow;
        return this;
    }

    public int getMetricsRollingBuckets() {
        return this.metricsRollingBuckets;
    }

    public CircuitBreakerOptions setMetricsRollingBuckets(int metricsRollingBuckets) {
        this.metricsRollingBuckets = metricsRollingBuckets;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public CircuitBreakerOptions setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }
}

