/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker;

import io.vertx.codegen.annotations.VertxGen;
import java.util.concurrent.ThreadLocalRandom;

@VertxGen
@FunctionalInterface
public interface RetryPolicy {
    public static RetryPolicy constantDelay(long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be strictly positive");
        }
        return (failure, retryCount) -> delay;
    }

    public static RetryPolicy linearDelay(long initialDelay, long maxDelay) {
        if (initialDelay <= 0L) {
            throw new IllegalArgumentException("initialDelay must be strictly positive");
        }
        if (maxDelay < initialDelay) {
            throw new IllegalArgumentException("maxDelay must be greater than initialDelay");
        }
        return (failure, retryCount) -> Math.min(maxDelay, initialDelay * (long)retryCount);
    }

    public static RetryPolicy exponentialDelayWithJitter(long initialDelay, long maxDelay) {
        if (initialDelay <= 0L) {
            throw new IllegalArgumentException("initialDelay must be strictly positive");
        }
        if (maxDelay < initialDelay) {
            throw new IllegalArgumentException("maxDelay must be greater than initialDelay");
        }
        return (failure, retryCount) -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            long delay = initialDelay * (1L << retryCount);
            return random.nextLong(0L, delay < 0L ? maxDelay : Math.min(maxDelay, delay));
        };
    }

    public long delay(Throwable var1, int var2);
}

