/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.FailurePolicy;
import io.vertx.circuitbreaker.OpenCircuitException;
import io.vertx.circuitbreaker.RetryPolicy;
import io.vertx.circuitbreaker.TimeoutException;
import io.vertx.circuitbreaker.impl.CircuitBreakerMetrics;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class CircuitBreakerImpl
implements CircuitBreaker {
    private static final Handler<Void> NOOP = v -> {};
    private final Vertx vertx;
    private final CircuitBreakerOptions options;
    private final String name;
    private final long periodicUpdateTask;
    private Handler<Void> openHandler = NOOP;
    private Handler<Void> halfOpenHandler = NOOP;
    private Handler<Void> closeHandler = NOOP;
    private Function fallback = null;
    private FailurePolicy failurePolicy = FailurePolicy.defaultPolicy();
    private CircuitBreakerState state = CircuitBreakerState.CLOSED;
    private RollingCounter rollingFailures;
    private final AtomicInteger passed = new AtomicInteger();
    private final CircuitBreakerMetrics metrics;
    private RetryPolicy retryPolicy = (failure, retryCount) -> 0L;

    public CircuitBreakerImpl(String name, Vertx vertx, CircuitBreakerOptions options) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(vertx);
        this.vertx = vertx;
        this.name = name;
        this.options = options == null ? new CircuitBreakerOptions() : new CircuitBreakerOptions(options);
        this.rollingFailures = new RollingCounter(this.options.getFailuresRollingWindow() / 1000L, TimeUnit.SECONDS);
        if (this.options.getNotificationAddress() != null) {
            this.metrics = new CircuitBreakerMetrics(vertx, this, this.options);
            this.sendUpdateOnEventBus();
            this.periodicUpdateTask = this.options.getNotificationPeriod() > 0L ? vertx.setPeriodic(this.options.getNotificationPeriod(), l -> this.sendUpdateOnEventBus()) : -1L;
        } else {
            this.metrics = null;
            this.periodicUpdateTask = -1L;
        }
    }

    @Override
    public CircuitBreaker close() {
        if (this.metrics != null) {
            if (this.periodicUpdateTask != -1L) {
                this.vertx.cancelTimer(this.periodicUpdateTask);
            }
            this.metrics.close();
        }
        return this;
    }

    @Override
    public synchronized CircuitBreaker openHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.openHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker halfOpenHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.halfOpenHandler = handler;
        return this;
    }

    @Override
    public synchronized CircuitBreaker closeHandler(Handler<Void> handler) {
        Objects.requireNonNull(handler);
        this.closeHandler = handler;
        return this;
    }

    @Override
    public <T> CircuitBreaker fallback(Function<Throwable, T> handler) {
        Objects.requireNonNull(handler);
        this.fallback = handler;
        return this;
    }

    @Override
    public <T> CircuitBreaker failurePolicy(FailurePolicy<T> failurePolicy) {
        Objects.requireNonNull(failurePolicy);
        this.failurePolicy = failurePolicy;
        return this;
    }

    public synchronized CircuitBreaker reset(boolean force) {
        this.rollingFailures.reset();
        if (this.state == CircuitBreakerState.CLOSED) {
            return this;
        }
        if (!force && this.state == CircuitBreakerState.OPEN) {
            return this;
        }
        this.state = CircuitBreakerState.CLOSED;
        this.closeHandler.handle(null);
        this.sendUpdateOnEventBus();
        return this;
    }

    @Override
    public synchronized CircuitBreaker reset() {
        return this.reset(false);
    }

    private synchronized void sendUpdateOnEventBus() {
        if (this.metrics != null) {
            DeliveryOptions deliveryOptions = new DeliveryOptions().setLocalOnly(this.options.isNotificationLocalOnly());
            this.vertx.eventBus().publish(this.options.getNotificationAddress(), (Object)this.metrics.toJson(), deliveryOptions);
        }
    }

    @Override
    public synchronized CircuitBreaker open() {
        this.state = CircuitBreakerState.OPEN;
        this.openHandler.handle(null);
        this.sendUpdateOnEventBus();
        long period = this.options.getResetTimeout();
        if (period != -1L) {
            this.vertx.setTimer(period, l -> this.attemptReset());
        }
        return this;
    }

    @Override
    public synchronized long failureCount() {
        return this.rollingFailures.count();
    }

    @Override
    public synchronized CircuitBreakerState state() {
        return this.state;
    }

    private synchronized CircuitBreaker attemptReset() {
        if (this.state == CircuitBreakerState.OPEN) {
            this.passed.set(0);
            this.state = CircuitBreakerState.HALF_OPEN;
            this.halfOpenHandler.handle(null);
            this.sendUpdateOnEventBus();
        }
        return this;
    }

    @Override
    public <T> CircuitBreaker executeAndReportWithFallback(Promise<T> resultPromise, Handler<Promise<T>> command, Function<Throwable, T> fallback) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        this.executeAndReportWithFallback(context, resultPromise, this.convert(context, command), fallback);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void executeAndReportWithFallback(ContextInternal context, Promise<T> resultPromise, Supplier<Future<T>> command, Function<Throwable, T> fallback) {
        CircuitBreakerState currentState;
        CircuitBreakerImpl circuitBreakerImpl = this;
        synchronized (circuitBreakerImpl) {
            currentState = this.state;
        }
        CircuitBreakerMetrics.Operation operationMetrics = this.metrics != null ? this.metrics.enqueue() : null;
        PromiseInternal operationResult = context.promise();
        if (currentState == CircuitBreakerState.CLOSED) {
            Future opFuture = operationResult.future();
            opFuture.onComplete(new ClosedCircuitCompletion<T>((Context)context, resultPromise, fallback, operationMetrics));
            if (this.options.getMaxRetries() > 0) {
                this.executeOperation(command, this.retryPromise(context, 0, command, (Promise<T>)operationResult, operationMetrics), operationMetrics);
            } else {
                this.executeOperation(command, (Promise<T>)operationResult, operationMetrics);
            }
        } else if (currentState == CircuitBreakerState.OPEN) {
            if (operationMetrics != null) {
                operationMetrics.shortCircuited();
            }
            this.invokeFallback(OpenCircuitException.INSTANCE, resultPromise, fallback, operationMetrics);
        } else if (currentState == CircuitBreakerState.HALF_OPEN) {
            if (this.passed.incrementAndGet() == 1) {
                Future opFuture = operationResult.future();
                opFuture.onComplete(new HalfOpenedCircuitCompletion<T>((Context)context, resultPromise, fallback, operationMetrics));
                this.executeOperation(command, (Promise<T>)operationResult, operationMetrics);
            } else {
                if (operationMetrics != null) {
                    operationMetrics.shortCircuited();
                }
                this.invokeFallback(OpenCircuitException.INSTANCE, resultPromise, fallback, operationMetrics);
            }
        }
    }

    private <T> Promise<T> retryPromise(ContextInternal context, int retryCount, Supplier<Future<T>> command, Promise<T> operationResult, CircuitBreakerMetrics.Operation operationMetrics) {
        PromiseInternal promise = context.promise();
        promise.future().onComplete(event -> {
            CircuitBreakerState currentState;
            if (event.succeeded()) {
                this.reset();
                operationResult.complete(event.result());
                return;
            }
            CircuitBreakerImpl circuitBreakerImpl = this;
            synchronized (circuitBreakerImpl) {
                currentState = this.state;
            }
            if (currentState == CircuitBreakerState.CLOSED) {
                if (retryCount < this.options.getMaxRetries() - 1) {
                    this.executeRetryWithDelay(event.cause(), retryCount, (Handler<Void>)((Handler)arg_0 -> this.lambda$retryPromise$4((Supplier)command, context, retryCount, operationResult, operationMetrics, arg_0)));
                } else {
                    this.executeRetryWithDelay(event.cause(), retryCount, (Handler<Void>)((Handler)arg_0 -> this.lambda$retryPromise$5((Supplier)command, operationResult, operationMetrics, arg_0)));
                }
            } else {
                operationResult.fail((Throwable)OpenCircuitException.INSTANCE);
            }
        });
        return promise;
    }

    private void executeRetryWithDelay(Throwable failure, int retryCount, Handler<Void> action) {
        long retryDelay = this.retryPolicy.delay(failure, retryCount + 1);
        if (retryDelay > 0L) {
            this.vertx.setTimer(retryDelay, l -> action.handle(null));
        } else {
            action.handle(null);
        }
    }

    private <T> void invokeFallback(Throwable reason, Promise<T> resultPromise, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation operationMetrics) {
        block4: {
            if (fallback == null) {
                resultPromise.fail(reason);
                return;
            }
            try {
                T apply = fallback.apply(reason);
                if (operationMetrics != null) {
                    operationMetrics.fallbackSucceed();
                }
                resultPromise.complete(apply);
            }
            catch (Exception e) {
                resultPromise.fail((Throwable)e);
                if (operationMetrics == null) break block4;
                operationMetrics.fallbackFailed();
            }
        }
    }

    private <T> Supplier<Future<T>> convert(ContextInternal context, Handler<Promise<T>> handler) {
        return () -> {
            PromiseInternal passedFuture = context.promise();
            handler.handle((Object)passedFuture);
            return passedFuture.future();
        };
    }

    private <T> void executeOperation(Supplier<Future<T>> supplier, Promise<T> operationResult, CircuitBreakerMetrics.Operation operationMetrics) {
        Future<T> fut;
        try {
            fut = supplier.get();
        }
        catch (Throwable e) {
            if (!operationResult.future().isComplete()) {
                if (operationMetrics != null) {
                    operationMetrics.error();
                }
                operationResult.fail(e);
            }
            return;
        }
        if (this.options.getTimeout() != -1L) {
            long timerId = this.vertx.setTimer(this.options.getTimeout(), l -> {
                if (!operationResult.future().isComplete()) {
                    if (operationMetrics != null) {
                        operationMetrics.timeout();
                    }
                    operationResult.fail((Throwable)TimeoutException.INSTANCE);
                }
            });
            fut.onComplete(v -> this.vertx.cancelTimer(timerId));
        }
        fut.onComplete(ar -> {
            if (ar.failed()) {
                if (!operationResult.future().isComplete()) {
                    operationResult.fail(ar.cause());
                }
            } else if (!operationResult.future().isComplete()) {
                operationResult.complete(ar.result());
            }
        });
    }

    @Override
    public <T> Future<T> executeWithFallback(Handler<Promise<T>> operation, Function<Throwable, T> fallback) {
        ContextInternal context = ContextInternal.current();
        Promise promise = context != null ? context.promise() : Promise.promise();
        this.executeAndReportWithFallback(promise, operation, fallback);
        return promise.future();
    }

    @Override
    public <T> Future<T> executeWithFallback(Supplier<Future<T>> command, Function<Throwable, T> fallback) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal resultPromise = context.promise();
        this.executeAndReportWithFallback(context, (Promise<T>)resultPromise, command, fallback);
        return resultPromise.future();
    }

    @Override
    public <T> Future<T> execute(Handler<Promise<T>> operation) {
        return this.executeWithFallback(operation, this.fallback);
    }

    @Override
    public <T> Future<T> execute(Supplier<Future<T>> command) {
        return this.executeWithFallback(command, this.fallback);
    }

    @Override
    public <T> CircuitBreaker executeAndReport(Promise<T> resultPromise, Handler<Promise<T>> operation) {
        return this.executeAndReportWithFallback(resultPromise, operation, this.fallback);
    }

    @Override
    public String name() {
        return this.name;
    }

    private synchronized void incrementFailures() {
        this.rollingFailures.increment();
        if (this.rollingFailures.count() >= (long)this.options.getMaxFailures()) {
            if (this.state != CircuitBreakerState.OPEN) {
                this.open();
            } else {
                this.sendUpdateOnEventBus();
            }
        } else {
            this.sendUpdateOnEventBus();
        }
    }

    public JsonObject getMetrics() {
        return this.metrics.toJson();
    }

    public CircuitBreakerOptions options() {
        return this.options;
    }

    @Override
    public CircuitBreaker retryPolicy(Function<Integer, Long> retryPolicy) {
        this.retryPolicy = (failure, retryCount) -> (Long)retryPolicy.apply(retryCount);
        return this;
    }

    @Override
    public CircuitBreaker retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private /* synthetic */ void lambda$retryPromise$5(Supplier command, Promise operationResult, CircuitBreakerMetrics.Operation operationMetrics, Void l) {
        this.executeOperation(command, operationResult, operationMetrics);
    }

    private /* synthetic */ void lambda$retryPromise$4(Supplier command, ContextInternal context, int retryCount, Promise operationResult, CircuitBreakerMetrics.Operation operationMetrics, Void l) {
        this.executeOperation(command, this.retryPromise(context, retryCount + 1, command, operationResult, null), operationMetrics);
    }

    private class HalfOpenedCircuitCompletion<T>
    extends Completion<T> {
        HalfOpenedCircuitCompletion(Context context, Promise<T> userFuture, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation call) {
            super(context, userFuture, fallback, call);
        }

        @Override
        protected void failureAction() {
            CircuitBreakerImpl.this.open();
        }
    }

    private class ClosedCircuitCompletion<T>
    extends Completion<T> {
        ClosedCircuitCompletion(Context context, Promise<T> userFuture, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation call) {
            super(context, userFuture, fallback, call);
        }

        @Override
        protected void failureAction() {
            CircuitBreakerImpl.this.incrementFailures();
        }
    }

    private abstract class Completion<T>
    implements Handler<AsyncResult<T>> {
        final Context context;
        final Promise<T> resultFuture;
        final Function<Throwable, T> fallback;
        final CircuitBreakerMetrics.Operation operationMetrics;

        protected Completion(Context context, Promise<T> resultFuture, Function<Throwable, T> fallback, CircuitBreakerMetrics.Operation operationMetrics) {
            this.context = context;
            this.resultFuture = resultFuture;
            this.fallback = fallback;
            this.operationMetrics = operationMetrics;
        }

        public void handle(AsyncResult<T> ar) {
            this.context.runOnContext(v -> {
                if (CircuitBreakerImpl.this.failurePolicy.test(this.asFuture(ar))) {
                    this.failureAction();
                    if (this.operationMetrics != null) {
                        this.operationMetrics.failed();
                    }
                    if (CircuitBreakerImpl.this.options.isFallbackOnFailure()) {
                        CircuitBreakerImpl.this.invokeFallback(ar.cause(), this.resultFuture, this.fallback, this.operationMetrics);
                    } else {
                        this.resultFuture.fail(ar.cause());
                    }
                } else {
                    if (this.operationMetrics != null) {
                        this.operationMetrics.complete();
                    }
                    CircuitBreakerImpl.this.reset();
                    this.resultFuture.handle(ar);
                }
            });
        }

        private Future<T> asFuture(AsyncResult<T> ar) {
            Future result = ar instanceof Future ? (Future)ar : (ar.succeeded() ? Future.succeededFuture((Object)ar.result()) : Future.failedFuture((Throwable)ar.cause()));
            return result;
        }

        protected abstract void failureAction();
    }

    static class RollingCounter {
        private Map<Long, Long> window;
        private long timeUnitsInWindow;
        private TimeUnit windowTimeUnit;

        public RollingCounter(final long timeUnitsInWindow, TimeUnit windowTimeUnit) {
            this.windowTimeUnit = windowTimeUnit;
            this.window = new LinkedHashMap<Long, Long>((int)timeUnitsInWindow + 1){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                    return (long)this.size() > timeUnitsInWindow;
                }
            };
            this.timeUnitsInWindow = timeUnitsInWindow;
        }

        public void increment() {
            long timeSlot = this.windowTimeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            Long current = this.window.getOrDefault(timeSlot, 0L);
            current = current + 1L;
            this.window.put(timeSlot, current);
        }

        public long count() {
            long windowStartTime = this.windowTimeUnit.convert(System.currentTimeMillis() - this.windowTimeUnit.toMillis(this.timeUnitsInWindow), TimeUnit.MILLISECONDS);
            long result = 0L;
            for (Map.Entry<Long, Long> entry : this.window.entrySet()) {
                if (entry.getKey() < windowStartTime) continue;
                result += entry.getValue().longValue();
            }
            return result;
        }

        public void reset() {
            this.window.clear();
        }
    }
}

