/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.impl.CircuitBreakerImpl;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class CircuitBreakerMetrics {
    private final CircuitBreakerImpl circuitBreaker;
    private final String node;
    private final long circuitBreakerResetTimeout;
    private final long circuitBreakerTimeout;
    private final RollingWindow rollingWindow;

    CircuitBreakerMetrics(Vertx vertx, CircuitBreakerImpl circuitBreaker, CircuitBreakerOptions options) {
        this.circuitBreaker = circuitBreaker;
        this.circuitBreakerTimeout = circuitBreaker.options().getTimeout();
        this.circuitBreakerResetTimeout = circuitBreaker.options().getResetTimeout();
        this.node = vertx.isClustered() ? ((VertxInternal)vertx).clusterManager().getNodeId() : "local";
        this.rollingWindow = new RollingWindow(options.getMetricsRollingWindow(), options.getMetricsRollingBuckets());
    }

    private synchronized void evictOutdatedOperations() {
        this.rollingWindow.updateTime();
    }

    public void close() {
    }

    Operation enqueue() {
        return new Operation();
    }

    public synchronized void complete(Operation operation) {
        this.rollingWindow.add(operation);
    }

    public synchronized JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("resetTimeout", (Object)this.circuitBreakerResetTimeout);
        json.put("timeout", (Object)this.circuitBreakerTimeout);
        json.put("metricRollingWindow", (Object)this.rollingWindow.getMetricRollingWindowSizeInMs());
        json.put("name", (Object)this.circuitBreaker.name());
        json.put("node", (Object)this.node);
        json.put("state", (Object)this.circuitBreaker.state());
        json.put("failures", (Object)this.circuitBreaker.failureCount());
        this.addSummary(json, this.rollingWindow.totalSummary(), MetricNames.TOTAL);
        this.evictOutdatedOperations();
        this.addSummary(json, this.rollingWindow.windowSummary(), MetricNames.ROLLING);
        return json;
    }

    private void addSummary(JsonObject json, RollingWindow.Summary summary, MetricNames names) {
        long calls = summary.count();
        int errorCount = summary.failures + summary.exceptions + summary.timeouts;
        json.put(names.operationCountName, (Object)(calls - (long)summary.shortCircuited));
        json.put(names.errorCountName, (Object)errorCount);
        json.put(names.successCountName, (Object)summary.successes);
        json.put(names.timeoutCountName, (Object)summary.timeouts);
        json.put(names.exceptionCountName, (Object)summary.exceptions);
        json.put(names.failureCountName, (Object)summary.failures);
        if (calls == 0L) {
            json.put(names.successPercentageName, (Object)0);
            json.put(names.errorPercentageName, (Object)0);
        } else {
            json.put(names.successPercentageName, (Object)((double)summary.successes / (double)calls * 100.0));
            json.put(names.errorPercentageName, (Object)((double)errorCount / (double)calls * 100.0));
        }
        json.put(names.fallbackSuccessCountName, (Object)summary.fallbackSuccess);
        json.put(names.fallbackFailureCountName, (Object)summary.fallbackFailure);
        json.put(names.shortCircuitedCountName, (Object)summary.shortCircuited);
        this.addLatency(json, summary.statistics, names);
    }

    private void addLatency(JsonObject json, Histogram histogram, MetricNames names) {
        json.put(names.latencyMeanName, (Object)histogram.getMean());
        json.put(names.latencyName, (Object)new JsonObject().put("0", (Object)histogram.getValueAtPercentile(0.0)).put("25", (Object)histogram.getValueAtPercentile(25.0)).put("50", (Object)histogram.getValueAtPercentile(50.0)).put("75", (Object)histogram.getValueAtPercentile(75.0)).put("90", (Object)histogram.getValueAtPercentile(90.0)).put("95", (Object)histogram.getValueAtPercentile(95.0)).put("99", (Object)histogram.getValueAtPercentile(99.0)).put("99.5", (Object)histogram.getValueAtPercentile(99.5)).put("100", (Object)histogram.getValueAtPercentile(100.0)));
    }

    private static class RollingWindow {
        private final Summary history;
        private final Summary[] buckets;
        private final long bucketSizeInNs;

        RollingWindow(long windowSizeInMs, int numberOfBuckets) {
            if (windowSizeInMs % (long)numberOfBuckets != 0L) {
                throw new IllegalArgumentException("Window size should be divisible by number of buckets.");
            }
            this.buckets = new Summary[numberOfBuckets];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Summary();
            }
            this.bucketSizeInNs = 1000000L * windowSizeInMs / (long)numberOfBuckets;
            this.history = new Summary();
        }

        public void add(Operation operation) {
            this.getBucket(operation.end).add(operation);
        }

        public Summary totalSummary() {
            Summary total = new Summary();
            total.add(this.history);
            total.add(this.windowSummary());
            return total;
        }

        public Summary windowSummary() {
            Summary window = new Summary(this.buckets[0].bucketIndex);
            for (Summary bucket : this.buckets) {
                window.add(bucket);
            }
            return window;
        }

        public void updateTime() {
            this.getBucket(System.nanoTime());
        }

        private Summary getBucket(long timeInNs) {
            long bucketIndex = timeInNs / this.bucketSizeInNs;
            if (bucketIndex < this.buckets[0].bucketIndex) {
                return this.history;
            }
            this.shiftIfNecessary(bucketIndex);
            return this.buckets[(int)(bucketIndex - this.buckets[0].bucketIndex)];
        }

        private void shiftIfNecessary(long bucketIndex) {
            int i;
            long shiftUnlimited = bucketIndex - this.buckets[this.buckets.length - 1].bucketIndex;
            if (shiftUnlimited <= 0L) {
                return;
            }
            int shift = (int)Long.min(this.buckets.length, shiftUnlimited);
            for (i = 0; i < shift; ++i) {
                this.history.add(this.buckets[i]);
            }
            System.arraycopy(this.buckets, shift, this.buckets, 0, this.buckets.length - shift);
            for (i = this.buckets.length - shift; i < this.buckets.length; ++i) {
                this.buckets[i] = new Summary(bucketIndex + (long)i + 1L - (long)this.buckets.length);
            }
        }

        public long getMetricRollingWindowSizeInMs() {
            return this.bucketSizeInNs * (long)this.buckets.length / 1000000L;
        }

        private static class Summary {
            final long bucketIndex;
            final Histogram statistics;
            private int successes;
            private int failures;
            private int exceptions;
            private int timeouts;
            private int fallbackSuccess;
            private int fallbackFailure;
            private int shortCircuited;

            private Summary() {
                this(-1L);
            }

            private Summary(long bucketIndex) {
                this.bucketIndex = bucketIndex;
                this.statistics = new Histogram(2);
            }

            public void add(Summary other) {
                this.statistics.add((AbstractHistogram)other.statistics);
                this.successes += other.successes;
                this.failures += other.failures;
                this.exceptions += other.exceptions;
                this.timeouts += other.timeouts;
                this.fallbackSuccess += other.fallbackSuccess;
                this.fallbackFailure += other.fallbackFailure;
                this.shortCircuited += other.shortCircuited;
            }

            public void add(Operation operation) {
                this.statistics.recordValue(operation.durationInMs());
                if (operation.complete) {
                    ++this.successes;
                } else if (operation.failed) {
                    ++this.failures;
                } else if (operation.exception) {
                    ++this.exceptions;
                } else if (operation.timeout) {
                    ++this.timeouts;
                }
                if (operation.fallbackSucceed) {
                    ++this.fallbackSuccess;
                } else if (operation.fallbackFailed) {
                    ++this.fallbackFailure;
                }
                if (operation.shortCircuited) {
                    ++this.shortCircuited;
                }
            }

            public long count() {
                return this.statistics.getTotalCount();
            }
        }
    }

    private static enum MetricNames {
        ROLLING("rolling"),
        TOTAL("total");

        private final String operationCountName;
        private final String errorCountName;
        private final String successCountName;
        private final String timeoutCountName;
        private final String exceptionCountName;
        private final String failureCountName;
        private final String successPercentageName;
        private final String errorPercentageName;
        private final String fallbackSuccessCountName;
        private final String fallbackFailureCountName;
        private final String shortCircuitedCountName;
        private final String latencyMeanName;
        private final String latencyName;

        private MetricNames(String prefix) {
            this.operationCountName = prefix + "OperationCount";
            this.errorCountName = prefix + "ErrorCount";
            this.successCountName = prefix + "SuccessCount";
            this.timeoutCountName = prefix + "TimeoutCount";
            this.exceptionCountName = prefix + "ExceptionCount";
            this.failureCountName = prefix + "FailureCount";
            this.successPercentageName = prefix + "SuccessPercentage";
            this.errorPercentageName = prefix + "ErrorPercentage";
            this.fallbackSuccessCountName = prefix + "FallbackSuccessCount";
            this.fallbackFailureCountName = prefix + "FallbackFailureCount";
            this.shortCircuitedCountName = prefix + "ShortCircuitedCount";
            this.latencyName = prefix + "Latency";
            this.latencyMeanName = prefix + "LatencyMean";
        }
    }

    class Operation {
        final long begin = System.nanoTime();
        private volatile long end;
        private boolean complete;
        private boolean failed;
        private boolean timeout;
        private boolean exception;
        private boolean fallbackFailed;
        private boolean fallbackSucceed;
        private boolean shortCircuited;

        Operation() {
        }

        synchronized void complete() {
            this.end = System.nanoTime();
            this.complete = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void failed() {
            if (this.timeout || this.exception) {
                return;
            }
            this.end = System.nanoTime();
            this.failed = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void timeout() {
            this.end = System.nanoTime();
            this.failed = false;
            this.timeout = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void error() {
            this.end = System.nanoTime();
            this.failed = false;
            this.exception = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void fallbackFailed() {
            this.fallbackFailed = true;
        }

        synchronized void fallbackSucceed() {
            this.fallbackSucceed = true;
        }

        synchronized void shortCircuited() {
            this.end = System.nanoTime();
            this.shortCircuited = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        long durationInMs() {
            return (this.end - this.begin) / 1000000L;
        }
    }
}

