/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.json.generator;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.format.KebabCase;
import io.vertx.codegen.format.LowerCamelCase;
import io.vertx.codegen.format.QualifiedCase;
import io.vertx.codegen.format.SnakeCase;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.codegen.processor.DataObjectModel;
import io.vertx.codegen.processor.Generator;
import io.vertx.codegen.processor.PropertyInfo;
import io.vertx.codegen.processor.type.AnnotationValueInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.DataObjectInfo;
import io.vertx.codegen.processor.type.MapperInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.writer.CodeWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class DataObjectJsonGen
extends Generator<DataObjectModel> {
    private Case formatter;
    private boolean isPublic;
    private boolean inheritConverter;
    private boolean generate;

    public DataObjectJsonGen() {
        this.kinds = Collections.singleton("dataObject");
        this.name = "data_object_converters";
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Collections.singletonList(DataObject.class);
    }

    public String filename(DataObjectModel model) {
        if (model.isClass() && this.findJsonGenAnnotation(model) != null) {
            return model.getFqn() + "Converter.java";
        }
        return null;
    }

    private AnnotationValueInfo findJsonGenAnnotation(DataObjectModel model) {
        for (AnnotationValueInfo ann : model.getAnnotations()) {
            if (!ann.getName().equals(JsonGen.class.getName())) continue;
            return ann;
        }
        return null;
    }

    public String render(DataObjectModel model, int index, int size, Map<String, Object> session) {
        AnnotationValueInfo jsonGenAnn = this.findJsonGenAnnotation(model);
        ClassTypeInfo cti = this.getFormatter(model, JsonGen.class, "jsonPropertyNameFormatter");
        this.formatter = this.getCase(cti);
        this.isPublic = jsonGenAnn.getMember("publicConverter") == Boolean.TRUE;
        this.inheritConverter = jsonGenAnn.getMember("inheritConverter") == Boolean.TRUE;
        this.generate = true;
        return this.renderJson(model);
    }

    private ClassTypeInfo getFormatter(DataObjectModel model, Class<? extends Annotation> annType, String annotationName) {
        AnnotationValueInfo abc = model.getAnnotations().stream().filter(ann -> ann.getName().equals(annType.getName())).findFirst().get();
        return (ClassTypeInfo)abc.getMember(annotationName);
    }

    public String renderJson(DataObjectModel model) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        CodeWriter code = new CodeWriter((Writer)writer);
        String visibility = this.isPublic ? "public" : "";
        writer.print("package " + model.getType().getPackageName() + ";\n");
        writer.print("\n");
        writer.print("import io.vertx.core.json.JsonObject;\n");
        writer.print("import io.vertx.core.json.JsonArray;\n");
        writer.print("import java.time.Instant;\n");
        writer.print("import java.time.format.DateTimeFormatter;\n");
        writer.print("\n");
        writer.print("/**\n");
        writer.print(" * Converter and mapper for {@link " + model.getType() + "}.\n");
        writer.print(" * NOTE: This class has been automatically generated from the {@link " + model.getType() + "} original class using Vert.x codegen.\n");
        writer.print(" */\n");
        code.codeln("public class " + model.getType().getSimpleName() + "Converter {").newLine();
        if (this.generate) {
            this.genFromJson(visibility, this.inheritConverter, model, writer);
            writer.print("\n");
            this.genToJson(visibility, this.inheritConverter, model, writer);
        }
        writer.print("}\n");
        return buffer.toString();
    }

    private void genToJson(String visibility, boolean inheritConverter, DataObjectModel model_, PrintWriter writer) {
        String simpleName = model_.getType().getSimpleName();
        writer.print("  " + visibility + " static void toJson(" + simpleName + " obj, JsonObject json) {\n");
        writer.print("    toJson(obj, json.getMap());\n");
        writer.print("  }\n");
        writer.print("\n");
        writer.print("  " + visibility + " static void toJson(" + simpleName + " obj, java.util.Map<String, Object> json) {\n");
        model_.getPropertyMap().values().forEach(prop -> {
            if ((prop.isDeclared() || inheritConverter) && prop.getGetterMethod() != null && prop.isJsonifiable()) {
                ClassKind propKind = prop.getType().getKind();
                if (propKind.basic) {
                    if (propKind == ClassKind.STRING) {
                        this.genPropToJson("", "", (PropertyInfo)prop, writer);
                    } else {
                        switch (prop.getType().getSimpleName()) {
                            case "char": 
                            case "Character": {
                                this.genPropToJson("Character.toString(", ")", (PropertyInfo)prop, writer);
                                break;
                            }
                            default: {
                                this.genPropToJson("", "", (PropertyInfo)prop, writer);
                                break;
                            }
                        }
                    }
                } else {
                    DataObjectInfo dataObject = prop.getType().getDataObject();
                    if (dataObject != null) {
                        if (dataObject.isSerializable()) {
                            Object match;
                            Object m;
                            MapperInfo mapperInfo = dataObject.getSerializer();
                            switch (mapperInfo.getKind()) {
                                case SELF: {
                                    m = "";
                                    match = "." + String.join((CharSequence)".", mapperInfo.getSelectors()) + "()";
                                    break;
                                }
                                case STATIC_METHOD: {
                                    m = mapperInfo.getQualifiedName() + "." + String.join((CharSequence)".", mapperInfo.getSelectors()) + "(";
                                    match = ")";
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException();
                                }
                            }
                            this.genPropToJson((String)m, (String)match, (PropertyInfo)prop, writer);
                        }
                    } else {
                        switch (propKind) {
                            case ENUM: {
                                this.genPropToJson("", ".name()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case JSON_OBJECT: 
                            case JSON_ARRAY: 
                            case OBJECT: {
                                this.genPropToJson("", "", (PropertyInfo)prop, writer);
                                break;
                            }
                            case OTHER: {
                                if (!prop.getType().getName().equals(Instant.class.getName())) break;
                                this.genPropToJson("DateTimeFormatter.ISO_INSTANT.format(", ")", (PropertyInfo)prop, writer);
                            }
                        }
                    }
                }
            }
        });
        writer.print("  }\n");
    }

    private void genPropToJson(String before, String after, PropertyInfo prop, PrintWriter writer) {
        String jsonPropertyName = LowerCamelCase.INSTANCE.to(this.formatter, prop.getName());
        String indent = "    ";
        if (prop.isList() || prop.isSet()) {
            writer.print(indent + "if (obj." + prop.getGetterMethod() + "() != null) {\n");
            writer.print(indent + "  JsonArray array = new JsonArray();\n");
            writer.print(indent + "  obj." + prop.getGetterMethod() + "().forEach(item -> array.add(" + before + "item" + after + "));\n");
            writer.print(indent + "  json.put(\"" + jsonPropertyName + "\", array);\n");
            writer.print(indent + "}\n");
        } else if (prop.isMap()) {
            writer.print(indent + "if (obj." + prop.getGetterMethod() + "() != null) {\n");
            writer.print(indent + "  JsonObject map = new JsonObject();\n");
            writer.print(indent + "  obj." + prop.getGetterMethod() + "().forEach((key, value) -> map.put(key, " + before + "value" + after + "));\n");
            writer.print(indent + "  json.put(\"" + jsonPropertyName + "\", map);\n");
            writer.print(indent + "}\n");
        } else {
            String sp = "";
            if (prop.getType().getKind() != ClassKind.PRIMITIVE) {
                sp = "  ";
                writer.print(indent + "if (obj." + prop.getGetterMethod() + "() != null) {\n");
            }
            writer.print(indent + sp + "json.put(\"" + jsonPropertyName + "\", " + before + "obj." + prop.getGetterMethod() + "()" + after + ");\n");
            if (prop.getType().getKind() != ClassKind.PRIMITIVE) {
                writer.print(indent + "}\n");
            }
        }
    }

    private void genFromJson(String visibility, boolean inheritConverter, DataObjectModel model_, PrintWriter writer) {
        writer.print("  " + visibility + " static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, " + model_.getType().getSimpleName() + " obj) {\n");
        writer.print("    for (java.util.Map.Entry<String, Object> member : json) {\n");
        writer.print("      switch (member.getKey()) {\n");
        model_.getPropertyMap().values().forEach(prop -> {
            if (prop.isDeclared() || inheritConverter) {
                ClassKind propKind = prop.getType().getKind();
                if (propKind.basic) {
                    if (propKind == ClassKind.STRING) {
                        this.genPropFromJson("String", "(String)", "", (PropertyInfo)prop, writer);
                    } else {
                        switch (prop.getType().getSimpleName()) {
                            case "boolean": 
                            case "Boolean": {
                                this.genPropFromJson("Boolean", "(Boolean)", "", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "byte": 
                            case "Byte": {
                                this.genPropFromJson("Number", "((Number)", ").byteValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "short": 
                            case "Short": {
                                this.genPropFromJson("Number", "((Number)", ").shortValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "int": 
                            case "Integer": {
                                this.genPropFromJson("Number", "((Number)", ").intValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "long": 
                            case "Long": {
                                this.genPropFromJson("Number", "((Number)", ").longValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "float": 
                            case "Float": {
                                this.genPropFromJson("Number", "((Number)", ").floatValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "double": 
                            case "Double": {
                                this.genPropFromJson("Number", "((Number)", ").doubleValue()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case "char": 
                            case "Character": {
                                this.genPropFromJson("String", "((String)", ").charAt(0)", (PropertyInfo)prop, writer);
                            }
                        }
                    }
                } else {
                    TypeInfo type = prop.getType();
                    DataObjectInfo dataObject = type.getDataObject();
                    if (dataObject != null) {
                        if (dataObject.isDeserializable()) {
                            String simpleName;
                            String match;
                            MapperInfo mapper = dataObject.getDeserializer();
                            TypeInfo jsonType = mapper.getJsonType();
                            switch (mapper.getKind()) {
                                case SELF: {
                                    match = "new " + type.getName() + "((" + mapper.getJsonType().getName() + ")";
                                    simpleName = jsonType.getSimpleName();
                                    break;
                                }
                                case STATIC_METHOD: {
                                    match = mapper.getQualifiedName() + "." + String.join((CharSequence)".", mapper.getSelectors()) + "((" + jsonType.getSimpleName() + ")";
                                    simpleName = jsonType.getSimpleName();
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            this.genPropFromJson(simpleName, match, ")", (PropertyInfo)prop, writer);
                        }
                    } else {
                        switch (propKind) {
                            case JSON_OBJECT: {
                                this.genPropFromJson("JsonObject", "((JsonObject)", ").copy()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case JSON_ARRAY: {
                                this.genPropFromJson("JsonArray", "((JsonArray)", ").copy()", (PropertyInfo)prop, writer);
                                break;
                            }
                            case ENUM: {
                                this.genPropFromJson("String", prop.getType().getName() + ".valueOf((String)", ")", (PropertyInfo)prop, writer);
                                break;
                            }
                            case OBJECT: {
                                this.genPropFromJson("Object", "", "", (PropertyInfo)prop, writer);
                                break;
                            }
                            case OTHER: {
                                if (!prop.getType().getName().equals(Instant.class.getName())) break;
                                this.genPropFromJson("String", "Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)", "))", (PropertyInfo)prop, writer);
                                break;
                            }
                        }
                    }
                }
            }
        });
        writer.print("      }\n");
        writer.print("    }\n");
        writer.print("  }\n");
    }

    private void genPropFromJson(String cast, String before, String after, PropertyInfo prop, PrintWriter writer) {
        String jsonPropertyName = LowerCamelCase.INSTANCE.to(this.formatter, prop.getName());
        String indent = "        ";
        writer.print(indent + "case \"" + jsonPropertyName + "\":\n");
        if (prop.isList() || prop.isSet()) {
            writer.print(indent + "  if (member.getValue() instanceof JsonArray) {\n");
            if (prop.isSetter()) {
                String coll = prop.isList() ? "java.util.ArrayList" : "java.util.LinkedHashSet";
                writer.print(indent + "    " + coll + "<" + prop.getType().getName() + "> list =  new " + coll + "<>();\n");
                writer.print(indent + "    ((Iterable<Object>)member.getValue()).forEach( item -> {\n");
                writer.print(indent + "      if (item instanceof " + cast + ")\n");
                writer.print(indent + "        list.add(" + before + "item" + after + ");\n");
                writer.print(indent + "    });\n");
                writer.print(indent + "    obj." + prop.getSetterMethod() + "(list);\n");
            } else if (prop.isAdder()) {
                writer.print(indent + "    ((Iterable<Object>)member.getValue()).forEach( item -> {\n");
                writer.print(indent + "      if (item instanceof " + cast + ")\n");
                writer.print(indent + "        obj." + prop.getAdderMethod() + "(" + before + "item" + after + ");\n");
                writer.print(indent + "    });\n");
            }
            writer.print(indent + "  }\n");
        } else if (prop.isMap()) {
            writer.print(indent + "  if (member.getValue() instanceof JsonObject) {\n");
            if (prop.isAdder()) {
                writer.print(indent + "    ((Iterable<java.util.Map.Entry<String, Object>>)member.getValue()).forEach(entry -> {\n");
                writer.print(indent + "      if (entry.getValue() instanceof " + cast + ")\n");
                writer.print(indent + "        obj." + prop.getAdderMethod() + "(entry.getKey(), " + before + "entry.getValue()" + after + ");\n");
                writer.print(indent + "    });\n");
            } else if (prop.isSetter()) {
                writer.print(indent + "    java.util.Map<String, " + prop.getType().getName() + "> map = new java.util.LinkedHashMap<>();\n");
                writer.print(indent + "    ((Iterable<java.util.Map.Entry<String, Object>>)member.getValue()).forEach(entry -> {\n");
                writer.print(indent + "      if (entry.getValue() instanceof " + cast + ")\n");
                writer.print(indent + "        map.put(entry.getKey(), " + before + "entry.getValue()" + after + ");\n");
                writer.print(indent + "    });\n");
                writer.print(indent + "    obj." + prop.getSetterMethod() + "(map);\n");
            }
            writer.print(indent + "  }\n");
        } else if (prop.isSetter()) {
            writer.print(indent + "  if (member.getValue() instanceof " + cast + ") {\n");
            writer.print(indent + "    obj." + prop.getSetterMethod() + "(" + before + "member.getValue()" + after + ");\n");
            writer.print(indent + "  }\n");
        }
        writer.print(indent + "  break;\n");
    }

    private Case getCase(ClassTypeInfo cti) {
        switch (cti.getName()) {
            case "io.vertx.codegen.format.CamelCase": {
                return CamelCase.INSTANCE;
            }
            case "io.vertx.codegen.format.SnakeCase": {
                return SnakeCase.INSTANCE;
            }
            case "io.vertx.codegen.format.LowerCamelCase": {
                return LowerCamelCase.INSTANCE;
            }
            case "io.vertx.codegen.format.KebabCase": {
                return KebabCase.INSTANCE;
            }
            case "io.vertx.codegen.format.QualifiedCase": {
                return QualifiedCase.INSTANCE;
            }
        }
        throw new UnsupportedOperationException("Todo");
    }
}

