/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.ClassKind;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.annotations.Options;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class OptionsModel
implements Model {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final TypeInfo.Factory typeFactory;
    private final TypeElement modelElt;
    private boolean processed = false;
    private boolean concrete;
    private final Map<String, PropertyInfo> propertyMap = new LinkedHashMap<String, PropertyInfo>();
    private final Set<TypeInfo.Class> superTypes = new LinkedHashSet<TypeInfo.Class>();
    private TypeInfo.Class superType;
    private final Set<TypeInfo.Class> abstractSuperTypes = new LinkedHashSet<TypeInfo.Class>();
    private final Set<TypeInfo.Class> importedTypes = new LinkedHashSet<TypeInfo.Class>();
    private TypeInfo.Class type;

    public OptionsModel(Elements elementUtils, Types typeUtils, TypeElement modelElt) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.typeFactory = new TypeInfo.Factory(elementUtils, typeUtils);
        this.modelElt = modelElt;
    }

    @Override
    public String getKind() {
        return "options";
    }

    @Override
    public Element getElement() {
        return this.modelElt;
    }

    @Override
    public String getFqn() {
        return this.type.getName();
    }

    public boolean isAbstract() {
        return !this.concrete;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<TypeInfo.Class> getImportedTypes() {
        return this.importedTypes;
    }

    public Map<String, PropertyInfo> getPropertyMap() {
        return this.propertyMap;
    }

    public TypeInfo.Class getSuperType() {
        return this.superType;
    }

    public Set<TypeInfo.Class> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public Set<TypeInfo.Class> getSuperTypes() {
        return this.superTypes;
    }

    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    @Override
    public Map<String, Object> getVars() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.type);
        vars.put("concrete", this.concrete);
        vars.put("properties", this.propertyMap.values());
        vars.put("importedTypes", this.importedTypes);
        vars.put("superTypes", this.superTypes);
        vars.put("superType", this.superType);
        vars.put("abstractSuperTypes", this.abstractSuperTypes);
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        return vars;
    }

    boolean process() {
        if (!this.processed) {
            if (this.modelElt.getKind() == ElementKind.INTERFACE || this.modelElt.getKind() == ElementKind.CLASS) {
                this.traverse();
                this.processImportedTypes();
                this.processed = true;
                return true;
            }
            throw new GenException(this.modelElt, "Options " + this.modelElt + " must be an interface or a class");
        }
        return false;
    }

    private void traverse() {
        boolean hasJsonConstructor;
        this.concrete = this.modelElt.getKind() == ElementKind.CLASS;
        try {
            this.type = (TypeInfo.Class)this.typeFactory.create(this.modelElt.asType());
        }
        catch (ClassCastException e2) {
            throw new GenException(this.modelElt, "Options must be a plain java class with no type parameters");
        }
        if (this.getModule() == null) {
            throw new GenException(this.modelElt, "Options must have an ancestor package annotated with @ModuleGen");
        }
        this.modelElt.getInterfaces().stream().filter(superTM -> superTM instanceof DeclaredType && ((DeclaredType)superTM).asElement().getAnnotation(Options.class) != null).map(e -> (TypeInfo.Class)this.typeFactory.create((TypeMirror)e)).forEach(this.abstractSuperTypes::add);
        this.superTypes.addAll(this.abstractSuperTypes);
        TypeMirror superClass = this.modelElt.getSuperclass();
        if (superClass instanceof DeclaredType && ((DeclaredType)superClass).asElement().getAnnotation(Options.class) != null) {
            this.superType = (TypeInfo.Class)this.typeFactory.create(superClass);
            this.superTypes.add(this.superType);
        }
        int result = 0;
        for (Element element : this.elementUtils.getAllMembers(this.modelElt)) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    ExecutableElement constrElt = (ExecutableElement)element;
                    result |= this.processConstructor(constrElt);
                    break;
                }
                case METHOD: {
                    ExecutableElement methodElt = (ExecutableElement)element;
                    this.processMethod(methodElt);
                    break;
                }
            }
        }
        boolean hasDefaultConstructor = (result & 2) == 2;
        boolean bl = (result & 4) == 4;
        boolean bl2 = hasJsonConstructor = (result & 8) == 8;
        if (this.concrete && !hasDefaultConstructor) {
            throw new GenException(this.modelElt, "Options " + this.modelElt + " class does not have a default constructor");
        }
        if (this.concrete && !bl) {
            throw new GenException(this.modelElt, "Options " + this.modelElt + " class does not have a constructor " + this.modelElt.getSimpleName() + "(" + this.modelElt.getSimpleName() + ") ");
        }
        if (this.concrete && !hasJsonConstructor) {
            throw new GenException(this.modelElt, "Options " + this.modelElt + " class does not have a constructor " + this.modelElt.getSimpleName() + "(" + JsonObject.class.getSimpleName() + ")");
        }
    }

    private void processImportedTypes() {
        for (PropertyInfo property : this.propertyMap.values()) {
            property.type.collectImports(this.importedTypes);
        }
        this.importedTypes.addAll(this.superTypes.stream().collect(Collectors.toList()));
        Iterator<TypeInfo.Class> i = this.importedTypes.iterator();
        while (i.hasNext()) {
            TypeInfo.Class importedType = i.next();
            if (!importedType.getPackageName().equals(this.type.getPackageName())) continue;
            i.remove();
        }
    }

    private int processConstructor(ExecutableElement constrElt) {
        Element ownerElt;
        if (constrElt.getModifiers().contains((Object)Modifier.PUBLIC) && (ownerElt = constrElt.getEnclosingElement()).equals(this.modelElt)) {
            TypeInfo ti;
            List<? extends VariableElement> parameters = constrElt.getParameters();
            int size = parameters.size();
            if (size == 0) {
                return 2;
            }
            if (size == 1 && (ti = this.typeFactory.create(parameters.get(0).asType())) instanceof TypeInfo.Class) {
                TypeInfo.Class cl = (TypeInfo.Class)ti;
                if (cl.fqcn.equals(this.getFqn())) {
                    return 4;
                }
                if (cl.getKind() == ClassKind.JSON_OBJECT) {
                    return 8;
                }
            }
        }
        return 0;
    }

    private void processMethod(ExecutableElement methodElt) {
        String methodName = methodElt.getSimpleName().toString();
        if (methodName.length() > 3) {
            String prefix = methodName.substring(0, 3);
            String name = Helper.normalizePropertyName(methodName.substring(3));
            List<? extends VariableElement> parameters = methodElt.getParameters();
            switch (prefix) {
                case "add": 
                case "set": {
                    boolean declared;
                    boolean adder;
                    boolean array;
                    if (parameters.size() != 1) {
                        return;
                    }
                    VariableElement parameterElt = parameters.get(0);
                    TypeInfo type = this.typeFactory.create(parameterElt.asType());
                    if ("add".equals(prefix)) {
                        if (name.endsWith("s")) {
                            throw new GenException(methodElt, "Option adder name must not terminate with 's' char");
                        }
                        name = name + "s";
                        array = true;
                        adder = true;
                    } else {
                        adder = false;
                        if (type.getKind() == ClassKind.LIST) {
                            type = ((TypeInfo.Parameterized)type).getArgs().get(0);
                            array = true;
                        } else {
                            array = false;
                        }
                    }
                    switch (type.getKind()) {
                        case PRIMITIVE: 
                        case BOXED_PRIMITIVE: 
                        case STRING: 
                        case OPTIONS: 
                        case API: 
                        case JSON_OBJECT: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Element ownerElt = methodElt.getEnclosingElement();
                    if (ownerElt.equals(this.modelElt)) {
                        declared = true;
                        for (TypeMirror typeMirror : this.modelElt.getInterfaces()) {
                            DeclaredType superDT = (DeclaredType)typeMirror;
                            if (superDT.asElement().getAnnotation(Options.class) == null) continue;
                            for (Element element : this.elementUtils.getAllMembers((TypeElement)superDT.asElement())) {
                                if (!(element instanceof ExecutableElement) || !this.elementUtils.overrides(methodElt, (ExecutableElement)element, this.modelElt)) continue;
                                declared = false;
                            }
                        }
                    } else {
                        declared = ownerElt.getAnnotation(Options.class) == null;
                    }
                    PropertyInfo property = new PropertyInfo(declared, name, type, methodName, array, adder);
                    if (this.propertyMap.containsKey(property.name)) {
                        // empty if block
                    }
                    this.propertyMap.put(property.name, property);
                    return;
                }
            }
        }
    }
}

