/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public enum Case {
    CAMEL{

        @Override
        public String format(Iterable<String> atoms) {
            StringBuilder sb = new StringBuilder();
            for (String atom : atoms) {
                if (atom.length() <= 0) continue;
                char c = atom.charAt(0);
                if (Character.isLowerCase(c)) {
                    sb.append(Character.toUpperCase(c));
                    sb.append(atom, 1, atom.length());
                    continue;
                }
                sb.append(atom);
            }
            return sb.toString();
        }

        @Override
        public List<String> parse(String name) {
            String[] atoms = name.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
            if (atoms.length == 1 && atoms[0].isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(atoms);
        }
    }
    ,
    QUALIFIED{
        private final Pattern validator = Pattern.compile("(?:\\p{Alnum}|(?:(?<=\\p{Alnum})\\.(?=\\p{Alnum})))*");

        @Override
        public String format(Iterable<String> atoms) {
            StringBuilder sb = new StringBuilder();
            for (String atom : atoms) {
                if (atom.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(atom);
            }
            return sb.toString();
        }

        @Override
        public List<String> parse(String name) {
            if (!this.validator.matcher(name).matches()) {
                throw new IllegalArgumentException("Invalid qualified case:" + name);
            }
            return Case.split(name, "\\.");
        }
    }
    ,
    KEBAB{
        private final Pattern validator = Pattern.compile("(?:\\p{Alnum}|(?:(?<=\\p{Alnum})-(?=\\p{Alnum})))*");

        @Override
        public String format(Iterable<String> atoms) {
            StringBuilder sb = new StringBuilder();
            for (String atom : atoms) {
                if (atom.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('-');
                }
                sb.append(atom.toLowerCase());
            }
            return sb.toString();
        }

        @Override
        public List<String> parse(String name) {
            if (!this.validator.matcher(name).matches()) {
                throw new IllegalArgumentException("Invalid kebab case:" + name);
            }
            return Case.split(name, "\\-");
        }
    }
    ,
    SNAKE{
        private final Pattern validator = Pattern.compile("(?:\\p{Alnum}|(?:(?<=\\p{Alnum})_(?=\\p{Alnum})))*");

        @Override
        public String format(Iterable<String> atoms) {
            StringBuilder sb = new StringBuilder();
            for (String atom : atoms) {
                if (atom.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('_');
                }
                sb.append(atom.toLowerCase());
            }
            return sb.toString();
        }

        @Override
        public List<String> parse(String name) {
            if (!this.validator.matcher(name).matches()) {
                throw new IllegalArgumentException("Invalid snake case:" + name);
            }
            return Case.split(name, "_");
        }
    };


    public abstract String format(Iterable<String> var1);

    public abstract List<String> parse(String var1);

    private static List<String> split(String s, String regex) {
        String[] atoms = s.split(regex);
        if (atoms.length == 1 && atoms[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(atoms);
    }

    public static Map<String, Case> vars() {
        HashMap<String, Case> vars = new HashMap<String, Case>();
        for (Case _case : Case.values()) {
            vars.put("CASE_" + _case.name(), _case);
        }
        return vars;
    }
}

