/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.CamelCase;
import io.vertx.codegen.KebabCase;
import io.vertx.codegen.QualifiedCase;
import io.vertx.codegen.SnakeCase;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Case {
    public static final Case CAMEL = new CamelCase();
    public static final Case QUALIFIED = new QualifiedCase();
    public static final Case KEBAB = new KebabCase();
    public static final Case SNAKE = new SnakeCase();

    public String name() {
        throw new UnsupportedOperationException();
    }

    public String format(Iterable<String> atoms) {
        throw new UnsupportedOperationException();
    }

    public List<String> parse(String name) {
        throw new UnsupportedOperationException();
    }

    protected static List<String> split(String s, String regex) {
        String[] atoms = s.split(regex);
        if (atoms.length == 1 && atoms[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(atoms);
    }

    public static Map<String, Case> vars() {
        HashMap<String, Case> vars = new HashMap<String, Case>();
        for (Case _case : Arrays.asList(CAMEL, QUALIFIED, SNAKE, KEBAB)) {
            vars.put("CASE_" + _case.name(), _case);
        }
        return vars;
    }
}

