/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ModuleModel;
import io.vertx.codegen.PackageModel;
import io.vertx.codegen.ProxyModel;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenModule;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.overloadcheck.MethodOverloadChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class CodeGen {
    private static final Logger logger = Logger.getLogger(CodeGen.class.getName());
    private final HashMap<String, TypeElement> dataObjects = new HashMap();
    private final HashMap<String, TypeElement> classes = new HashMap();
    private final HashMap<String, PackageElement> modules = new HashMap();
    private final HashMap<String, TypeElement> proxyClasses = new HashMap();
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Messager messager;
    private final MethodOverloadChecker methodOverloadChecker = new MethodOverloadChecker();

    public CodeGen(ProcessingEnvironment env, RoundEnvironment round) {
        this.messager = env.getMessager();
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        Predicate<Element> implFilter = elt -> {
            String fqn = this.elementUtils.getPackageOf((Element)elt).getQualifiedName().toString();
            if (fqn.contains(".impl.") || fqn.endsWith(".impl")) {
                logger.warning("Processed element " + elt + " is in an implementation package");
                return false;
            }
            return true;
        };
        round.getElementsAnnotatedWith(DataObject.class).stream().filter(implFilter).forEach(element -> this.dataObjects.put(Helper.getNonGenericType(element.asType().toString()), (TypeElement)element));
        round.getElementsAnnotatedWith(VertxGen.class).stream().filter(implFilter).forEach(element -> this.classes.put(Helper.getNonGenericType(element.asType().toString()), (TypeElement)element));
        round.getElementsAnnotatedWith(GenModule.class).stream().map(element -> (PackageElement)element).forEach(element -> this.modules.put(element.getQualifiedName().toString(), (PackageElement)element));
        round.getElementsAnnotatedWith(ProxyGen.class).stream().filter(implFilter).forEach(element -> this.proxyClasses.put(Helper.getNonGenericType(element.asType().toString()), (TypeElement)element));
    }

    public Stream<Map.Entry<? extends Element, ? extends Model>> getModels() {
        return Stream.concat(this.getDataObjectModels(), Stream.concat(this.getModuleModels(), Stream.concat(this.getPackageModels(), Stream.concat(this.getClassModels(), this.getProxyModels()))));
    }

    public Stream<Map.Entry<TypeElement, ClassModel>> getClassModels() {
        return this.classes.entrySet().stream().map(entry -> new ModelEntry((Element)entry.getValue(), () -> this.getClassModel((String)entry.getKey()), null));
    }

    public Stream<Map.Entry<PackageElement, PackageModel>> getPackageModels() {
        return this.classes.values().stream().map(this.elementUtils::getPackageOf).distinct().map(element -> new ModelEntry((Element)element, () -> new PackageModel(element.getQualifiedName().toString(), ModuleInfo.resolve(this.elementUtils, element)), null));
    }

    public Stream<Map.Entry<PackageElement, ModuleModel>> getModuleModels() {
        return this.modules.entrySet().stream().map(entry -> new ModelEntry((Element)entry.getValue(), () -> this.getModuleModel((String)entry.getKey()), null));
    }

    public Stream<Map.Entry<TypeElement, DataObjectModel>> getDataObjectModels() {
        return this.dataObjects.entrySet().stream().map(element -> new ModelEntry((Element)element.getValue(), () -> this.getDataObjectModel((String)element.getKey()), null));
    }

    public Stream<Map.Entry<TypeElement, ProxyModel>> getProxyModels() {
        return this.proxyClasses.entrySet().stream().map(entry -> new ModelEntry((Element)entry.getValue(), () -> this.getProxyModel((String)entry.getKey()), null));
    }

    public ModuleModel getModuleModel(String modulePackageName) {
        PackageElement element = this.modules.get(modulePackageName);
        GenModule annotation = element.getAnnotation(GenModule.class);
        String moduleName = annotation.name();
        if (moduleName.isEmpty()) {
            throw new GenException(element, "A module name cannot be empty");
        }
        try {
            Case.KEBAB.parse(moduleName);
        }
        catch (IllegalArgumentException e) {
            throw new GenException(element, "Module name '" + moduleName + "' does not follow the snake case format (dash separated name)");
        }
        String groupPackageName = annotation.groupPackageName();
        if (!modulePackageName.startsWith(groupPackageName)) {
            throw new GenException(element, "A module package name (" + modulePackageName + ") must be prefixed by the group package name (" + groupPackageName + ")");
        }
        try {
            Case.QUALIFIED.parse(groupPackageName);
        }
        catch (Exception e) {
            throw new GenException(element, "Invalid group package name " + groupPackageName);
        }
        return new ModuleModel(element, new ModuleInfo(modulePackageName, moduleName, groupPackageName));
    }

    public PackageModel getPackageModel(String fqn) {
        return this.getPackageModels().filter(pkg -> ((PackageModel)pkg.getValue()).getFqn().equals(fqn)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public ClassModel getClassModel(String fqcn) {
        TypeElement element = this.classes.get(fqcn);
        if (element == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        ClassModel model = new ClassModel(this.methodOverloadChecker, this.messager, this.classes, this.elementUtils, this.typeUtils, element);
        model.process();
        return model;
    }

    public DataObjectModel getDataObjectModel(String fqcn) {
        TypeElement element = this.dataObjects.get(fqcn);
        if (element == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        DataObjectModel model = new DataObjectModel(this.elementUtils, this.typeUtils, element, this.messager);
        model.process();
        return model;
    }

    public ProxyModel getProxyModel(String fqcn) {
        TypeElement element = this.proxyClasses.get(fqcn);
        if (element == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        ProxyModel model = new ProxyModel(this.methodOverloadChecker, this.messager, this.classes, this.elementUtils, this.typeUtils, element);
        model.process();
        return model;
    }

    private static class ModelEntry<E extends Element, M extends Model>
    implements Map.Entry<E, M> {
        private final E key;
        private final Supplier<M> supplier;
        private M value;

        private ModelEntry(E key, Supplier<M> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @Override
        public E getKey() {
            return this.key;
        }

        @Override
        public M getValue() {
            if (this.value == null) {
                this.value = (Model)this.supplier.get();
            }
            return this.value;
        }

        @Override
        public M setValue(M value) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ ModelEntry(Element x0, Supplier x1, 1 x2) {
            this(x0, x1);
        }
    }
}

