/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.doc;

import io.vertx.codegen.Helper;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.doc.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Doc {
    private static final Pattern TAG_START = Pattern.compile("\n\\p{javaWhitespace}*@([^\\p{javaWhitespace}]+)", 8);
    private static final Pattern BODY_START = Pattern.compile("\n{2,}");
    final Text firstSentence;
    final Text body;
    final List<Tag> blockTags;

    public static Doc create(String javadoc) {
        String first;
        Matcher matcher = TAG_START.matcher(javadoc);
        ArrayList<Tag> blockTags = new ArrayList<Tag>();
        if (matcher.find()) {
            int prev;
            String name;
            first = javadoc.substring(0, matcher.start());
            while (true) {
                name = matcher.group(1);
                prev = matcher.end() + 1;
                if (!matcher.find()) break;
                blockTags.add(new Tag(name, javadoc.substring(prev, matcher.start())));
            }
            blockTags.add(new Tag(name, javadoc.substring(prev)));
        } else {
            first = javadoc;
        }
        matcher = BODY_START.matcher(first);
        String body = null;
        if (matcher.find()) {
            body = first.substring(matcher.end());
            first = first.substring(0, matcher.start());
        }
        return new Doc(first, body, blockTags);
    }

    public Doc(Text firstSentence) {
        this(firstSentence, null);
    }

    public Doc(Text firstSentence, Text body) {
        this(firstSentence, body, Collections.emptyList());
    }

    public Doc(Text firstSentence, Text body, List<Tag> blockTags) {
        this.firstSentence = firstSentence;
        this.body = body;
        this.blockTags = blockTags;
    }

    public Doc(String firstSentence) {
        this(firstSentence, null);
    }

    public Doc(String firstSentence, String body) {
        this(firstSentence, body, Collections.emptyList());
    }

    public Doc(String firstSentence, String body, List<Tag> blockTags) {
        this.firstSentence = new Text(firstSentence);
        this.body = body != null ? new Text(body) : null;
        this.blockTags = blockTags;
    }

    public List<Token> getTokens() {
        if (this.body != null) {
            ArrayList<Token> tokens = new ArrayList<Token>(this.firstSentence.tokens.size() + 2 + this.body.tokens.size());
            tokens.addAll(this.firstSentence.tokens);
            tokens.add(new Token.LineBreak("\n"));
            tokens.add(new Token.LineBreak("\n"));
            tokens.addAll(this.body.tokens);
            return tokens;
        }
        return this.firstSentence.getTokens();
    }

    public Text getFirstSentence() {
        return this.firstSentence;
    }

    public Text getBody() {
        return this.body;
    }

    public List<Tag> getBlockTags() {
        return this.blockTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.firstSentence);
        if (this.body != null) {
            sb.append("\n\n").append(this.body);
        }
        for (Tag blockTag : this.blockTags) {
            sb.append("\n").append(blockTag);
        }
        return sb.toString();
    }

    public static class Factory {
        private static final Pattern LINK_REFERENCE_PATTERN = Pattern.compile("^\\s*(" + Helper.LINK_REFERENCE_PATTERN.pattern() + ")");
        private final Messager messager;
        private final Elements elementUtils;
        private final Types typeUtils;
        private final TypeInfo.Factory typeFactory;
        private final TypeElement ownerElt;

        public Factory(Messager messager, Elements elementUtils, Types typeUtils, TypeInfo.Factory typeFactory, TypeElement ownerElt) {
            this.messager = messager;
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
            this.typeFactory = typeFactory;
            this.ownerElt = ownerElt;
        }

        public Doc createDoc(Element elt) {
            String docComment = this.elementUtils.getDocComment(elt);
            if (docComment != null) {
                Doc doc = Doc.create(docComment);
                Function<Token, Token> mapper = token -> {
                    Matcher matcher;
                    Tag tag;
                    if (token.isInlineTag() && (tag = ((Token.InlineTag)token).getTag()).getName().equals("link") && (matcher = LINK_REFERENCE_PATTERN.matcher(tag.getValue())).find()) {
                        Element resolvedElt = Helper.resolveSignature(this.elementUtils, this.typeUtils, this.ownerElt, matcher.group(1));
                        if (resolvedElt != null) {
                            DeclaredType resolvedType = (DeclaredType)Helper.getElementTypeOf(resolvedElt).asType();
                            Tag.Link tagLink = new Tag.Link(tag.getValue(), resolvedElt, this.typeFactory.create(resolvedType), tag.getValue().substring(matcher.end()));
                            token = new Token.InlineTag(token.getValue(), tagLink);
                        } else {
                            String msg = "Could not resolve documentation link " + tag;
                            this.messager.printMessage(Diagnostic.Kind.WARNING, msg, elt);
                        }
                    }
                    return token;
                };
                return new Doc(doc.getFirstSentence().map(mapper), doc.getBody() != null ? doc.getBody().map(mapper) : null, doc.getBlockTags());
            }
            return null;
        }
    }
}

