/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.doc.Doc;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class DataObjectModel
implements Model {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Doc.Factory docFactory;
    private final TypeInfo.Factory typeFactory;
    private final TypeElement modelElt;
    private boolean processed = false;
    private boolean concrete;
    private boolean isClass;
    private boolean generateConverter;
    private boolean inheritConverter;
    private final Map<String, PropertyInfo> propertyMap = new LinkedHashMap<String, PropertyInfo>();
    private final Set<TypeInfo.Class> superTypes = new LinkedHashSet<TypeInfo.Class>();
    private TypeInfo.Class superType;
    private final Set<TypeInfo.Class> abstractSuperTypes = new LinkedHashSet<TypeInfo.Class>();
    private final Set<TypeInfo.Class> importedTypes = new LinkedHashSet<TypeInfo.Class>();
    private TypeInfo.Class type;
    private Doc doc;
    private boolean jsonifiable;

    public DataObjectModel(Elements elementUtils, Types typeUtils, TypeElement modelElt, Messager messager) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.typeFactory = new TypeInfo.Factory(elementUtils, typeUtils);
        this.docFactory = new Doc.Factory(messager, elementUtils, typeUtils, this.typeFactory, modelElt);
        this.modelElt = modelElt;
    }

    @Override
    public String getKind() {
        return "dataObject";
    }

    @Override
    public Element getElement() {
        return this.modelElt;
    }

    @Override
    public String getFqn() {
        return this.type.getName();
    }

    public TypeInfo.Class getType() {
        return this.type;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public boolean isAbstract() {
        return !this.concrete;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<TypeInfo.Class> getImportedTypes() {
        return this.importedTypes;
    }

    public Map<String, PropertyInfo> getPropertyMap() {
        return this.propertyMap;
    }

    public TypeInfo.Class getSuperType() {
        return this.superType;
    }

    public Set<TypeInfo.Class> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public Set<TypeInfo.Class> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean getGenerateConverter() {
        return this.generateConverter;
    }

    public boolean isJsonifiable() {
        return this.jsonifiable;
    }

    public boolean getInheritConverter() {
        return this.inheritConverter;
    }

    @Override
    public Map<String, Object> getVars() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.type);
        vars.put("doc", this.doc);
        vars.put("generateConverter", this.generateConverter);
        vars.put("inheritConverter", this.inheritConverter);
        vars.put("concrete", this.concrete);
        vars.put("isClass", this.isClass);
        vars.put("properties", this.propertyMap.values());
        vars.put("importedTypes", this.importedTypes);
        vars.put("superTypes", this.superTypes);
        vars.put("superType", this.superType);
        vars.put("abstractSuperTypes", this.abstractSuperTypes);
        vars.put("jsonifiable", this.jsonifiable);
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        vars.putAll(Case.vars());
        return vars;
    }

    boolean process() {
        if (!this.processed) {
            if (this.modelElt.getKind() == ElementKind.INTERFACE || this.modelElt.getKind() == ElementKind.CLASS) {
                this.traverse();
                this.processImportedTypes();
                this.processed = true;
                return true;
            }
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " must be an interface or a class");
        }
        return false;
    }

    private void traverse() {
        boolean hasJsonConstructor;
        DataObject ann = this.modelElt.getAnnotation(DataObject.class);
        this.generateConverter = ann.generateConverter();
        this.inheritConverter = ann.inheritConverter();
        this.isClass = this.modelElt.getKind() == ElementKind.CLASS;
        this.concrete = this.isClass && !this.modelElt.getModifiers().contains((Object)Modifier.ABSTRACT);
        try {
            this.type = (TypeInfo.Class)this.typeFactory.create(this.modelElt.asType());
        }
        catch (ClassCastException e2) {
            throw new GenException(this.modelElt, "Data object must be a plain java class with no type parameters");
        }
        Helper.checkUnderModule(this, "@VertxGen");
        this.doc = this.docFactory.createDoc(this.modelElt);
        if (this.getModule() == null) {
            throw new GenException(this.modelElt, "Data object must have an ancestor package annotated with @ModuleGen");
        }
        this.modelElt.getInterfaces().stream().filter(superTM -> superTM instanceof DeclaredType && ((DeclaredType)superTM).asElement().getAnnotation(DataObject.class) != null).map(e -> (TypeInfo.Class)this.typeFactory.create((TypeMirror)e)).forEach(this.abstractSuperTypes::add);
        this.superTypes.addAll(this.abstractSuperTypes);
        TypeMirror superClass = this.modelElt.getSuperclass();
        if (superClass instanceof DeclaredType && ((DeclaredType)superClass).asElement().getAnnotation(DataObject.class) != null) {
            this.superType = (TypeInfo.Class)this.typeFactory.create(superClass);
            this.superTypes.add(this.superType);
        }
        int result = 0;
        for (Element element : this.elementUtils.getAllMembers(this.modelElt)) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    ExecutableElement constrElt = (ExecutableElement)element;
                    result |= this.processConstructor(constrElt);
                    break;
                }
                case METHOD: {
                    ExecutableElement methodElt = (ExecutableElement)element;
                    if (methodElt.getSimpleName().toString().equals("toJson") && methodElt.getParameters().isEmpty() && this.typeFactory.create(methodElt.getReturnType()).getKind() == ClassKind.JSON_OBJECT) {
                        this.jsonifiable = true;
                    }
                    if (methodElt.getAnnotation(GenIgnore.class) != null) break;
                    this.processMethod(methodElt);
                    break;
                }
            }
        }
        boolean hasDefaultConstructor = (result & 2) == 2;
        boolean bl = (result & 4) == 4;
        boolean bl2 = hasJsonConstructor = (result & 8) == 8;
        if (this.concrete && !hasDefaultConstructor) {
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " class does not have a default constructor");
        }
        if (this.concrete && !bl) {
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " class does not have a constructor " + this.modelElt.getSimpleName() + "(" + this.modelElt.getSimpleName() + ") ");
        }
        if (this.concrete && !hasJsonConstructor) {
            throw new GenException(this.modelElt, "Data object " + this.modelElt + " class does not have a constructor " + this.modelElt.getSimpleName() + "(" + JsonObject.class.getSimpleName() + ")");
        }
        ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>(this.propertyMap.values());
        Collections.sort(props, (p1, p2) -> p1.name.compareTo(p2.name));
        this.propertyMap.clear();
        props.forEach(prop -> this.propertyMap.put(prop.name, (PropertyInfo)prop));
    }

    private void processImportedTypes() {
        for (PropertyInfo property : this.propertyMap.values()) {
            property.type.collectImports(this.importedTypes);
        }
        this.importedTypes.addAll(this.superTypes.stream().collect(Collectors.toList()));
        Iterator<TypeInfo.Class> i = this.importedTypes.iterator();
        while (i.hasNext()) {
            TypeInfo.Class importedType = i.next();
            if (!importedType.getPackageName().equals(this.type.getPackageName())) continue;
            i.remove();
        }
    }

    private int processConstructor(ExecutableElement constrElt) {
        Element ownerElt;
        if (constrElt.getModifiers().contains((Object)Modifier.PUBLIC) && (ownerElt = constrElt.getEnclosingElement()).equals(this.modelElt)) {
            TypeInfo ti;
            List<? extends VariableElement> parameters = constrElt.getParameters();
            int size = parameters.size();
            if (size == 0) {
                return 2;
            }
            if (size == 1 && (ti = this.typeFactory.create(parameters.get(0).asType())) instanceof TypeInfo.Class) {
                TypeInfo.Class cl = (TypeInfo.Class)ti;
                if (cl.name.equals(this.getFqn())) {
                    return 4;
                }
                if (cl.getKind() == ClassKind.JSON_OBJECT) {
                    return 8;
                }
            }
        }
        return 0;
    }

    private void processMethod(ExecutableElement methodElt) {
        String mutatorMethod = methodElt.getSimpleName().toString();
        if (mutatorMethod.length() > 3) {
            String prefix = mutatorMethod.substring(0, 3);
            String abc = mutatorMethod.substring(3);
            String name = Helper.normalizePropertyName(abc);
            List<? extends VariableElement> parameters = methodElt.getParameters();
            switch (prefix) {
                case "add": 
                case "set": {
                    Object[] arr;
                    TypeMirror readerType;
                    boolean jsonifiable;
                    PropertyKind kind;
                    if (parameters.size() != 1) {
                        return;
                    }
                    VariableElement paramElt = parameters.get(0);
                    TypeMirror propTypeMirror = paramElt.asType();
                    TypeInfo propType = this.typeFactory.create(propTypeMirror);
                    if ("add".equals(prefix)) {
                        if (name.endsWith("s")) {
                            throw new GenException(methodElt, "Option adder name must not terminate with 's' char");
                        }
                        name = name + "s";
                        kind = PropertyKind.LIST_ADD;
                    } else {
                        switch (propType.getKind()) {
                            case LIST: {
                                propType = ((TypeInfo.Parameterized)propType).getArgs().get(0);
                                kind = PropertyKind.LIST;
                                break;
                            }
                            case MAP: {
                                propType = ((TypeInfo.Parameterized)propType).getArgs().get(1);
                                kind = PropertyKind.MAP;
                                break;
                            }
                            default: {
                                kind = PropertyKind.VALUE;
                            }
                        }
                    }
                    switch (propType.getKind()) {
                        case OBJECT: 
                        case PRIMITIVE: 
                        case BOXED_PRIMITIVE: 
                        case STRING: 
                        case API: 
                        case JSON_OBJECT: 
                        case JSON_ARRAY: 
                        case ENUM: {
                            jsonifiable = true;
                            break;
                        }
                        case DATA_OBJECT: {
                            TypeMirror jsonType = this.elementUtils.getTypeElement("io.vertx.core.json.JsonObject").asType();
                            Element propTypeElt = this.typeUtils.asElement(propTypeMirror);
                            jsonifiable = propTypeElt.getAnnotation(DataObject.class) == null || this.elementUtils.getAllMembers((TypeElement)propTypeElt).stream().flatMap(Helper.FILTER_METHOD).filter(exeElt -> exeElt.getSimpleName().toString().equals("toJson") && this.typeUtils.isSameType(jsonType, exeElt.getReturnType())).count() > 0L;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    String readerMethod = (propType.getName().equals("boolean") || propType.getName().equals("java.lang.Boolean")) && kind == PropertyKind.VALUE ? "is" + abc : "get" + abc + (kind.isAdder() ? "s" : "");
                    if (kind.isAdder()) {
                        TypeElement listType = this.elementUtils.getTypeElement("java.util.List");
                        TypeMirror eltType = propTypeMirror;
                        if (eltType instanceof PrimitiveType) {
                            eltType = this.typeUtils.boxedClass((PrimitiveType)eltType).asType();
                        }
                        readerType = this.typeUtils.getDeclaredType(listType, eltType);
                    } else {
                        readerType = propTypeMirror;
                    }
                    boolean hasReader = this.elementUtils.getAllMembers(this.modelElt).stream().flatMap(Helper.FILTER_METHOD).filter(elt -> elt.getSimpleName().toString().equals(readerMethod)).filter(elt -> this.typeUtils.isSameType(elt.getReturnType(), readerType)).count() > 0L;
                    Function<Boolean, Stream> overridenMeths = annotated -> {
                        Set<DeclaredType> ancestorTypes = Helper.resolveAncestorTypes(this.modelElt, true, true);
                        return ancestorTypes.stream().map(DeclaredType::asElement).filter(elt -> annotated == false || elt.getAnnotation(DataObject.class) != null).flatMap(Helper.cast(TypeElement.class)).flatMap(elt -> this.elementUtils.getAllMembers((TypeElement)elt).stream()).flatMap(Helper.instanceOf(ExecutableElement.class)).filter(executableElt -> executableElt.getKind() == ElementKind.METHOD && this.elementUtils.overrides(methodElt, (ExecutableElement)executableElt, this.modelElt));
                    };
                    Element ownerElt = methodElt.getEnclosingElement();
                    boolean declared = ownerElt.equals(this.modelElt) ? (arr = overridenMeths.apply(true).limit(1L).filter(elt -> !elt.getModifiers().contains((Object)Modifier.ABSTRACT)).toArray()).length == 0 : ownerElt.getAnnotation(DataObject.class) == null;
                    Doc doc = this.docFactory.createDoc(methodElt);
                    if (doc == null) {
                        Optional<Doc> first = overridenMeths.apply(false).map(this.docFactory::createDoc).filter(d -> d != null).findFirst();
                        doc = first.orElse(null);
                    }
                    PropertyInfo property = new PropertyInfo(declared, name, doc, propType, mutatorMethod, hasReader ? readerMethod : null, kind, jsonifiable);
                    this.propertyMap.put(property.name, property);
                }
            }
        }
    }
}

