/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.codegen.Case;
import io.vertx.codegen.CodeGen;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.Template;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeNameTranslator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.mvel2.MVEL;

@SupportedOptions(value={"outputDirectory", "codeGenerators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodeGenProcessor
extends AbstractProcessor {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(CodeGenProcessor.class.getName());
    private File outputDirectory;
    private Map<String, List<CodeGenerator>> codeGenerators;
    Map<File, GeneratedFile> generatedFiles = new HashMap<File, GeneratedFile>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Arrays.asList(VertxGen.class, ProxyGen.class, DataObject.class, DataObject.class, ModuleGen.class).stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generatedFiles.clear();
    }

    private Collection<CodeGenerator> getCodeGenerators() {
        if (this.codeGenerators == null) {
            String codeGeneratorsOption;
            LinkedHashMap<String, List<CodeGenerator>> codeGenerators = new LinkedHashMap<String, List<CodeGenerator>>();
            Enumeration<Object> descriptors = Collections.emptyEnumeration();
            try {
                descriptors = CodeGenProcessor.class.getClassLoader().getResources("codegen.json");
            }
            catch (IOException ignore) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator descriptors");
            }
            HashSet<String> templates = new HashSet<String>();
            while (descriptors.hasMoreElements()) {
                URL descriptor = (URL)descriptors.nextElement();
                try {
                    Scanner scanner = new Scanner(descriptor.openStream(), "UTF-8").useDelimiter("\\A");
                    Throwable throwable = null;
                    try {
                        String s = scanner.next();
                        ObjectNode obj = (ObjectNode)mapper.readTree(s);
                        String name = obj.get("name").asText();
                        ArrayNode generatorsCfg = (ArrayNode)obj.get("generators");
                        for (JsonNode generator : generatorsCfg) {
                            boolean incremental;
                            String kind = generator.get("kind").asText();
                            String templateFileName = generator.get("templateFileName").asText();
                            String fileName = generator.get("fileName").asText();
                            boolean bl = incremental = generator.has("incremental") && generator.get("incremental").asBoolean();
                            if (templates.contains(templateFileName)) continue;
                            templates.add(templateFileName);
                            Serializable fileNameExpression = MVEL.compileExpression((String)fileName);
                            Template compiledTemplate = new Template(templateFileName);
                            compiledTemplate.setOptions(this.processingEnv.getOptions());
                            List generators = codeGenerators.computeIfAbsent(name, abc -> new ArrayList());
                            generators.add(new CodeGenerator(name, kind, incremental, fileNameExpression, compiledTemplate));
                            log.info("Loaded " + name + " code generator");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                catch (Exception e) {
                    String msg = "Could not load code generator " + descriptor;
                    log.log(Level.SEVERE, msg, e);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                }
            }
            String outputDirectoryOption = this.processingEnv.getOptions().get("outputDirectory");
            if (outputDirectoryOption != null) {
                this.outputDirectory = new File(outputDirectoryOption);
                if (!this.outputDirectory.exists()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " does not exist");
                }
                if (!this.outputDirectory.isDirectory()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " is not a directory");
                }
            }
            if ((codeGeneratorsOption = this.processingEnv.getOptions().get("codeGenerators")) != null) {
                Set wanted = Stream.of(codeGeneratorsOption.split(",")).map(String::trim).collect(Collectors.toSet());
                if (codeGenerators.keySet().containsAll(wanted)) {
                    codeGenerators.keySet().retainAll(wanted);
                } else {
                    codeGenerators.clear();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Code generators " + wanted.removeAll(codeGenerators.keySet()) + " not found");
                }
            }
            this.codeGenerators = codeGenerators;
        }
        ArrayList<CodeGenerator> ret = new ArrayList<CodeGenerator>();
        this.codeGenerators.values().stream().forEach(ret::addAll);
        return ret;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<CodeGenerator> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv, roundEnv);
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        if (this.outputDirectory != null) {
                            HashMap<String, Object> vars = new HashMap<String, Object>();
                            vars.put("helper", new Helper());
                            vars.put("options", this.processingEnv.getOptions());
                            vars.put("fileSeparator", File.separator);
                            vars.put("fqn", model.getFqn());
                            vars.put("module", model.getModule());
                            vars.put("model", model);
                            vars.putAll(model.getVars());
                            vars.putAll(ClassKind.vars());
                            vars.putAll(MethodKind.vars());
                            vars.putAll(Case.vars());
                            for (CodeGenerator codeGenerator : codeGenerators) {
                                String relativeName;
                                Map<String, Object> translators = TypeNameTranslator.vars(codeGenerator.name);
                                vars.putAll(translators);
                                if (!codeGenerator.kind.equals(model.getKind()) || (relativeName = (String)MVEL.executeExpression((Object)codeGenerator.filenameExpr, vars)) == null) continue;
                                if (relativeName.endsWith(".java") && !relativeName.contains("/")) {
                                    String fqn = relativeName.substring(0, relativeName.length() - ".java".length());
                                    if (this.processingEnv.getElementUtils().getTypeElement(fqn) != null) continue;
                                    JavaFileObject target = this.processingEnv.getFiler().createSourceFile(fqn, new Element[0]);
                                    String output = codeGenerator.transformTemplate.render(model, translators);
                                    try (Writer writer = target.openWriter();){
                                        writer.append(output);
                                    }
                                } else {
                                    File target = new File(this.outputDirectory, relativeName).getAbsoluteFile();
                                    if (codeGenerator.incremental) {
                                        List processings = this.generatedFiles.computeIfAbsent(target, GeneratedFile::new);
                                        processings.add(new ModelProcessing(model, codeGenerator));
                                    } else {
                                        codeGenerator.transformTemplate.apply(model, target, translators);
                                    }
                                }
                                log.info("Generated model " + model.getFqn() + ": " + relativeName);
                            }
                        } else {
                            log.info("Validated model " + model.getFqn());
                        }
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, (Element)entry.getKey());
                    }
                });
            }
        } else {
            this.generatedFiles.values().forEach(generated -> {
                File file = generated.file;
                Helper.ensureParentDir(file);
                try (FileWriter fileWriter = new FileWriter(file);){
                    Collections.sort(generated, (o1, o2) -> o1.model.getElement().getSimpleName().toString().compareTo(o2.model.getElement().getSimpleName().toString()));
                    for (int i = 0; i < generated.size(); ++i) {
                        ModelProcessing processing = (ModelProcessing)generated.get(i);
                        HashMap<String, Object> vars = new HashMap<String, Object>();
                        vars.put("incrementalIndex", i);
                        vars.put("incrementalSize", generated.size());
                        vars.put("session", generated.session);
                        try {
                            String part = processing.generator.transformTemplate.render(processing.model, vars);
                            fileWriter.append(part);
                            continue;
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                            continue;
                        }
                        catch (Exception e) {
                            this.reportException(e, processing.model.getElement());
                        }
                    }
                }
                catch (Exception e) {
                    this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                }
            });
        }
        return true;
    }

    private void reportGenException(GenException e) {
        String msg = "Could not generate model for " + e.element + ": " + e.msg;
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
    }

    private void reportException(Exception e, Element elt) {
        String msg = "Could not generate element for " + elt + ": " + e.getMessage();
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elt);
    }

    private static class GeneratedFile
    extends ArrayList<ModelProcessing> {
        final File file;
        final Map<String, Object> session = new HashMap<String, Object>();

        public GeneratedFile(File file) {
            this.file = file;
        }
    }

    private static class ModelProcessing {
        final Model model;
        final CodeGenerator generator;

        public ModelProcessing(Model model, CodeGenerator generator) {
            this.model = model;
            this.generator = generator;
        }
    }

    private static class CodeGenerator {
        final String name;
        final String kind;
        final boolean incremental;
        final Serializable filenameExpr;
        final Template transformTemplate;

        CodeGenerator(String name, String kind, boolean incremental, Serializable filenameExpr, Template transformTemplate) {
            this.name = name;
            this.kind = kind;
            this.filenameExpr = filenameExpr;
            this.transformTemplate = transformTemplate;
            this.incremental = incremental;
        }
    }
}

