/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.annotations.EmptyAnnotation;
import io.vertx.test.codegen.annotations.TestEnum;
import io.vertx.test.codegen.testapi.InterfaceDataObject;
import io.vertx.test.codegen.testdataobject.Abstract;
import io.vertx.test.codegen.testdataobject.AbstractCommentedProperty;
import io.vertx.test.codegen.testdataobject.AbstractInheritsAbstract;
import io.vertx.test.codegen.testdataobject.AbstractUncommentedProperty;
import io.vertx.test.codegen.testdataobject.AdderNormalizationRules;
import io.vertx.test.codegen.testdataobject.AdderWithNestedDataObject;
import io.vertx.test.codegen.testdataobject.AnnotatedDataObject;
import io.vertx.test.codegen.testdataobject.ApiObject;
import io.vertx.test.codegen.testdataobject.CommentedDataObject;
import io.vertx.test.codegen.testdataobject.CommentedProperty;
import io.vertx.test.codegen.testdataobject.CommentedPropertyInheritedFromCommentedProperty;
import io.vertx.test.codegen.testdataobject.CommentedPropertyOverridesCommentedProperty;
import io.vertx.test.codegen.testdataobject.CommentedPropertyOverridesUncommentedProperty;
import io.vertx.test.codegen.testdataobject.Concrete;
import io.vertx.test.codegen.testdataobject.ConcreteExtendsConcrete;
import io.vertx.test.codegen.testdataobject.ConcreteImplementsFromDataObject;
import io.vertx.test.codegen.testdataobject.ConcreteImplementsFromNonDataObject;
import io.vertx.test.codegen.testdataobject.ConcreteImplementsNonDataObject;
import io.vertx.test.codegen.testdataobject.ConcreteInheritsAbstract;
import io.vertx.test.codegen.testdataobject.ConcreteOverridesFromAbstractDataObject;
import io.vertx.test.codegen.testdataobject.ConcreteOverridesFromDataObject;
import io.vertx.test.codegen.testdataobject.ConcreteOverridesFromNonDataObject;
import io.vertx.test.codegen.testdataobject.ConverterDataObject;
import io.vertx.test.codegen.testdataobject.DataObjectInterfaceWithIgnoredProperty;
import io.vertx.test.codegen.testdataobject.DataObjectWithAnnotatedField;
import io.vertx.test.codegen.testdataobject.DataObjectWithEmptyConstructor;
import io.vertx.test.codegen.testdataobject.DataObjectWithNoJsonObjectConstructor;
import io.vertx.test.codegen.testdataobject.DataObjectWithObjectProperty;
import io.vertx.test.codegen.testdataobject.EmptyDataObject;
import io.vertx.test.codegen.testdataobject.Enumerated;
import io.vertx.test.codegen.testdataobject.Foo;
import io.vertx.test.codegen.testdataobject.IgnoreMethods;
import io.vertx.test.codegen.testdataobject.ImportedNested;
import io.vertx.test.codegen.testdataobject.ImportedSubinterface;
import io.vertx.test.codegen.testdataobject.InheritingConverterDataObject;
import io.vertx.test.codegen.testdataobject.JsonObjectAdder;
import io.vertx.test.codegen.testdataobject.JsonObjectSetter;
import io.vertx.test.codegen.testdataobject.NoConverterDataObject;
import io.vertx.test.codegen.testdataobject.Parameterized;
import io.vertx.test.codegen.testdataobject.PropertyGetters;
import io.vertx.test.codegen.testdataobject.PropertyGettersSetters;
import io.vertx.test.codegen.testdataobject.PropertyListAdders;
import io.vertx.test.codegen.testdataobject.PropertyListGettersAdders;
import io.vertx.test.codegen.testdataobject.PropertyListGettersSetters;
import io.vertx.test.codegen.testdataobject.PropertyListSetters;
import io.vertx.test.codegen.testdataobject.PropertyMapAdders;
import io.vertx.test.codegen.testdataobject.PropertyMapGettersAdders;
import io.vertx.test.codegen.testdataobject.PropertyMapGettersSetters;
import io.vertx.test.codegen.testdataobject.PropertyMapSetters;
import io.vertx.test.codegen.testdataobject.PropertySetGettersSetters;
import io.vertx.test.codegen.testdataobject.PropertySetSetters;
import io.vertx.test.codegen.testdataobject.PropertySetters;
import io.vertx.test.codegen.testdataobject.SetterNormalizationRules;
import io.vertx.test.codegen.testdataobject.SetterWithNestedDataObject;
import io.vertx.test.codegen.testdataobject.SetterWithNonFluentReturnType;
import io.vertx.test.codegen.testdataobject.SomeAnnotation;
import io.vertx.test.codegen.testdataobject.SomeMethodAnnotation;
import io.vertx.test.codegen.testdataobject.ToJsonDataObject;
import io.vertx.test.codegen.testdataobject.UncommentedProperty;
import io.vertx.test.codegen.testdataobject.UncommentedPropertyOverridesAncestorSuperCommentedProperty;
import io.vertx.test.codegen.testdataobject.UncommentedPropertyOverridesSuperCommentedProperty;
import io.vertx.test.codegen.testdataobject.imported.Imported;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DataObjectTest {
    @Test
    public void testDataObjectWithNoJsonObjectConstructor() throws Exception {
        this.assertInvalidDataObject(DataObjectWithNoJsonObjectConstructor.class);
    }

    @Test
    public void testDataObjectWithEmptyConstructor() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(DataObjectWithEmptyConstructor.class, new Class[0]);
        Assert.assertTrue((boolean)model.hasEmptyConstructor());
    }

    @Test
    public void testDataObjectInterface() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(InterfaceDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertFalse((boolean)model.isClass());
    }

    @Test
    public void testEmptyDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(EmptyDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isClass());
        Assert.assertFalse((boolean)model.getGenerateConverter());
        Assert.assertFalse((boolean)model.getInheritConverter());
        Assert.assertTrue((boolean)model.isPublicConverter());
        try {
            EmptyDataObject.class.getConstructor(new Class[0]);
            Assert.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            EmptyDataObject.class.getConstructor(EmptyDataObject.class);
            Assert.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Test
    public void testParameterizedDataObject() throws Exception {
        this.assertInvalidDataObject(Parameterized.class);
    }

    @Test
    public void testSetterWithNonFluentReturnType() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(SetterWithNonFluentReturnType.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)2L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("string"), "string", "setString", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBoolean"), "primitiveBoolean", "setPrimitiveBoolean", null, null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testObjectProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(DataObjectWithObjectProperty.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
    }

    @Test
    public void testPropertySetters() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertySetters.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)14L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("string"), "string", "setString", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedInteger"), "boxedInteger", "setBoxedInteger", null, null, TypeReflectionFactory.create(Integer.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveInteger"), "primitiveInteger", "setPrimitiveInteger", null, null, TypeReflectionFactory.create(Integer.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBoolean"), "boxedBoolean", "setBoxedBoolean", null, null, TypeReflectionFactory.create(Boolean.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBoolean"), "primitiveBoolean", "setPrimitiveBoolean", null, null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLong"), "boxedLong", "setBoxedLong", null, null, TypeReflectionFactory.create(Long.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveLong"), "primitiveLong", "setPrimitiveLong", null, null, TypeReflectionFactory.create(Long.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instant"), "instant", "setInstant", null, null, TypeReflectionFactory.create(Instant.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObject"), "apiObject", "setApiObject", null, null, TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObject"), "dataObject", "setDataObject", null, null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.VALUE, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObject"), "toJsonDataObject", "setToJsonDataObject", null, null, TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObject"), "jsonObject", "setJsonObject", null, null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArray"), "jsonArray", "setJsonArray", null, null, TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerated"), "enumerated", "setEnumerated", null, null, TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testSetterNormalizationRules() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(SetterNormalizationRules.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)3L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("ha"), "ha", "setHA", null, null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("haGroup"), "haGroup", "setHAGroup", null, null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("group"), "group", "setGroup", null, null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testPropertyListSetters() throws Exception {
        this.testPropertyCollectionSetters(PropertyListSetters.class, PropertyKind.LIST);
    }

    @Test
    public void testPropertySetSetters() throws Exception {
        this.testPropertyCollectionSetters(PropertySetSetters.class, PropertyKind.SET);
    }

    private void testPropertyCollectionSetters(Class<?> dataObjectClass, PropertyKind expectedKind) throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(dataObjectClass, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)12L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("extraClassPath"), "extraClassPath", "setExtraClassPath", null, null, TypeReflectionFactory.create(String.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", "setStrings", null, null, TypeReflectionFactory.create(String.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", "setInstants", null, null, TypeReflectionFactory.create(Instant.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", "setBoxedIntegers", null, null, TypeReflectionFactory.create(Integer.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", "setBoxedBooleans", null, null, TypeReflectionFactory.create(Boolean.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", "setBoxedLongs", null, null, TypeReflectionFactory.create(Long.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", "setApiObjects", null, null, TypeReflectionFactory.create(ApiObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", "setDataObjects", null, null, TypeReflectionFactory.create(EmptyDataObject.class), true, expectedKind, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", "setToJsonDataObjects", null, null, TypeReflectionFactory.create(ToJsonDataObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", "setJsonObjects", null, null, TypeReflectionFactory.create(JsonObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", "setJsonArrays", null, null, TypeReflectionFactory.create(JsonArray.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", "setEnumerateds", null, null, TypeReflectionFactory.create(Enumerated.class), true, expectedKind, true);
    }

    @Test
    public void testPropertyListGettersSetters() throws Exception {
        this.testPropertyCollectionGettersSetters(PropertyListGettersSetters.class, PropertyKind.LIST);
    }

    @Test
    public void testPropertySetGettersSetters() throws Exception {
        this.testPropertyCollectionGettersSetters(PropertySetGettersSetters.class, PropertyKind.SET);
    }

    private void testPropertyCollectionGettersSetters(Class<?> dataObjectClass, PropertyKind expectedKind) throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(dataObjectClass, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)12L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("extraClassPath"), "extraClassPath", "setExtraClassPath", null, "getExtraClassPath", TypeReflectionFactory.create(String.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", "setStrings", null, "getStrings", TypeReflectionFactory.create(String.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", "setInstants", null, "getInstants", TypeReflectionFactory.create(Instant.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", "setBoxedIntegers", null, "getBoxedIntegers", TypeReflectionFactory.create(Integer.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", "setBoxedBooleans", null, "getBoxedBooleans", TypeReflectionFactory.create(Boolean.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", "setBoxedLongs", null, "getBoxedLongs", TypeReflectionFactory.create(Long.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", "setApiObjects", null, "getApiObjects", TypeReflectionFactory.create(ApiObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", "setDataObjects", null, "getDataObjects", TypeReflectionFactory.create(EmptyDataObject.class), true, expectedKind, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", "setToJsonDataObjects", null, "getToJsonDataObjects", TypeReflectionFactory.create(ToJsonDataObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", "setJsonObjects", null, "getJsonObjects", TypeReflectionFactory.create(JsonObject.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", "setJsonArrays", null, "getJsonArrays", TypeReflectionFactory.create(JsonArray.class), true, expectedKind, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", "setEnumerateds", null, "getEnumerateds", TypeReflectionFactory.create(Enumerated.class), true, expectedKind, true);
    }

    @Test
    public void testPropertyMapGettersAdders() throws Exception {
    }

    @Test
    public void testPropertyMapGettersSetters() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyMapGettersSetters.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)12L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("stringMap"), "stringMap", "setStringMap", null, "getStringMap", TypeReflectionFactory.create(String.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instantMap"), "instantMap", "setInstantMap", null, "getInstantMap", TypeReflectionFactory.create(Instant.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegerMap"), "boxedIntegerMap", "setBoxedIntegerMap", null, "getBoxedIntegerMap", TypeReflectionFactory.create(Integer.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleanMap"), "boxedBooleanMap", "setBoxedBooleanMap", null, "getBoxedBooleanMap", TypeReflectionFactory.create(Boolean.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongMap"), "boxedLongMap", "setBoxedLongMap", null, "getBoxedLongMap", TypeReflectionFactory.create(Long.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjectMap"), "apiObjectMap", "setApiObjectMap", null, "getApiObjectMap", TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjectMap"), "dataObjectMap", "setDataObjectMap", null, "getDataObjectMap", TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.MAP, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjectMap"), "toJsonDataObjectMap", "setToJsonDataObjectMap", null, "getToJsonDataObjectMap", TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjectMap"), "jsonObjectMap", "setJsonObjectMap", null, "getJsonObjectMap", TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrayMap"), "jsonArrayMap", "setJsonArrayMap", null, "getJsonArrayMap", TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumeratedMap"), "enumeratedMap", "setEnumeratedMap", null, "getEnumeratedMap", TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("objectMap"), "objectMap", "setObjectMap", null, "getObjectMap", TypeReflectionFactory.create(Object.class), true, PropertyKind.MAP, true);
    }

    @Test
    public void testPropertyMapAdders() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyMapAdders.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)15L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", null, "addString", null, TypeReflectionFactory.create(String.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", null, "addInstant", null, TypeReflectionFactory.create(Instant.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", null, "addBoxedInteger", null, TypeReflectionFactory.create(Integer.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveIntegers"), "primitiveIntegers", null, "addPrimitiveInteger", null, TypeReflectionFactory.create(Integer.TYPE), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", null, "addBoxedBoolean", null, TypeReflectionFactory.create(Boolean.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBooleans"), "primitiveBooleans", null, "addPrimitiveBoolean", null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", null, "addBoxedLong", null, TypeReflectionFactory.create(Long.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveLongs"), "primitiveLongs", null, "addPrimitiveLong", null, TypeReflectionFactory.create(Long.TYPE), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", null, "addApiObject", null, TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", null, "addDataObject", null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.MAP, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", null, "addToJsonDataObject", null, TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", null, "addJsonObject", null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", null, "addJsonArray", null, TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", null, "addEnumerated", null, TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("objects"), "objects", null, "addObject", null, TypeReflectionFactory.create(Object.class), true, PropertyKind.MAP, true);
    }

    @Test
    public void testPropertyMapSetters() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyMapSetters.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)12L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("stringMap"), "stringMap", "setStringMap", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instantMap"), "instantMap", "setInstantMap", null, null, TypeReflectionFactory.create(Instant.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegerMap"), "boxedIntegerMap", "setBoxedIntegerMap", null, null, TypeReflectionFactory.create(Integer.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleanMap"), "boxedBooleanMap", "setBoxedBooleanMap", null, null, TypeReflectionFactory.create(Boolean.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongMap"), "boxedLongMap", "setBoxedLongMap", null, null, TypeReflectionFactory.create(Long.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjectMap"), "apiObjectMap", "setApiObjectMap", null, null, TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjectMap"), "dataObjectMap", "setDataObjectMap", null, null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.MAP, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjectMap"), "toJsonDataObjectMap", "setToJsonDataObjectMap", null, null, TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjectMap"), "jsonObjectMap", "setJsonObjectMap", null, null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrayMap"), "jsonArrayMap", "setJsonArrayMap", null, null, TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumeratedMap"), "enumeratedMap", "setEnumeratedMap", null, null, TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("objectMap"), "objectMap", "setObjectMap", null, null, TypeReflectionFactory.create(Object.class), true, PropertyKind.MAP, true);
    }

    @Test
    public void testPropertyMapSetterAdders() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyMapGettersAdders.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)12L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", null, "addString", "getStrings", TypeReflectionFactory.create(String.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", null, "addInstant", "getInstants", TypeReflectionFactory.create(Instant.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", null, "addBoxedInteger", "getBoxedIntegers", TypeReflectionFactory.create(Integer.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", null, "addBoxedBoolean", "getBoxedBooleans", TypeReflectionFactory.create(Boolean.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", null, "addBoxedLong", "getBoxedLongs", TypeReflectionFactory.create(Long.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", null, "addApiObject", "getApiObjects", TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", null, "addDataObject", "getDataObjects", TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.MAP, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", null, "addToJsonDataObject", "getToJsonDataObjects", TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", null, "addJsonObject", "getJsonObjects", TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", null, "addJsonArray", "getJsonArrays", TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", null, "addEnumerated", "getEnumerateds", TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.MAP, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("objects"), "objects", null, "addObject", "getObjects", TypeReflectionFactory.create(Object.class), true, PropertyKind.MAP, true);
    }

    @Test
    public void testPropertyGetters() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyGetters.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)14L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("string"), "string", null, null, "getString", TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedInteger"), "boxedInteger", null, null, "getBoxedInteger", TypeReflectionFactory.create(Integer.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveInteger"), "primitiveInteger", null, null, "getPrimitiveInteger", TypeReflectionFactory.create(Integer.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBoolean"), "boxedBoolean", null, null, "isBoxedBoolean", TypeReflectionFactory.create(Boolean.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBoolean"), "primitiveBoolean", null, null, "isPrimitiveBoolean", TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLong"), "boxedLong", null, null, "getBoxedLong", TypeReflectionFactory.create(Long.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveLong"), "primitiveLong", null, null, "getPrimitiveLong", TypeReflectionFactory.create(Long.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instant"), "instant", null, null, "getInstant", TypeReflectionFactory.create(Instant.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObject"), "apiObject", null, null, "getApiObject", TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObject"), "dataObject", null, null, "getDataObject", TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.VALUE, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObject"), "toJsonDataObject", null, null, "getToJsonDataObject", TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObject"), "jsonObject", null, null, "getJsonObject", TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArray"), "jsonArray", null, null, "getJsonArray", TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerated"), "enumerated", null, null, "getEnumerated", TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testPropertyGettersSetters() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyGettersSetters.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)14L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("string"), "string", "setString", null, "getString", TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instant"), "instant", "setInstant", null, "getInstant", TypeReflectionFactory.create(Instant.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedInteger"), "boxedInteger", "setBoxedInteger", null, "getBoxedInteger", TypeReflectionFactory.create(Integer.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveInteger"), "primitiveInteger", "setPrimitiveInteger", null, "getPrimitiveInteger", TypeReflectionFactory.create(Integer.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBoolean"), "boxedBoolean", "setBoxedBoolean", null, "isBoxedBoolean", TypeReflectionFactory.create(Boolean.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBoolean"), "primitiveBoolean", "setPrimitiveBoolean", null, "isPrimitiveBoolean", TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLong"), "boxedLong", "setBoxedLong", null, "getBoxedLong", TypeReflectionFactory.create(Long.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveLong"), "primitiveLong", "setPrimitiveLong", null, "getPrimitiveLong", TypeReflectionFactory.create(Long.TYPE), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObject"), "apiObject", "setApiObject", null, "getApiObject", TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObject"), "dataObject", "setDataObject", null, "getDataObject", TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.VALUE, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObject"), "toJsonDataObject", "setToJsonDataObject", null, "getToJsonDataObject", TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObject"), "jsonObject", "setJsonObject", null, "getJsonObject", TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArray"), "jsonArray", "setJsonArray", null, "getJsonArray", TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerated"), "enumerated", "setEnumerated", null, "getEnumerated", TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testJsonObjectSetter() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(JsonObjectSetter.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObject"), "jsonObject", "setJsonObject", null, null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testPropertyListAdders() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyListAdders.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)14L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", null, "addString", null, TypeReflectionFactory.create(String.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", null, "addInstant", null, TypeReflectionFactory.create(Instant.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", null, "addBoxedInteger", null, TypeReflectionFactory.create(Integer.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveIntegers"), "primitiveIntegers", null, "addPrimitiveInteger", null, TypeReflectionFactory.create(Integer.TYPE), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", null, "addBoxedBoolean", null, TypeReflectionFactory.create(Boolean.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveBooleans"), "primitiveBooleans", null, "addPrimitiveBoolean", null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", null, "addBoxedLong", null, TypeReflectionFactory.create(Long.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("primitiveLongs"), "primitiveLongs", null, "addPrimitiveLong", null, TypeReflectionFactory.create(Long.TYPE), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", null, "addApiObject", null, TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", null, "addDataObject", null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.LIST, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", null, "addToJsonDataObject", null, TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", null, "addJsonObject", null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", null, "addJsonArray", null, TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", null, "addEnumerated", null, TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.LIST, true);
    }

    @Test
    public void testPropertyListGettersAdders() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(PropertyListGettersAdders.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)11L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("strings"), "strings", null, "addString", "getStrings", TypeReflectionFactory.create(String.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("instants"), "instants", null, "addInstant", "getInstants", TypeReflectionFactory.create(Instant.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedIntegers"), "boxedIntegers", null, "addBoxedInteger", "getBoxedIntegers", TypeReflectionFactory.create(Integer.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedBooleans"), "boxedBooleans", null, "addBoxedBoolean", "getBoxedBooleans", TypeReflectionFactory.create(Boolean.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("boxedLongs"), "boxedLongs", null, "addBoxedLong", "getBoxedLongs", TypeReflectionFactory.create(Long.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("apiObjects"), "apiObjects", null, "addApiObject", "getApiObjects", TypeReflectionFactory.create(ApiObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjects"), "dataObjects", null, "addDataObject", "getDataObjects", TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.LIST, false);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("toJsonDataObjects"), "toJsonDataObjects", null, "addToJsonDataObject", "getToJsonDataObjects", TypeReflectionFactory.create(ToJsonDataObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", null, "addJsonObject", "getJsonObjects", TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonArrays"), "jsonArrays", null, "addJsonArray", "getJsonArrays", TypeReflectionFactory.create(JsonArray.class), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("enumerateds"), "enumerateds", null, "addEnumerated", "getEnumerateds", TypeReflectionFactory.create(Enumerated.class), true, PropertyKind.LIST, true);
    }

    @Test
    public void testAdderNormalizationRules() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AdderNormalizationRules.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)3L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("urls"), "urls", null, "addURL", null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("urlLocators"), "urlLocators", null, "addURLLocator", null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.LIST, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("locators"), "locators", null, "addLocator", null, TypeReflectionFactory.create(Boolean.TYPE), true, PropertyKind.LIST, true);
    }

    @Test
    public void testJsonObjectAdder() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(JsonObjectAdder.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("jsonObjects"), "jsonObjects", null, "addJsonObject", null, TypeReflectionFactory.create(JsonObject.class), true, PropertyKind.LIST, true);
    }

    @Test
    public void testNestedDataObjectSetter() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(SetterWithNestedDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("nested"), "nested", "setNested", null, null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.VALUE, false);
    }

    @Test
    public void testNestedDataObjectAdder() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AdderWithNestedDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("nesteds"), "nesteds", null, "addNested", null, TypeReflectionFactory.create(EmptyDataObject.class), true, PropertyKind.LIST, false);
    }

    @Test
    public void testIgnoreMethods() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(IgnoreMethods.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
    }

    @Test
    public void testConcreteInheritsConcrete() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteExtendsConcrete.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Concrete.class)), (Object)model.getSuperTypes());
        Assert.assertEquals((Object)TypeReflectionFactory.create(Concrete.class), (Object)model.getSuperType());
        Assert.assertEquals(Collections.emptySet(), (Object)model.getAbstractSuperTypes());
    }

    @Test
    public void testConcreteImplementsAbstract() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteInheritsAbstract.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Abstract.class)), (Object)model.getSuperTypes());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Abstract.class)), (Object)model.getAbstractSuperTypes());
        Assert.assertNull((Object)model.getSuperType());
    }

    @Test
    public void testConcreteImplementsNonDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteImplementsNonDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
    }

    @Test
    public void testConcreteImplementsFromNonDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteImplementsFromNonDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("nonDataObjectProperty"), "nonDataObjectProperty", "setNonDataObjectProperty", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        Assert.assertEquals(Collections.emptySet(), (Object)model.getSuperTypes());
    }

    @Test
    public void testConcreteImplementsFromDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteImplementsFromDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjectProperty"), "dataObjectProperty", "setDataObjectProperty", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testConcreteOverridesFromDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteOverridesFromDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("dataObjectProperty"), "dataObjectProperty", "setDataObjectProperty", null, null, TypeReflectionFactory.create(String.class), false, PropertyKind.VALUE, true);
    }

    @Test
    public void testConcreteOverridesFromNonDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteOverridesFromNonDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)1L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("nonDataObjectProperty"), "nonDataObjectProperty", "setNonDataObjectProperty", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
        Assert.assertEquals(Collections.emptySet(), (Object)model.getSuperTypes());
    }

    @Test
    public void testConcreteOverridesFromAbstractDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConcreteOverridesFromAbstractDataObject.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isConcrete());
        Assert.assertEquals((long)3L, (long)model.getPropertyMap().size());
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("inheritedProperty"), "inheritedProperty", "setInheritedProperty", null, null, TypeReflectionFactory.create(String.class), false, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("overriddenProperty"), "overriddenProperty", "setOverriddenProperty", null, null, TypeReflectionFactory.create(String.class), false, PropertyKind.VALUE, true);
        DataObjectTest.assertProperty((PropertyInfo)model.getPropertyMap().get("abstractProperty"), "abstractProperty", "setAbstractProperty", null, null, TypeReflectionFactory.create(String.class), true, PropertyKind.VALUE, true);
    }

    @Test
    public void testAbstractInheritsConcrete() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(Abstract.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isAbstract());
    }

    @Test
    public void testAbstract() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(Abstract.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isAbstract());
    }

    @Test
    public void testAbstractInheritsAbstract() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AbstractInheritsAbstract.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertFalse((boolean)model.isConcrete());
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Abstract.class)), (Object)model.getSuperTypes());
    }

    @Test
    public void testImportedSubinterface() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ImportedSubinterface.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Imported.class)), (Object)model.getImportedTypes());
    }

    @Test
    public void testImportedNested() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ImportedNested.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(Collections.singleton((ClassTypeInfo)TypeReflectionFactory.create(Imported.class)), (Object)model.getImportedTypes());
    }

    @Test
    public void testCommentedDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(CommentedDataObject.class, new Class[0]);
        Doc doc = model.getDoc();
        Assert.assertEquals((Object)" The data object comment.\n", (Object)doc.getFirstSentence().getValue());
    }

    @Test
    public void testUncommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(UncommentedProperty.class, new Class[0]);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Assert.assertNull((Object)propertyInfo.getDoc());
    }

    @Test
    public void testCommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(CommentedProperty.class, new Class[0]);
        PropertyInfo setterProperty = (PropertyInfo)model.getPropertyMap().get("setterProperty");
        Assert.assertEquals((Object)" Setter setter property description.\n", (Object)setterProperty.getDoc().getFirstSentence().getValue());
        PropertyInfo getterProperty = (PropertyInfo)model.getPropertyMap().get("getterProperty");
        Assert.assertEquals((Object)" Getter getter property description.\n", (Object)getterProperty.getDoc().getFirstSentence().getValue());
        PropertyInfo getterAndSetterProperty = (PropertyInfo)model.getPropertyMap().get("getterAndSetterProperty");
        Assert.assertEquals((Object)" GetterAndSetter setter property description.\n", (Object)getterAndSetterProperty.getDoc().getFirstSentence().getValue());
    }

    @Test
    public void testCommentedPropertyInheritedFromCommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(CommentedPropertyInheritedFromCommentedProperty.class, AbstractCommentedProperty.class);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Doc propertyDoc = propertyInfo.getDoc();
        Assert.assertEquals((Object)" The property description.\n", (Object)propertyDoc.getFirstSentence().getValue());
    }

    @Test
    public void testUncommentedPropertyOverridesCommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(UncommentedPropertyOverridesSuperCommentedProperty.class, AbstractCommentedProperty.class);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Doc propertyDoc = propertyInfo.getDoc();
        Assert.assertEquals((Object)" The property description.\n", (Object)propertyDoc.getFirstSentence().getValue());
    }

    @Test
    public void testUncommentedPropertyOverridesAncestorCommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(UncommentedPropertyOverridesAncestorSuperCommentedProperty.class, AbstractCommentedProperty.class);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Doc propertyDoc = propertyInfo.getDoc();
        Assert.assertEquals((Object)" The property description.\n", (Object)propertyDoc.getFirstSentence().getValue());
    }

    @Test
    public void testCommentedPropertyOverridesCommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(CommentedPropertyOverridesCommentedProperty.class, AbstractCommentedProperty.class);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Doc propertyDoc = propertyInfo.getDoc();
        Assert.assertEquals((Object)" The overriden property description.\n", (Object)propertyDoc.getFirstSentence().getValue());
    }

    @Test
    public void testCommentedPropertyOverridesUncommentedProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(CommentedPropertyOverridesUncommentedProperty.class, AbstractUncommentedProperty.class);
        PropertyInfo propertyInfo = (PropertyInfo)model.getPropertyMap().get("theProperty");
        Doc propertyDoc = propertyInfo.getDoc();
        Assert.assertEquals((Object)" The overriden property description.\n", (Object)propertyDoc.getFirstSentence().getValue());
    }

    @Test
    public void testDataObjectWithIgnoredProperty() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(DataObjectInterfaceWithIgnoredProperty.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)0L, (long)model.getPropertyMap().size());
    }

    @Test
    public void testConverterDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(ConverterDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getGenerateConverter());
        Assert.assertFalse((boolean)model.isPublicConverter());
    }

    @Test
    public void testNoConverterDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(NoConverterDataObject.class, new Class[0]);
        Assert.assertFalse((boolean)model.getGenerateConverter());
        Assert.assertTrue((boolean)model.isPublicConverter());
    }

    @Test
    public void testInheritedConverterDataObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(InheritingConverterDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getInheritConverter());
    }

    @Test
    public void testToJson() throws Exception {
        Assert.assertTrue((boolean)new GeneratorHelper().generateDataObject(ToJsonDataObject.class, new Class[0]).isJsonifiable());
        Assert.assertFalse((boolean)new GeneratorHelper().generateDataObject(EmptyDataObject.class, new Class[0]).isJsonifiable());
    }

    @Test
    public void testAnnotatedObject() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertEquals((long)2L, (long)model.getAnnotations().size());
        Assert.assertEquals((Object)EmptyAnnotation.class.getSimpleName(), (Object)((AnnotationValueInfo)model.getAnnotations().get(1)).getSimpleName());
    }

    @Test
    public void testAnnotatedField() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedField")).getAnnotations().size());
        Assert.assertEquals((long)0L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedField")).getAnnotations().get(0)).getMembersNames().size());
    }

    @Test
    public void testAnnotatatedClassWithAnnotatedValue() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(Foo.class, new Class[0]);
    }

    @Test
    public void testStringAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((Object)"aString", (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertArrayEquals((Object[])new String[]{"one", "two"}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((Object)"defaultString", (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0)).getMember("defaultValue"));
    }

    @Test
    public void testShortAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((long)1L, (long)((Short)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("value")).shortValue());
        Assert.assertArrayEquals((Object[])new Short[]{(short)1, (short)2}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((long)1L, (long)((Short)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithShortValue")).getAnnotations().get(0)).getMember("defaultValue")).shortValue());
    }

    @Test
    public void testLongAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((long)1L, (long)((Long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("value")));
        Assert.assertArrayEquals((Object[])new Long[]{1L, 2L}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((long)1L, (long)((Long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithLongValue")).getAnnotations().get(0)).getMember("defaultValue")));
    }

    @Test
    public void testIntegerAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((long)1L, (long)((Integer)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("value")).intValue());
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((long)1L, (long)((Integer)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithIntegerValue")).getAnnotations().get(0)).getMember("defaultValue")).intValue());
    }

    @Test
    public void testFloatAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((float)1.0f, (float)((Float)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("value")).floatValue(), (float)0.0f);
        Assert.assertArrayEquals((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((float)1.0f, (float)((Float)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithFloatValue")).getAnnotations().get(0)).getMember("defaultValue")).floatValue(), (float)0.0f);
    }

    @Test
    public void testAnnotationAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        AnnotationValueInfo expected = (AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithStringValue")).getAnnotations().get(0);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().size());
        Assert.assertEquals((long)2L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertEquals((Object)expected, (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertArrayEquals((Object[])new AnnotationValueInfo[]{expected, expected}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithAnnotationValue")).getAnnotations().get(0)).getMember("array")).toArray());
    }

    @Test
    public void testBooleanAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((Object)true, (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertArrayEquals((Object[])new Boolean[]{true, true}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((Object)true, (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithBooleanValue")).getAnnotations().get(0)).getMember("defaultValue"));
    }

    @Test
    public void testEnumAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((Object)TestEnum.TEST.name(), (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertArrayEquals((Object[])new String[]{TestEnum.TEST.name(), TestEnum.TEST.name()}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((Object)TestEnum.TEST.name(), (Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithEnumValue")).getAnnotations().get(0)).getMember("defaultValue"));
    }

    @Test
    public void testByteAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((long)1L, (long)((Byte)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("value")).byteValue());
        Assert.assertArrayEquals((Object[])new Byte[]{(byte)0, (byte)1}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((long)1L, (long)((Byte)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithByteValue")).getAnnotations().get(0)).getMember("defaultValue")).byteValue());
    }

    @Test
    public void testCharAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((long)97L, (long)((Character)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("value")).charValue());
        Assert.assertArrayEquals((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((long)97L, (long)((Character)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithCharValue")).getAnnotations().get(0)).getMember("defaultValue")).charValue());
    }

    @Test
    public void testClassAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals(String.class, Class.forName(((ClassTypeInfo)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("value")).getName()));
        Assert.assertArrayEquals((Object[])new Class[]{String.class, String.class}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("array")).stream().map(i -> {
            try {
                return Class.forName(((ClassTypeInfo)i).getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }).toArray());
        Assert.assertEquals(String.class, Class.forName(((ClassTypeInfo)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithClassValue")).getAnnotations().get(0)).getMember("defaultValue")).getName()));
    }

    @Test
    public void testDoubleAnnotated() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(AnnotatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.getPropertyMap().values().stream().allMatch(PropertyInfo::isAnnotated));
        Assert.assertEquals((long)1L, (long)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMembersNames().size());
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("value"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("array"));
        Assert.assertNotNull((Object)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("defaultValue"));
        Assert.assertEquals((double)1.0, (double)((Double)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("value")), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0}, (Object[])((List)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("array")).toArray());
        Assert.assertEquals((double)1.0, (double)((Double)((AnnotationValueInfo)((PropertyInfo)model.getPropertyMap().get("annotatedWithDoubleValue")).getAnnotations().get(0)).getMember("defaultValue")), (double)0.0);
    }

    private static void assertProperty(PropertyInfo property, String expectedName, String expectedSetter, String expectedAdder, String expectedGetter, TypeInfo expectedType, boolean expectedDeclared, PropertyKind expectedKind, boolean expectedJsonifiable) {
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((String)("Was expecting property to have be declared=" + expectedDeclared), (Object)expectedDeclared, (Object)property.isDeclared());
        Assert.assertEquals((Object)expectedSetter, (Object)property.getSetterMethod());
        Assert.assertEquals((Object)expectedAdder, (Object)property.getAdderMethod());
        Assert.assertEquals((Object)expectedGetter, (Object)property.getGetterMethod());
        Assert.assertEquals((Object)expectedName, (Object)property.getName());
        Assert.assertEquals((Object)expectedType, (Object)property.getType());
        Assert.assertEquals((Object)expectedKind, (Object)property.getKind());
        Assert.assertEquals((Object)expectedJsonifiable, (Object)property.isJsonifiable());
    }

    @Test
    public void testDataObjectWithAnnotations() throws Exception {
        DataObjectModel model = new GeneratorHelper().generateDataObject(DataObjectWithAnnotatedField.class, new Class[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)model.isClass());
        Assert.assertTrue((boolean)model.getGenerateConverter());
        Assert.assertTrue((boolean)model.isPublicConverter());
        PropertyInfo idModel = (PropertyInfo)model.getPropertyMap().get("id");
        Assert.assertEquals((long)1L, (long)idModel.getAnnotations().size());
        Assert.assertNotNull((Object)idModel.getAnnotation(SomeAnnotation.class.getName()).getName());
        PropertyInfo fieldWithMethodAnnotationModel = (PropertyInfo)model.getPropertyMap().get("fieldWithMethodAnnotation");
        Assert.assertEquals((long)2L, (long)fieldWithMethodAnnotationModel.getAnnotations().size());
        Assert.assertNotNull((Object)fieldWithMethodAnnotationModel.getAnnotation(SomeAnnotation.class.getName()).getName());
        Assert.assertNotNull((Object)fieldWithMethodAnnotationModel.getAnnotation(SomeMethodAnnotation.class.getName()).getName());
    }

    private void assertInvalidDataObject(Class<?> dataObjectClass) throws Exception {
        try {
            new GeneratorHelper().generateDataObject(dataObjectClass, new Class[0]);
            Assert.fail((String)("Was expecting " + dataObjectClass.getName() + " to fail"));
        }
        catch (GenException genException) {
            // empty catch block
        }
    }
}

