/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.DataObjectWithMapAdders;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class DataObjectWithMapAddersConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, DataObjectWithMapAdders obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "booleanValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            obj.addBooleanValue((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    break;
                }
                case "dataObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addDataObjectValue((String)entry.getKey(), new TestDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    break;
                }
                case "doubleValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addDoubleValue((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                        }
                    });
                    break;
                }
                case "enumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addEnumValue((String)entry.getKey(), TestEnum.valueOf((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "floatValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addFloatValue((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
                        }
                    });
                    break;
                }
                case "genEnumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addGenEnumValue((String)entry.getKey(), TestGenEnum.valueOf((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "instantValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addInstantValue((String)entry.getKey(), Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)entry.getValue())));
                        }
                    });
                    break;
                }
                case "integerValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addIntegerValue((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    break;
                }
                case "jsonArrayValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            obj.addJsonArrayValue((String)entry.getKey(), ((JsonArray)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "jsonObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addJsonObjectValue((String)entry.getKey(), ((JsonObject)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "longValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addLongValue((String)entry.getKey(), ((Number)entry.getValue()).longValue());
                        }
                    });
                    break;
                }
                case "shortValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addShortValue((String)entry.getKey(), ((Number)entry.getValue()).shortValue());
                        }
                    });
                    break;
                }
                case "stringValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addStringValue((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                }
            }
        }
    }

    public static void toJson(DataObjectWithMapAdders obj, JsonObject json) {
        DataObjectWithMapAddersConverter.toJson(obj, json.getMap());
    }

    public static void toJson(DataObjectWithMapAdders obj, Map<String, Object> json) {
    }
}

