/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.DataObjectWithMaps;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataObjectWithMapsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, DataObjectWithMaps obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "booleanValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            map.put((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    obj.setBooleanValues(map);
                    break;
                }
                case "dataObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), (Boolean)((Object)new TestDataObject((JsonObject)entry.getValue())));
                        }
                    });
                    obj.setDataObjectValues(map);
                    break;
                }
                case "doubleValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), (Boolean)((Number)entry.getValue()).doubleValue());
                        }
                    });
                    obj.setDoubleValues(map);
                    break;
                }
                case "enumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Boolean)((Object)TestEnum.valueOf((String)entry.getValue())));
                        }
                    });
                    obj.setEnumValues(map);
                    break;
                }
                case "floatValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), (Boolean)((Object)Float.valueOf(((Number)entry.getValue()).floatValue())));
                        }
                    });
                    obj.setFloatValues(map);
                    break;
                }
                case "genEnumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Boolean)((Object)TestGenEnum.valueOf((String)entry.getValue())));
                        }
                    });
                    obj.setGenEnumValues(map);
                    break;
                }
                case "instantValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Boolean)((Object)Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)entry.getValue()))));
                        }
                    });
                    obj.setInstantValues(map);
                    break;
                }
                case "integerValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), (Boolean)((Number)entry.getValue()).intValue());
                        }
                    });
                    obj.setIntegerValues(map);
                    break;
                }
                case "jsonArrayValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            map.put((String)entry.getKey(), (Boolean)((JsonArray)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonArrayValues(map);
                    break;
                }
                case "jsonObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), (Boolean)((JsonObject)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonObjectValues(map);
                    break;
                }
                case "longValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), (Boolean)((Number)entry.getValue()).longValue());
                        }
                    });
                    obj.setLongValues(map);
                    break;
                }
                case "shortValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), (Boolean)((Number)entry.getValue()).shortValue());
                        }
                    });
                    obj.setShortValues(map);
                    break;
                }
                case "stringValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Boolean> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Boolean)((Object)((String)entry.getValue())));
                        }
                    });
                    obj.setStringValues(map);
                }
            }
        }
    }

    public static void toJson(DataObjectWithMaps obj, JsonObject json) {
        DataObjectWithMapsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(DataObjectWithMaps obj, Map<String, Object> json) {
    }
}

