/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.testapi.DeprecatedInterface;
import io.vertx.test.codegen.testapi.GenericInterface;
import io.vertx.test.codegen.testdataobject.DataObjectWithProperty;
import io.vertx.test.codegen.testdataobject.DeprecatedDataObject;
import io.vertx.test.codegen.testenum.DeprecatedEnum;
import io.vertx.test.codegen.testenum.ValidEnum;
import org.junit.Assert;
import org.junit.Test;

public class DeprecatedTest {
    private GeneratorHelper generator = new GeneratorHelper();

    @Test
    public void testVertxGenDeprecated() throws Exception {
        ClassModel model = this.generator.generateClass(DeprecatedInterface.class, new Class[0]);
        Assert.assertTrue((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)true);
        Assert.assertNotNull((Object)model.getDeprecatedDesc());
        Assert.assertEquals((Object)model.getDeprecatedDesc().getValue(), (Object)"deprecated info");
        MethodInfo method = (MethodInfo)model.getMethods().get(0);
        Assert.assertTrue((boolean)method.isDeprecated());
        Assert.assertNotNull((Object)method.getDeprecatedDesc());
        Assert.assertEquals((Object)method.getDeprecatedDesc().getValue(), (Object)"method deprecated info");
    }

    @Test
    public void testVertxGenNotDeprecated() throws Exception {
        ClassModel model = this.generator.generateClass(GenericInterface.class, new Class[0]);
        Assert.assertFalse((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)false);
        Assert.assertFalse((boolean)((MethodInfo)model.getMethods().get(0)).isDeprecated());
    }

    @Test
    public void testDataObjectDeprecated() throws Exception {
        DataObjectModel model = this.generator.generateDataObject(DeprecatedDataObject.class, new Class[0]);
        Assert.assertTrue((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)true);
        Assert.assertNotNull((Object)model.getDeprecatedDesc());
        Assert.assertEquals((Object)model.getDeprecatedDesc().getValue(), (Object)"deprecated info");
        for (PropertyInfo property : model.getPropertyMap().values()) {
            Assert.assertTrue((boolean)property.isDeprecated());
            Assert.assertNotNull((Object)property.getDeprecatedDesc());
            Assert.assertEquals((Object)property.getDeprecatedDesc().getValue(), (Object)"property deprecated info");
        }
    }

    @Test
    public void testDataObjectNotDeprecated() throws Exception {
        DataObjectModel model = this.generator.generateDataObject(DataObjectWithProperty.class, new Class[0]);
        Assert.assertFalse((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)false);
        for (PropertyInfo property : model.getPropertyMap().values()) {
            Assert.assertFalse((boolean)property.isDeprecated());
        }
    }

    @Test
    public void testEnumDeprecated() throws Exception {
        EnumModel model = this.generator.generateEnum(DeprecatedEnum.class, new Class[0]);
        Assert.assertTrue((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)true);
        Assert.assertNotNull((Object)model.getDeprecatedDesc());
        Assert.assertEquals((Object)model.getDeprecatedDesc().getValue(), (Object)"deprecated info");
        Assert.assertTrue((boolean)((EnumValueInfo)model.getValues().get(0)).isDeprecated());
        Assert.assertNotNull((Object)((EnumValueInfo)model.getValues().get(0)).getDeprecatedDesc());
        Assert.assertEquals((Object)((EnumValueInfo)model.getValues().get(0)).getDeprecatedDesc().getValue(), (Object)"enum item deprecated info");
        Assert.assertFalse((boolean)((EnumValueInfo)model.getValues().get(1)).isDeprecated());
    }

    @Test
    public void testEnumNotDeprecated() throws Exception {
        EnumModel model = this.generator.generateEnum(ValidEnum.class, new Class[0]);
        Assert.assertFalse((boolean)model.isDeprecated());
        Assert.assertEquals(model.getVars().get("deprecated"), (Object)false);
    }
}

