/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.GenException;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.testenum.EnumAsParam;
import io.vertx.test.codegen.testenum.InvalidEmptyEnum;
import io.vertx.test.codegen.testenum.ValidEnum;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class EnumTest {
    @Test
    public void testEnum() throws Exception {
        EnumModel model = new GeneratorHelper().generateEnum(ValidEnum.class, new Class[0]);
        Assert.assertEquals(Arrays.asList("RED", "GREEN", "BLUE"), model.getValues().stream().map(EnumValueInfo::getIdentifier).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList("RED doc", "GREEN doc", "BLUE doc"), model.getValues().stream().map(e -> e.getDoc().toString()).collect(Collectors.toList()));
        Assert.assertEquals((Object)"enum", (Object)model.getKind());
        Assert.assertEquals((Object)"ValidEnum doc", (Object)model.getDoc().toString());
        Assert.assertEquals((Object)ValidEnum.class.getName(), (Object)model.getFqn());
        Assert.assertEquals((Object)"dummy", (Object)model.getModule().getName());
        Assert.assertTrue((boolean)model.getType().isGen());
    }

    @Test
    public void testInvalidEmptyEnum() throws Exception {
        try {
            new GeneratorHelper().generateEnum(InvalidEmptyEnum.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testEnumListingFromApi() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(EnumAsParam.class, new Class[0]);
        Assert.assertTrue((model.getReferencedEnumTypes().size() > 0 ? 1 : 0) != 0);
        TypeInfo typeInfo = (TypeInfo)model.getReferencedEnumTypes().toArray()[0];
        Assert.assertTrue((boolean)(typeInfo instanceof EnumTypeInfo));
        Assert.assertEquals((Object)"ValidEnum", (Object)typeInfo.getSimpleName());
    }
}

