/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.Helper;
import io.vertx.test.codegen.Utils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.junit.Assert;
import org.junit.Test;

public class HelperTest {
    @Test
    public void testGetEmptyPackageName() {
        Assert.assertEquals((Object)"", (Object)Helper.getPackageName((String)"SomeClass"));
    }

    @Test
    public void testExtractCommentTags() {
        String comment = " Interface comment line 1\n Interface comment line 2\n Interface comment line 3\n\n @author <a href=\"http://tfox.org\">Tim Fox</a>\n @version 12.2\n @see io.vertx.codegen.testmodel.TestInterface\n";
        String tagVal = Helper.getJavadocTag((String)comment, (String)"@author");
        Assert.assertEquals((Object)"<a href=\"http://tfox.org\">Tim Fox</a>", (Object)tagVal);
        tagVal = Helper.getJavadocTag((String)comment, (String)"@version");
        Assert.assertEquals((Object)"12.2", (Object)tagVal);
        tagVal = Helper.getJavadocTag((String)comment, (String)"@see");
        Assert.assertEquals((Object)"io.vertx.codegen.testmodel.TestInterface", (Object)tagVal);
    }

    @Test
    public void removeTags1() {
        String comment = " Interface comment line 1\n Interface comment line 2\n Interface comment line 3\n\n @author <a href=\"http://tfox.org\">Tim Fox</a>\n @version 12.2\n @see io.vertx.codegen.testmodel.TestInterface\n";
        String removed = Helper.removeTags((String)comment);
        String removedExpected = " Interface comment line 1\n Interface comment line 2\n Interface comment line 3\n";
        Assert.assertEquals((Object)removedExpected, (Object)removed);
    }

    @Test
    public void removeTags2() {
        String comment = " @author <a href=\"http://tfox.org\">Tim Fox</a>\n @version 12.2\n @see io.vertx.codegen.testmodel.TestInterface\n";
        String removed = Helper.removeTags((String)comment);
        String removedExpected = "";
        Assert.assertEquals((Object)removedExpected, (Object)removed);
    }

    @Test
    public void removeTags3() {
        String comment = "    @author <a href=\"http://tfox.org\">Tim Fox</a>\n @version 12.2\n @see io.vertx.codegen.testmodel.TestInterface\n";
        String removed = Helper.removeTags((String)comment);
        String removedExpected = "";
        Assert.assertEquals((Object)removedExpected, (Object)removed);
    }

    @Test
    public void removeTags4() {
        String comment = "X\n @author <a href=\"http://tfox.org\">Tim Fox</a>\n @version 12.2\n @see io.vertx.codegen.testmodel.TestInterface\n";
        String removed = Helper.removeTags((String)comment);
        String removedExpected = "X";
        Assert.assertEquals((Object)removedExpected, (Object)removed);
    }

    @Test
    public void testResolveClassSignature() throws Exception {
        Utils.assertProcess((processingEnv, roundEnv) -> {
            TypeElement elt = (TypeElement)Helper.resolveSignature((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), null, (String)"java.lang.Class");
            Assert.assertEquals((Object)((Object)ElementKind.CLASS), (Object)((Object)elt.getKind()));
            Assert.assertEquals((Object)"java.lang.Class", (Object)elt.getQualifiedName().toString());
            elt = (TypeElement)Helper.resolveSignature((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), null, (String)"Class");
            Assert.assertEquals((Object)((Object)ElementKind.CLASS), (Object)((Object)elt.getKind()));
            Assert.assertEquals((Object)"java.lang.Class", (Object)elt.getQualifiedName().toString());
        });
    }

    @Test
    public void testResolveFieldSignature() throws Exception {
        Utils.assertProcess((processingEnv, roundEnv) -> {
            Element elt = Helper.resolveSignature((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), null, (String)"java.util.Locale#FRENCH");
            Assert.assertEquals((Object)((Object)ElementKind.FIELD), (Object)((Object)elt.getKind()));
            VariableElement varElt = (VariableElement)elt;
            TypeElement typeElt = (TypeElement)varElt.getEnclosingElement();
            Assert.assertEquals((Object)"java.util.Locale", (Object)typeElt.getQualifiedName().toString());
            Assert.assertEquals((Object)"FRENCH", (Object)varElt.getSimpleName().toString());
        });
    }

    private void assertSignature(ProcessingEnvironment processingEnv, String signature, String className, String methodName, String ... parameterTypes) {
        this.assertSignature(processingEnv, (TypeElement)null, signature, className, methodName, parameterTypes);
    }

    private void assertSignature(ProcessingEnvironment processingEnv, TypeElement declaringElt, String signature, String className, String methodName, String ... parameterTypes) {
        Element elt = Helper.resolveSignature((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), (TypeElement)declaringElt, (String)signature);
        Assert.assertEquals((Object)((Object)ElementKind.METHOD), (Object)((Object)elt.getKind()));
        ExecutableElement methodElt = (ExecutableElement)elt;
        TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
        Assert.assertEquals((Object)className, (Object)typeElt.getQualifiedName().toString());
        Assert.assertEquals((Object)methodName, (Object)methodElt.getSimpleName().toString());
        Assert.assertEquals((long)parameterTypes.length, (long)methodElt.getParameters().size());
        for (int i = 0; i < parameterTypes.length; ++i) {
            Assert.assertEquals((Object)parameterTypes[i], (Object)methodElt.getParameters().get(i).asType().toString());
        }
    }

    @Test
    public void testResolveMethodSignature() throws Exception {
        Utils.assertProcess((processingEnv, roundEnv) -> {
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.Locale#getInstance", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.Locale#getInstance(String,String,String)", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.Locale#getInstance(java.lang.String,java.lang.String,java.lang.String)", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#containsAll", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#containsAll(Collection)", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#containsAll(java.util.Collection)", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#get", "java.util.List", "get", "int");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#get(int)", "java.util.List", "get", "int");
            this.assertSignature((ProcessingEnvironment)processingEnv, "java.util.List#toArray(Object[])", "java.util.List", "toArray", "T[]");
        });
    }

    @Test
    public void testResolveRelativeMethodSignature() throws Exception {
        Utils.assertProcess((processingEnv, roundEnv) -> {
            TypeElement localeElt = processingEnv.getElementUtils().getTypeElement("java.util.Locale");
            TypeElement listElt = processingEnv.getElementUtils().getTypeElement("java.util.List");
            this.assertSignature((ProcessingEnvironment)processingEnv, localeElt, "#getInstance", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, localeElt, "#getInstance(String,String,String)", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, localeElt, "#getInstance(java.lang.String,java.lang.String,java.lang.String)", "java.util.Locale", "getInstance", "java.lang.String", "java.lang.String", "java.lang.String");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#containsAll", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#containsAll(Collection)", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#containsAll(java.util.Collection)", "java.util.List", "containsAll", "java.util.Collection<?>");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#get", "java.util.List", "get", "int");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#get(int)", "java.util.List", "get", "int");
            this.assertSignature((ProcessingEnvironment)processingEnv, listElt, "#parallelStream()", "java.util.Collection", "parallelStream", new String[0]);
        });
    }

    @Test
    public void testUnresolveSignatures() throws Exception {
        Utils.assertProcess((processingEnv, roundEnv) -> {
            String[] signatures;
            for (String signature : signatures = new String[]{"java.util.Locale#createConstant(int,String)"}) {
                Element elt = Helper.resolveSignature((Elements)processingEnv.getElementUtils(), (Types)processingEnv.getTypeUtils(), null, (String)signature);
                Assert.assertNull((Object)elt);
            }
        });
    }
}

