/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.converter;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.test.codegen.converter.ChildInheritingDataObject;
import io.vertx.test.codegen.converter.ChildInheritingDataObjectConverter;
import io.vertx.test.codegen.converter.ChildNotInheritingDataObject;
import io.vertx.test.codegen.converter.ChildNotInheritingDataObjectConverter;
import io.vertx.test.codegen.converter.NestedJsonObjectDataObject;
import io.vertx.test.codegen.converter.NestedStringDataObject;
import io.vertx.test.codegen.converter.SetterAdderDataObject;
import io.vertx.test.codegen.converter.SetterAdderDataObjectConverter;
import io.vertx.test.codegen.converter.SnakeFormattedDataObject;
import io.vertx.test.codegen.converter.SnakeFormattedDataObjectConverter;
import io.vertx.test.codegen.converter.TestDataObject;
import io.vertx.test.codegen.converter.TestDataObjectConverter;
import io.vertx.test.codegen.converter.TestUtils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DataObjectTest {
    private static JsonObject toJson(Map<String, Object> map) {
        JsonObject json = new JsonObject();
        map.forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
        return json;
    }

    @Test
    public void testJsonToDataObject() throws Exception {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        NestedJsonObjectDataObject jsonObjectDataObject = new NestedJsonObjectDataObject().setValue(TestUtils.randomAlphaString(20));
        NestedStringDataObject stringDataObject = new NestedStringDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", (Object)TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add((Object)TestUtils.randomAlphaString(20));
        TimeUnit httpMethod = TimeUnit.values()[TestUtils.randomPositiveInt() % TimeUnit.values().length];
        ZonedDateTime methodMapped = ZonedDateTime.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        JsonObject json = new JsonObject();
        json.put("string", (Object)stringValue);
        json.put("primitiveBoolean", (Object)booleanValue);
        json.put("primitiveByte", (Object)byteValue);
        json.put("primitiveShort", (Object)shortValue);
        json.put("primitiveInt", (Object)intValue);
        json.put("primitiveLong", (Object)longValue);
        json.put("primitiveFloat", (Object)Float.valueOf(floatValue));
        json.put("primitiveDouble", (Object)doubleValue);
        json.put("primitiveChar", (Object)Character.toString(charValue));
        json.put("boxedBoolean", (Object)boxedBooleanValue);
        json.put("boxedByte", (Object)boxedByteValue);
        json.put("boxedShort", (Object)boxedShortValue);
        json.put("boxedInt", (Object)boxedIntValue);
        json.put("boxedLong", (Object)boxedLongValue);
        json.put("boxedFloat", (Object)boxedFloatValue);
        json.put("boxedDouble", (Object)boxedDoubleValue);
        json.put("boxedChar", (Object)Character.toString(boxedCharValue.charValue()));
        json.put("jsonObjectDataObject", (Object)jsonObjectDataObject.toJson());
        json.put("stringDataObject", (Object)stringDataObject.toJson());
        json.put("buffer", (Object)this.toBase64(buffer));
        json.put("jsonObject", (Object)jsonObject);
        json.put("jsonArray", (Object)jsonArray);
        json.put("httpMethod", (Object)httpMethod.toString());
        json.put("methodMapped", (Object)methodMapped.toString());
        json.put("stringList", (Object)new JsonArray().add((Object)stringValue));
        json.put("boxedBooleanList", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("boxedByteList", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("boxedShortList", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("boxedIntList", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("boxedLongList", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("boxedFloatList", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("boxedDoubleList", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("boxedCharList", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("jsonObjectDataObjectList", (Object)new JsonArray().add((Object)jsonObjectDataObject.toJson()));
        json.put("stringDataObjectList", (Object)new JsonArray().add((Object)stringDataObject.toJson()));
        json.put("bufferList", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("jsonObjectList", (Object)new JsonArray().add((Object)jsonObject));
        json.put("jsonArrayList", (Object)new JsonArray().add((Object)jsonArray));
        json.put("httpMethodList", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("methodMappedList", (Object)new JsonArray().add((Object)methodMapped.toString()));
        json.put("objectList", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("stringSet", (Object)new JsonArray().add((Object)stringValue));
        json.put("boxedBooleanSet", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("boxedByteSet", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("boxedShortSet", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("boxedIntSet", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("boxedLongSet", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("boxedFloatSet", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("boxedDoubleSet", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("boxedCharSet", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("jsonObjectDataObjectSet", (Object)new JsonArray().add((Object)jsonObjectDataObject.toJson()));
        json.put("stringDataObjectSet", (Object)new JsonArray().add((Object)stringDataObject.toJson()));
        json.put("bufferSet", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("jsonObjectSet", (Object)new JsonArray().add((Object)jsonObject));
        json.put("jsonArraySet", (Object)new JsonArray().add((Object)jsonArray));
        json.put("httpMethodSet", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("methodMappedSet", (Object)new JsonArray().add((Object)methodMapped.toString()));
        json.put("objectSet", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("addedStringValues", (Object)new JsonArray().add((Object)stringValue));
        json.put("addedBooleanValues", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("addedByteValues", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("addedShortValues", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("addedIntValues", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("addedLongValues", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("addedFloatValues", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("addedDoubleValues", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("addedCharValues", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("addedBoxedBooleanValues", (Object)new JsonArray().add((Object)boxedBooleanValue));
        json.put("addedBoxedByteValues", (Object)new JsonArray().add((Object)boxedByteValue));
        json.put("addedBoxedShortValues", (Object)new JsonArray().add((Object)boxedShortValue));
        json.put("addedBoxedIntValues", (Object)new JsonArray().add((Object)boxedIntValue));
        json.put("addedBoxedLongValues", (Object)new JsonArray().add((Object)boxedLongValue));
        json.put("addedBoxedFloatValues", (Object)new JsonArray().add((Object)boxedFloatValue));
        json.put("addedBoxedDoubleValues", (Object)new JsonArray().add((Object)boxedDoubleValue));
        json.put("addedBoxedCharValues", (Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())));
        json.put("addedJsonObjectDataObjects", (Object)new JsonArray().add((Object)jsonObjectDataObject.toJson()));
        json.put("addedStringDataObjects", (Object)new JsonArray().add((Object)stringDataObject.toJson()));
        json.put("addedBuffers", (Object)new JsonArray().add((Object)this.toBase64(buffer)));
        json.put("addedJsonObjects", (Object)new JsonArray().add((Object)jsonObject));
        json.put("addedJsonArrays", (Object)new JsonArray().add((Object)jsonArray));
        json.put("addedHttpMethods", (Object)new JsonArray().add((Object)httpMethod.toString()));
        json.put("addedMethodMappeds", (Object)new JsonArray().add((Object)methodMapped.toString()));
        json.put("addedObjects", (Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("stringValueMap", (Object)new JsonObject().put(key, (Object)stringValue));
        json.put("boxedBooleanValueMap", (Object)new JsonObject().put(key, (Object)boxedBooleanValue));
        json.put("boxedByteValueMap", (Object)new JsonObject().put(key, (Object)boxedByteValue));
        json.put("boxedShortValueMap", (Object)new JsonObject().put(key, (Object)boxedShortValue));
        json.put("boxedIntValueMap", (Object)new JsonObject().put(key, (Object)boxedIntValue));
        json.put("boxedLongValueMap", (Object)new JsonObject().put(key, (Object)boxedLongValue));
        json.put("boxedFloatValueMap", (Object)new JsonObject().put(key, (Object)boxedFloatValue));
        json.put("boxedDoubleValueMap", (Object)new JsonObject().put(key, (Object)boxedDoubleValue));
        json.put("boxedCharValueMap", (Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())));
        json.put("jsonObjectDataObjectMap", (Object)new JsonObject().put(key, (Object)jsonObjectDataObject.toJson()));
        json.put("stringDataObjectMap", (Object)new JsonObject().put(key, (Object)stringDataObject.toJson()));
        json.put("bufferMap", (Object)new JsonObject().put(key, (Object)this.toBase64(buffer)));
        json.put("jsonObjectMap", (Object)new JsonObject().put(key, (Object)jsonObject));
        json.put("jsonArrayMap", (Object)new JsonObject().put(key, (Object)jsonArray));
        json.put("httpMethodMap", (Object)new JsonObject().put(key, (Object)httpMethod.toString()));
        json.put("methodMappedMap", (Object)new JsonObject().put(key, (Object)methodMapped.toString()));
        json.put("objectMap", (Object)DataObjectTest.toJson(map));
        json.put("keyedStringValues", (Object)new JsonObject().put(key, (Object)stringValue));
        json.put("keyedBoxedBooleanValues", (Object)new JsonObject().put(key, (Object)boxedBooleanValue));
        json.put("keyedBoxedByteValues", (Object)new JsonObject().put(key, (Object)boxedByteValue));
        json.put("keyedBoxedShortValues", (Object)new JsonObject().put(key, (Object)boxedShortValue));
        json.put("keyedBoxedIntValues", (Object)new JsonObject().put(key, (Object)boxedIntValue));
        json.put("keyedBoxedLongValues", (Object)new JsonObject().put(key, (Object)boxedLongValue));
        json.put("keyedBoxedFloatValues", (Object)new JsonObject().put(key, (Object)boxedFloatValue));
        json.put("keyedBoxedDoubleValues", (Object)new JsonObject().put(key, (Object)boxedDoubleValue));
        json.put("keyedBoxedCharValues", (Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())));
        json.put("keyedJsonObjectDataObjectValues", (Object)new JsonObject().put(key, (Object)jsonObjectDataObject.toJson()));
        json.put("keyedStringDataObjectValues", (Object)new JsonObject().put(key, (Object)stringDataObject.toJson()));
        json.put("keyedBufferValues", (Object)new JsonObject().put(key, (Object)this.toBase64(buffer)));
        json.put("keyedJsonObjectValues", (Object)new JsonObject().put(key, (Object)jsonObject));
        json.put("keyedJsonArrayValues", (Object)new JsonObject().put(key, (Object)jsonArray));
        json.put("keyedEnumValues", (Object)new JsonObject().put(key, (Object)httpMethod.name()));
        json.put("keyedMethodMappedValues", (Object)new JsonObject().put(key, (Object)methodMapped.toString()));
        json.put("keyedObjectValues", (Object)DataObjectTest.toJson(map));
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, obj);
        Assert.assertEquals((Object)stringValue, (Object)obj.getString());
        Assert.assertEquals((Object)booleanValue, (Object)obj.isPrimitiveBoolean());
        Assert.assertEquals((long)byteValue, (long)obj.getPrimitiveByte());
        Assert.assertEquals((long)shortValue, (long)obj.getPrimitiveShort());
        Assert.assertEquals((long)intValue, (long)obj.getPrimitiveInt());
        Assert.assertEquals((long)longValue, (long)obj.getPrimitiveLong());
        Assert.assertEquals((float)floatValue, (float)obj.getPrimitiveFloat(), (float)0.0f);
        Assert.assertEquals((double)doubleValue, (double)obj.getPrimitiveDouble(), (double)0.0);
        Assert.assertEquals((long)charValue, (long)obj.getPrimitiveChar());
        Assert.assertEquals((Object)boxedBooleanValue, (Object)obj.isBoxedBoolean());
        Assert.assertEquals((Object)boxedByteValue, (Object)obj.getBoxedByte());
        Assert.assertEquals((Object)boxedShortValue, (Object)obj.getBoxedShort());
        Assert.assertEquals((Object)boxedIntValue, (Object)obj.getBoxedInt());
        Assert.assertEquals((Object)boxedLongValue, (Object)obj.getBoxedLong());
        Assert.assertEquals((float)boxedFloatValue.floatValue(), (float)obj.getBoxedFloat().floatValue(), (float)0.0f);
        Assert.assertEquals((double)boxedDoubleValue, (double)obj.getBoxedDouble(), (double)0.0);
        Assert.assertEquals((Object)boxedCharValue, (Object)obj.getBoxedChar());
        Assert.assertEquals((Object)jsonObjectDataObject, (Object)obj.getJsonObjectDataObject());
        Assert.assertEquals((Object)stringDataObject, (Object)obj.getStringDataObject());
        Assert.assertEquals((Object)buffer, (Object)obj.getBuffer());
        Assert.assertEquals((Object)jsonObject, (Object)obj.getJsonObject());
        Assert.assertEquals((Object)jsonArray, (Object)obj.getJsonArray());
        Assert.assertEquals((Object)((Object)httpMethod), (Object)((Object)obj.getHttpMethod()));
        Assert.assertEquals((Object)methodMapped, (Object)obj.getMethodMapped());
        Assert.assertEquals(Collections.singletonList(stringValue), obj.getStringList());
        Assert.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getBoxedBooleanList());
        Assert.assertEquals(Collections.singletonList(boxedByteValue), obj.getBoxedByteList());
        Assert.assertEquals(Collections.singletonList(boxedShortValue), obj.getBoxedShortList());
        Assert.assertEquals(Collections.singletonList(boxedIntValue), obj.getBoxedIntList());
        Assert.assertEquals(Collections.singletonList(boxedLongValue), obj.getBoxedLongList());
        Assert.assertEquals(Collections.singletonList(boxedFloatValue), obj.getBoxedFloatList());
        Assert.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getBoxedDoubleList());
        Assert.assertEquals(Collections.singletonList(boxedCharValue), obj.getBoxedCharList());
        Assert.assertEquals(Collections.singletonList(jsonObjectDataObject), obj.getJsonObjectDataObjectList());
        Assert.assertEquals(Collections.singletonList(stringDataObject), obj.getStringDataObjectList());
        Assert.assertEquals(Collections.singletonList(buffer), obj.getBufferList());
        Assert.assertEquals(Collections.singletonList(jsonObject), obj.getJsonObjectList());
        Assert.assertEquals(Collections.singletonList(jsonArray), obj.getJsonArrayList());
        Assert.assertEquals(Collections.singletonList(httpMethod), obj.getHttpMethodList());
        Assert.assertEquals(Collections.singletonList(methodMapped), obj.getMethodMappedList());
        Assert.assertEquals(list, obj.getObjectList());
        Assert.assertEquals(Collections.singleton(stringValue), obj.getStringSet());
        Assert.assertEquals(Collections.singleton(boxedBooleanValue), obj.getBoxedBooleanSet());
        Assert.assertEquals(Collections.singleton(boxedByteValue), obj.getBoxedByteSet());
        Assert.assertEquals(Collections.singleton(boxedShortValue), obj.getBoxedShortSet());
        Assert.assertEquals(Collections.singleton(boxedIntValue), obj.getBoxedIntSet());
        Assert.assertEquals(Collections.singleton(boxedLongValue), obj.getBoxedLongSet());
        Assert.assertEquals(Collections.singleton(boxedFloatValue), obj.getBoxedFloatSet());
        Assert.assertEquals(Collections.singleton(boxedDoubleValue), obj.getBoxedDoubleSet());
        Assert.assertEquals(Collections.singleton(boxedCharValue), obj.getBoxedCharSet());
        Assert.assertEquals(Collections.singleton(jsonObjectDataObject), obj.getJsonObjectDataObjectSet());
        Assert.assertEquals(Collections.singleton(stringDataObject), obj.getStringDataObjectSet());
        Assert.assertEquals(Collections.singleton(buffer), obj.getBufferSet());
        Assert.assertEquals(Collections.singleton(jsonObject), obj.getJsonObjectSet());
        Assert.assertEquals(Collections.singleton(jsonArray), obj.getJsonArraySet());
        Assert.assertEquals(Collections.singleton(httpMethod), obj.getHttpMethodSet());
        Assert.assertEquals(Collections.singleton(methodMapped), obj.getMethodMappedSet());
        Assert.assertEquals(new LinkedHashSet(list), obj.getObjectSet());
        Assert.assertEquals(Collections.singletonList(stringValue), obj.getAddedStringValues());
        Assert.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getAddedBoxedBooleanValues());
        Assert.assertEquals(Collections.singletonList(boxedByteValue), obj.getAddedBoxedByteValues());
        Assert.assertEquals(Collections.singletonList(boxedShortValue), obj.getAddedBoxedShortValues());
        Assert.assertEquals(Collections.singletonList(boxedIntValue), obj.getAddedBoxedIntValues());
        Assert.assertEquals(Collections.singletonList(boxedLongValue), obj.getAddedBoxedLongValues());
        Assert.assertEquals(Collections.singletonList(boxedFloatValue), obj.getAddedBoxedFloatValues());
        Assert.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getAddedBoxedDoubleValues());
        Assert.assertEquals(Collections.singletonList(boxedCharValue), obj.getAddedBoxedCharValues());
        Assert.assertEquals(Collections.singletonList(jsonObjectDataObject), obj.getAddedJsonObjectDataObjects());
        Assert.assertEquals(Collections.singletonList(stringDataObject), obj.getAddedStringDataObjects());
        Assert.assertEquals(Collections.singletonList(buffer), obj.getAddedBuffers());
        Assert.assertEquals(Collections.singletonList(jsonObject), obj.getAddedJsonObjects());
        Assert.assertEquals(Collections.singletonList(jsonArray), obj.getAddedJsonArrays());
        Assert.assertEquals(Collections.singletonList(httpMethod), obj.getAddedHttpMethods());
        Assert.assertEquals(Collections.singletonList(methodMapped), obj.getAddedMethodMappeds());
        Assert.assertEquals(list, obj.getAddedObjects());
        Assert.assertEquals(Collections.singletonMap(key, stringValue), obj.getStringValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getBoxedBooleanValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getBoxedByteValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getBoxedShortValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getBoxedIntValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getBoxedLongValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getBoxedFloatValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getBoxedDoubleValueMap());
        Assert.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getBoxedCharValueMap());
        Assert.assertEquals(Collections.singletonMap(key, jsonObjectDataObject), obj.getJsonObjectDataObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, stringDataObject), obj.getStringDataObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, buffer), obj.getBufferMap());
        Assert.assertEquals(Collections.singletonMap(key, jsonObject), obj.getJsonObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, jsonArray), obj.getJsonArrayMap());
        Assert.assertEquals(Collections.singletonMap(key, httpMethod), obj.getHttpMethodMap());
        Assert.assertEquals(Collections.singletonMap(key, methodMapped), obj.getMethodMappedMap());
        Assert.assertEquals(map, obj.getObjectMap());
        Assert.assertEquals(Collections.singletonMap(key, stringValue), obj.getKeyedStringValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getKeyedBoxedBooleanValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getKeyedBoxedByteValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getKeyedBoxedShortValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getKeyedBoxedIntValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getKeyedBoxedLongValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getKeyedBoxedFloatValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getKeyedBoxedDoubleValues());
        Assert.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getKeyedBoxedCharValues());
        Assert.assertEquals(Collections.singletonMap(key, jsonObjectDataObject), obj.getKeyedJsonObjectDataObjectValues());
        Assert.assertEquals(Collections.singletonMap(key, stringDataObject), obj.getKeyedStringDataObjectValues());
        Assert.assertEquals(Collections.singletonMap(key, buffer), obj.getKeyedBufferValues());
        Assert.assertEquals(Collections.singletonMap(key, jsonObject), obj.getKeyedJsonObjectValues());
        Assert.assertEquals(Collections.singletonMap(key, jsonArray), obj.getKeyedJsonArrayValues());
        Assert.assertEquals(Collections.singletonMap(key, httpMethod), obj.getKeyedEnumValues());
        Assert.assertEquals(Collections.singletonMap(key, methodMapped), obj.getKeyedMethodMappedValues());
        Assert.assertEquals(map, obj.getObjectMap());
    }

    @Test
    public void testEmptyJsonToDataObject() {
        JsonObject json = new JsonObject();
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, obj);
        Assert.assertEquals(null, (Object)obj.getString());
        Assert.assertEquals((Object)false, (Object)obj.isPrimitiveBoolean());
        Assert.assertEquals((long)0L, (long)obj.getPrimitiveByte());
        Assert.assertEquals((long)0L, (long)obj.getPrimitiveShort());
        Assert.assertEquals((long)0L, (long)obj.getPrimitiveInt());
        Assert.assertEquals((long)0L, (long)obj.getPrimitiveLong());
        Assert.assertEquals((float)0.0f, (float)obj.getPrimitiveFloat(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)obj.getPrimitiveDouble(), (double)0.0);
        Assert.assertEquals((long)0L, (long)obj.getPrimitiveChar());
        Assert.assertEquals(null, (Object)obj.isBoxedBoolean());
        Assert.assertEquals(null, (Object)obj.getBoxedByte());
        Assert.assertEquals(null, (Object)obj.getBoxedShort());
        Assert.assertEquals(null, (Object)obj.getBoxedInt());
        Assert.assertEquals(null, (Object)obj.getBoxedLong());
        Assert.assertEquals(null, (Object)obj.getBoxedFloat());
        Assert.assertEquals(null, (Object)obj.getBoxedDouble());
        Assert.assertEquals(null, (Object)obj.getBoxedChar());
        Assert.assertEquals(null, (Object)obj.getJsonObjectDataObject());
        Assert.assertEquals(null, (Object)obj.getStringDataObject());
        Assert.assertEquals(null, (Object)obj.getBuffer());
        Assert.assertEquals(null, (Object)obj.getJsonObject());
        Assert.assertEquals(null, (Object)obj.getJsonArray());
        Assert.assertEquals(null, (Object)obj.getMethodMapped());
        Assert.assertEquals(null, obj.getStringList());
        Assert.assertEquals(null, obj.getBoxedBooleanList());
        Assert.assertEquals(null, obj.getBoxedByteList());
        Assert.assertEquals(null, obj.getBoxedShortList());
        Assert.assertEquals(null, obj.getBoxedIntList());
        Assert.assertEquals(null, obj.getBoxedLongList());
        Assert.assertEquals(null, obj.getBoxedFloatList());
        Assert.assertEquals(null, obj.getBoxedDoubleList());
        Assert.assertEquals(null, obj.getBoxedCharList());
        Assert.assertEquals(null, obj.getJsonObjectDataObjectList());
        Assert.assertEquals(null, obj.getStringDataObjectList());
        Assert.assertEquals(null, obj.getBufferList());
        Assert.assertEquals(null, obj.getJsonObjectList());
        Assert.assertEquals(null, obj.getJsonArrayList());
        Assert.assertEquals(null, obj.getHttpMethodList());
        Assert.assertEquals(null, obj.getMethodMappedList());
        Assert.assertEquals(null, obj.getObjectList());
        Assert.assertEquals(null, obj.getStringSet());
        Assert.assertEquals(null, obj.getBoxedBooleanSet());
        Assert.assertEquals(null, obj.getBoxedByteSet());
        Assert.assertEquals(null, obj.getBoxedShortSet());
        Assert.assertEquals(null, obj.getBoxedIntSet());
        Assert.assertEquals(null, obj.getBoxedLongSet());
        Assert.assertEquals(null, obj.getBoxedFloatSet());
        Assert.assertEquals(null, obj.getBoxedDoubleSet());
        Assert.assertEquals(null, obj.getBoxedCharSet());
        Assert.assertEquals(null, obj.getJsonObjectDataObjectSet());
        Assert.assertEquals(null, obj.getStringDataObjectSet());
        Assert.assertEquals(null, obj.getBufferSet());
        Assert.assertEquals(null, obj.getJsonObjectSet());
        Assert.assertEquals(null, obj.getJsonArraySet());
        Assert.assertEquals(null, obj.getHttpMethodSet());
        Assert.assertEquals(null, obj.getMethodMappedSet());
        Assert.assertEquals(null, obj.getObjectSet());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedStringValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedBooleanValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedByteValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedShortValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedIntValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedLongValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedFloatValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedDoubleValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBoxedCharValues());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedJsonObjectDataObjects());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedStringDataObjects());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedBuffers());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedJsonObjects());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedJsonArrays());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedHttpMethods());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedMethodMappeds());
        Assert.assertEquals(Collections.emptyList(), obj.getAddedObjects());
        Assert.assertEquals(null, obj.getStringValueMap());
        Assert.assertEquals(null, obj.getBoxedBooleanValueMap());
        Assert.assertEquals(null, obj.getBoxedByteValueMap());
        Assert.assertEquals(null, obj.getBoxedShortValueMap());
        Assert.assertEquals(null, obj.getBoxedIntValueMap());
        Assert.assertEquals(null, obj.getBoxedLongValueMap());
        Assert.assertEquals(null, obj.getBoxedFloatValueMap());
        Assert.assertEquals(null, obj.getBoxedDoubleValueMap());
        Assert.assertEquals(null, obj.getBoxedCharValueMap());
        Assert.assertEquals(null, obj.getJsonObjectDataObjectMap());
        Assert.assertEquals(null, obj.getStringDataObjectMap());
        Assert.assertEquals(null, obj.getBufferMap());
        Assert.assertEquals(null, obj.getJsonObjectMap());
        Assert.assertEquals(null, obj.getJsonArrayMap());
        Assert.assertEquals(null, obj.getHttpMethodMap());
        Assert.assertEquals(null, obj.getMethodMappedMap());
        Assert.assertEquals(null, obj.getObjectMap());
    }

    @Test
    public void testDataObjectToJson() throws Exception {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        NestedJsonObjectDataObject jsonObjectDataObject = new NestedJsonObjectDataObject().setValue(TestUtils.randomAlphaString(20));
        NestedStringDataObject stringDataObject = new NestedStringDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", (Object)TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add((Object)TestUtils.randomAlphaString(20));
        TimeUnit httpMethod = TimeUnit.values()[TestUtils.randomPositiveInt() % TimeUnit.values().length];
        ZonedDateTime dateTime = ZonedDateTime.now();
        Locale uri = new Locale("en");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        TestDataObject obj = new TestDataObject();
        obj.setString(stringValue);
        obj.setPrimitiveBoolean(booleanValue);
        obj.setPrimitiveByte(byteValue);
        obj.setPrimitiveShort(shortValue);
        obj.setPrimitiveInt(intValue);
        obj.setPrimitiveLong(longValue);
        obj.setPrimitiveFloat(floatValue);
        obj.setPrimitiveDouble(doubleValue);
        obj.setPrimitiveChar(charValue);
        obj.setBoxedBoolean(boxedBooleanValue);
        obj.setBoxedByte(boxedByteValue);
        obj.setBoxedShort(boxedShortValue);
        obj.setBoxedInt(boxedIntValue);
        obj.setBoxedLong(boxedLongValue);
        obj.setBoxedFloat(boxedFloatValue);
        obj.setBoxedDouble(boxedDoubleValue);
        obj.setBoxedChar(boxedCharValue);
        obj.setJsonObjectDataObject(jsonObjectDataObject);
        obj.setStringDataObject(stringDataObject);
        obj.setBuffer(buffer);
        obj.setJsonObject(jsonObject);
        obj.setJsonArray(jsonArray);
        obj.setHttpMethod(httpMethod);
        obj.setMethodMapped(dateTime);
        obj.setStringList(Collections.singletonList(stringValue));
        obj.setBoxedBooleanList(Collections.singletonList(boxedBooleanValue));
        obj.setBoxedByteList(Collections.singletonList(boxedByteValue));
        obj.setBoxedShortList(Collections.singletonList(boxedShortValue));
        obj.setBoxedIntList(Collections.singletonList(boxedIntValue));
        obj.setBoxedLongList(Collections.singletonList(boxedLongValue));
        obj.setBoxedFloatList(Collections.singletonList(boxedFloatValue));
        obj.setBoxedDoubleList(Collections.singletonList(boxedDoubleValue));
        obj.setBoxedCharList(Collections.singletonList(boxedCharValue));
        obj.setJsonObjectDataObjectList(Collections.singletonList(jsonObjectDataObject));
        obj.setStringDataObjectList(Collections.singletonList(stringDataObject));
        obj.setBufferList(Collections.singletonList(buffer));
        obj.setJsonObjectList(Collections.singletonList(jsonObject));
        obj.setJsonArrayList(Collections.singletonList(jsonArray));
        obj.setHttpMethodList(Collections.singletonList(httpMethod));
        obj.setMethodMappedList(Collections.singletonList(dateTime));
        obj.setObjectList(list);
        obj.setStringValueMap(Collections.singletonMap(key, stringValue));
        obj.setStringSet(Collections.singleton(stringValue));
        obj.setBoxedBooleanSet(Collections.singleton(boxedBooleanValue));
        obj.setBoxedByteSet(Collections.singleton(boxedByteValue));
        obj.setBoxedShortSet(Collections.singleton(boxedShortValue));
        obj.setBoxedIntSet(Collections.singleton(boxedIntValue));
        obj.setBoxedLongSet(Collections.singleton(boxedLongValue));
        obj.setBoxedFloatSet(Collections.singleton(boxedFloatValue));
        obj.setBoxedDoubleSet(Collections.singleton(boxedDoubleValue));
        obj.setBoxedCharSet(Collections.singleton(boxedCharValue));
        obj.setJsonObjectDataObjectSet(Collections.singleton(jsonObjectDataObject));
        obj.setStringDataObjectSet(Collections.singleton(stringDataObject));
        obj.setBufferSet(Collections.singleton(buffer));
        obj.setJsonObjectSet(Collections.singleton(jsonObject));
        obj.setJsonArraySet(Collections.singleton(jsonArray));
        obj.setHttpMethodSet(Collections.singleton(httpMethod));
        obj.setMethodMappedSet(Collections.singleton(dateTime));
        obj.setObjectSet(new LinkedHashSet<Object>(list));
        obj.setBoxedBooleanValueMap(Collections.singletonMap(key, boxedBooleanValue));
        obj.setBoxedByteValueMap(Collections.singletonMap(key, boxedByteValue));
        obj.setBoxedShortValueMap(Collections.singletonMap(key, boxedShortValue));
        obj.setBoxedIntValueMap(Collections.singletonMap(key, boxedIntValue));
        obj.setBoxedLongValueMap(Collections.singletonMap(key, boxedLongValue));
        obj.setBoxedFloatValueMap(Collections.singletonMap(key, boxedFloatValue));
        obj.setBoxedDoubleValueMap(Collections.singletonMap(key, boxedDoubleValue));
        obj.setBoxedCharValueMap(Collections.singletonMap(key, boxedCharValue));
        obj.setJsonObjectDataObjectMap(Collections.singletonMap(key, jsonObjectDataObject));
        obj.setStringDataObjectMap(Collections.singletonMap(key, stringDataObject));
        obj.setBufferMap(Collections.singletonMap(key, buffer));
        obj.setJsonObjectMap(Collections.singletonMap(key, jsonObject));
        obj.setJsonArrayMap(Collections.singletonMap(key, jsonArray));
        obj.setHttpMethodMap(Collections.singletonMap(key, httpMethod));
        obj.setMethodMappedMap(Collections.singletonMap(key, dateTime));
        obj.setObjectMap(map);
        obj.addKeyedStringValue(key, stringValue);
        obj.addKeyedBoxedBooleanValue(key, boxedBooleanValue);
        obj.addKeyedBoxedByteValue(key, boxedByteValue);
        obj.addKeyedBoxedShortValue(key, boxedShortValue);
        obj.addKeyedBoxedIntValue(key, boxedIntValue);
        obj.addKeyedBoxedLongValue(key, boxedLongValue);
        obj.addKeyedBoxedFloatValue(key, boxedFloatValue);
        obj.addKeyedBoxedDoubleValue(key, boxedDoubleValue);
        obj.addKeyedBoxedCharValue(key, boxedCharValue);
        obj.addKeyedJsonObjectDataObjectValue(key, jsonObjectDataObject);
        obj.addKeyedStringDataObjectValue(key, stringDataObject);
        obj.addKeyedBufferValue(key, buffer);
        obj.addKeyedJsonObjectValue(key, jsonObject);
        obj.addKeyedJsonArrayValue(key, jsonArray);
        obj.addKeyedEnumValue(key, httpMethod);
        obj.addKeyedMethodMappedValue(key, dateTime);
        map.forEach(obj::addKeyedObjectValue);
        HashMap<String, Object> json = new HashMap<String, Object>();
        TestDataObjectConverter.toJson(obj, json);
        Assert.assertEquals((Object)stringValue, json.get("string"));
        Assert.assertEquals((Object)booleanValue, json.get("primitiveBoolean"));
        Assert.assertEquals((long)byteValue, (long)((Byte)json.get("primitiveByte")).byteValue());
        Assert.assertEquals((long)shortValue, (long)((Short)json.get("primitiveShort")).shortValue());
        Assert.assertEquals((long)intValue, (long)((Integer)json.get("primitiveInt")).intValue());
        Assert.assertEquals((long)longValue, (long)((Long)json.get("primitiveLong")));
        Assert.assertEquals((double)floatValue, (double)((Float)json.get("primitiveFloat")).floatValue(), (double)0.001);
        Assert.assertEquals((double)doubleValue, (double)((Double)json.get("primitiveDouble")), (double)0.001);
        Assert.assertEquals((Object)Character.toString(charValue), json.get("primitiveChar"));
        Assert.assertEquals((Object)boxedBooleanValue, json.get("boxedBoolean"));
        Assert.assertEquals((long)boxedByteValue.byteValue(), (long)((Byte)json.get("boxedByte")).byteValue());
        Assert.assertEquals((long)boxedShortValue.shortValue(), (long)((Short)json.get("boxedShort")).shortValue());
        Assert.assertEquals((Object)boxedIntValue, json.get("boxedInt"));
        Assert.assertEquals((Object)boxedLongValue, json.get("boxedLong"));
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)json.get("boxedFloat")).floatValue(), (double)0.001);
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)json.get("boxedDouble")), (double)0.001);
        Assert.assertEquals((Object)Character.toString(boxedCharValue.charValue()), json.get("boxedChar"));
        Assert.assertEquals((Object)jsonObjectDataObject.toJson(), json.get("jsonObjectDataObject"));
        Assert.assertEquals((Object)stringDataObject.toJson(), json.get("stringDataObject"));
        Assert.assertEquals((Object)buffer, (Object)Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)json.get("buffer"))));
        Assert.assertEquals((Object)jsonObject, json.get("jsonObject"));
        Assert.assertEquals((Object)jsonArray, json.get("jsonArray"));
        Assert.assertEquals((Object)httpMethod.name(), json.get("httpMethod"));
        Assert.assertEquals((Object)dateTime.toString(), json.get("methodMapped"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringValue), json.get("stringList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedBooleanValue), json.get("boxedBooleanList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedByteValue), json.get("boxedByteList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedShortValue), json.get("boxedShortList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedIntValue), json.get("boxedIntList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedLongValue), json.get("boxedLongList"));
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedFloatList")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonArray)json.get("boxedFloatList")).getValue(0)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedDoubleList")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonArray)json.get("boxedDoubleList")).getValue(0)), (double)0.001);
        Assert.assertEquals((Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObjectDataObject.toJson()), json.get("jsonObjectDataObjectList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringDataObject.toJson()), json.get("stringDataObjectList"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes()), (Object)((JsonArray)json.get("bufferList")).getValue(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObject), json.get("jsonObjectList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonArray), json.get("jsonArrayList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)httpMethod.name()), json.get("httpMethodList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)dateTime.toString()), json.get("methodMappedList"));
        Assert.assertEquals((Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)), json.get("objectList"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringValue), json.get("stringSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedBooleanValue), json.get("boxedBooleanSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedByteValue), json.get("boxedByteSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedShortValue), json.get("boxedShortSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedIntValue), json.get("boxedIntSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)boxedLongValue), json.get("boxedLongSet"));
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedFloatSet")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonArray)json.get("boxedFloatSet")).getValue(0)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonArray)json.get("boxedDoubleSet")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonArray)json.get("boxedDoubleSet")).getValue(0)), (double)0.001);
        Assert.assertEquals((Object)new JsonArray().add((Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObjectDataObject.toJson()), json.get("jsonObjectDataObjectSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)stringDataObject.toJson()), json.get("stringDataObjectSet"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes()), (Object)((JsonArray)json.get("bufferSet")).getValue(0));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonObject), json.get("jsonObjectSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)jsonArray), json.get("jsonArraySet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)httpMethod.name()), json.get("httpMethodSet"));
        Assert.assertEquals((Object)new JsonArray().add((Object)dateTime.toString()), json.get("methodMappedSet"));
        Assert.assertEquals((Object)new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)), json.get("objectSet"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringValue), json.get("stringValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedBooleanValue), json.get("boxedBooleanValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedByteValue), json.get("boxedByteValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedShortValue), json.get("boxedShortValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedIntValue), json.get("boxedIntValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedLongValue), json.get("boxedLongValueMap"));
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("boxedFloatValueMap")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonObject)json.get("boxedFloatValueMap")).getValue(key)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("boxedDoubleValueMap")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonObject)json.get("boxedDoubleValueMap")).getValue(key)), (double)0.001);
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())), json.get("boxedCharValueMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObjectDataObject.toJson()), json.get("jsonObjectDataObjectMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringDataObject.toJson()), json.get("stringDataObjectMap"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes()), (Object)((JsonObject)json.get("bufferMap")).getValue(key));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObject), json.get("jsonObjectMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonArray), json.get("jsonArrayMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)httpMethod.name()), json.get("httpMethodMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)dateTime.toString()), json.get("methodMappedMap"));
        Assert.assertEquals((Object)DataObjectTest.toJson(map), json.get("objectMap"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringValue), json.get("keyedStringValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedBooleanValue), json.get("keyedBoxedBooleanValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedByteValue), json.get("keyedBoxedByteValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedShortValue), json.get("keyedBoxedShortValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedIntValue), json.get("keyedBoxedIntValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)boxedLongValue), json.get("keyedBoxedLongValues"));
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("keyedBoxedFloatValues")).size());
        Assert.assertEquals((double)boxedFloatValue.floatValue(), (double)((Float)((JsonObject)json.get("keyedBoxedFloatValues")).getValue(key)).floatValue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)((JsonObject)json.get("keyedBoxedDoubleValues")).size());
        Assert.assertEquals((double)boxedDoubleValue, (double)((Double)((JsonObject)json.get("keyedBoxedDoubleValues")).getValue(key)), (double)0.001);
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)Character.toString(boxedCharValue.charValue())), json.get("keyedBoxedCharValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObjectDataObject.toJson()), json.get("keyedJsonObjectDataObjectValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)stringDataObject.toJson()), json.get("keyedStringDataObjectValues"));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes()), (Object)((JsonObject)json.get("keyedBufferValues")).getValue(key));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonObject), json.get("keyedJsonObjectValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)jsonArray), json.get("keyedJsonArrayValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)httpMethod.name()), json.get("keyedEnumValues"));
        Assert.assertEquals((Object)new JsonObject().put(key, (Object)dateTime.toString()), json.get("keyedMethodMappedValues"));
        Assert.assertEquals((Object)DataObjectTest.toJson(map), json.get("keyedObjectValues"));
    }

    @Test
    public void testEmptyDataObjectToJson() {
        TestDataObject obj = new TestDataObject();
        HashMap<String, Object> json = new HashMap<String, Object>();
        TestDataObjectConverter.toJson(obj, json);
        Assert.assertEquals(null, json.get("string"));
        Assert.assertEquals((Object)false, json.get("primitiveBoolean"));
        Assert.assertEquals((long)0L, (long)((Byte)json.get("primitiveByte")).byteValue());
        Assert.assertEquals((long)0L, (long)((Short)json.get("primitiveShort")).shortValue());
        Assert.assertEquals((long)0L, (long)((Integer)json.get("primitiveInt")).intValue());
        Assert.assertEquals((long)0L, (long)((Long)json.get("primitiveLong")));
        Assert.assertEquals((float)0.0f, (float)((Float)json.get("primitiveFloat")).floatValue(), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)((Double)json.get("primitiveDouble")), (double)0.0);
        Assert.assertEquals((Object)Character.toString('\u0000'), json.get("primitiveChar"));
        Assert.assertEquals(null, json.get("boxedBoolean"));
        Assert.assertEquals(null, json.get("boxedByte"));
        Assert.assertEquals(null, json.get("boxedShort"));
        Assert.assertEquals(null, json.get("boxedInt"));
        Assert.assertEquals(null, json.get("boxedLong"));
        Assert.assertEquals(null, json.get("boxedFloat"));
        Assert.assertEquals(null, json.get("boxedDouble"));
        Assert.assertEquals(null, json.get("boxedChar"));
        Assert.assertEquals(null, json.get("jsonObjectDataObject"));
        Assert.assertEquals(null, json.get("stringDataObject"));
        Assert.assertEquals(null, json.get("buffer"));
        Assert.assertEquals(null, json.get("jsonObject"));
        Assert.assertEquals(null, json.get("jsonArray"));
        Assert.assertEquals(null, json.get("httpMethod"));
        Assert.assertEquals(null, json.get("methodMapped"));
        Assert.assertEquals(null, json.get("stringList"));
        Assert.assertEquals(null, json.get("boxedBooleanList"));
        Assert.assertEquals(null, json.get("boxedByteList"));
        Assert.assertEquals(null, json.get("boxedShortList"));
        Assert.assertEquals(null, json.get("boxedIntList"));
        Assert.assertEquals(null, json.get("boxedLongList"));
        Assert.assertEquals(null, json.get("boxedFloatList"));
        Assert.assertEquals(null, json.get("boxedDoubleList"));
        Assert.assertEquals(null, json.get("boxedCharList"));
        Assert.assertEquals(null, json.get("jsonObjectDataObjectList"));
        Assert.assertEquals(null, json.get("stringDataObjectList"));
        Assert.assertEquals(null, json.get("bufferList"));
        Assert.assertEquals(null, json.get("jsonObjectList"));
        Assert.assertEquals(null, json.get("jsonArrayList"));
        Assert.assertEquals(null, json.get("httpMethodList"));
        Assert.assertEquals(null, json.get("methodMappedList"));
        Assert.assertEquals(null, json.get("objectList"));
        Assert.assertEquals(null, json.get("stringSet"));
        Assert.assertEquals(null, json.get("boxedBooleanSet"));
        Assert.assertEquals(null, json.get("boxedByteSet"));
        Assert.assertEquals(null, json.get("boxedShortSet"));
        Assert.assertEquals(null, json.get("boxedIntSet"));
        Assert.assertEquals(null, json.get("boxedLongSet"));
        Assert.assertEquals(null, json.get("boxedFloatSet"));
        Assert.assertEquals(null, json.get("boxedDoubleSet"));
        Assert.assertEquals(null, json.get("boxedCharSet"));
        Assert.assertEquals(null, json.get("jsonObjectDataObjectSet"));
        Assert.assertEquals(null, json.get("stringDataObjectSet"));
        Assert.assertEquals(null, json.get("bufferSet"));
        Assert.assertEquals(null, json.get("jsonObjectSet"));
        Assert.assertEquals(null, json.get("jsonArraySet"));
        Assert.assertEquals(null, json.get("httpMethodSet"));
        Assert.assertEquals(null, json.get("methodMappedSet"));
        Assert.assertEquals(null, json.get("objectSet"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedStringValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedBooleanValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedByteValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedShortValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedIntValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedLongValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedFloatValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedDoubleValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBoxedCharValues"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedStringDataObjects"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedBuffers"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedJsonObjects"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedJsonArrays"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedHttpMethods"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedMethodMappeds"));
        Assert.assertEquals((Object)new JsonArray(), json.get("addedObjects"));
        Assert.assertEquals(null, json.get("stringValueMap"));
        Assert.assertEquals(null, json.get("boxedBooleanValueMap"));
        Assert.assertEquals(null, json.get("boxedByteValueMap"));
        Assert.assertEquals(null, json.get("boxedShortValueMap"));
        Assert.assertEquals(null, json.get("boxedIntValueMap"));
        Assert.assertEquals(null, json.get("boxedLongValueMap"));
        Assert.assertEquals(null, json.get("boxedFloatValueMap"));
        Assert.assertEquals(null, json.get("boxedDoubleValueMap"));
        Assert.assertEquals(null, json.get("boxedCharValueMap"));
        Assert.assertEquals(null, json.get("stringDataObjectMap"));
        Assert.assertEquals(null, json.get("bufferMap"));
        Assert.assertEquals(null, json.get("jsonObjectMap"));
        Assert.assertEquals(null, json.get("jsonArrayMap"));
        Assert.assertEquals(null, json.get("httpMethodMap"));
        Assert.assertEquals(null, json.get("methodMappedMap"));
        Assert.assertEquals(null, json.get("objectMap"));
    }

    @Test
    public void testInherit() {
        ChildInheritingDataObject obj = new ChildInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", (Object)"childProperty_value");
        expectedJson.put("parentProperty", (Object)"parentProperty_value");
        ChildInheritingDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)expectedJson, obj);
        Assert.assertEquals((Object)"childProperty_value", (Object)obj.getChildProperty());
        Assert.assertEquals((Object)"parentProperty_value", (Object)obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildInheritingDataObjectConverter.toJson(obj, json);
        Assert.assertEquals((Object)expectedJson, (Object)json);
    }

    @Test
    public void testNotInherit() {
        ChildNotInheritingDataObject obj = new ChildNotInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", (Object)"childProperty_value");
        expectedJson.put("parentProperty", (Object)"parentProperty_value");
        ChildNotInheritingDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)expectedJson, obj);
        Assert.assertEquals((Object)"childProperty_value", (Object)obj.getChildProperty());
        Assert.assertEquals(null, (Object)obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildNotInheritingDataObjectConverter.toJson(obj, json);
        expectedJson.remove("parentProperty");
        Assert.assertEquals((Object)expectedJson, (Object)json);
    }

    private String toBase64(Buffer buffer) {
        return JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes());
    }

    @Test
    public void testPreferSetterToAdder() {
        SetterAdderDataObject obj = new SetterAdderDataObject();
        SetterAdderDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)new JsonObject().put("values", (Object)new JsonArray().add((Object)"first").add((Object)"second")), obj);
        Assert.assertEquals(Arrays.asList("first", "second"), obj.getValues());
        Assert.assertEquals((long)1L, (long)obj.sets);
        Assert.assertEquals((long)0L, (long)obj.adds);
    }

    @Test
    public void testSnakeFormatted() {
        SnakeFormattedDataObject obj = new SnakeFormattedDataObject();
        JsonObject expected = new JsonObject().put("foo", (Object)"val1").put("foo_bar", (Object)"val2").put("foo_bar_juu", (Object)"val3");
        SnakeFormattedDataObjectConverter.fromJson((Iterable<Map.Entry<String, Object>>)expected, obj);
        Assert.assertEquals((Object)"val1", (Object)obj.getFoo());
        Assert.assertEquals((Object)"val2", (Object)obj.getFooBar());
        Assert.assertEquals((Object)"val3", (Object)obj.getFooBarJuu());
        JsonObject test = new JsonObject();
        SnakeFormattedDataObjectConverter.toJson(obj, test);
        Assert.assertEquals((Object)expected, (Object)test);
    }
}

