/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.converter;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.test.codegen.converter.NestedJsonObjectDataObject;
import io.vertx.test.codegen.converter.NestedStringDataObject;
import io.vertx.test.codegen.converter.NoConverterDataObject;
import io.vertx.test.codegen.converter.TestDataObject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TestDataObjectConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, TestDataObject obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "addedBoxedBooleanValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            obj.addAddedBoxedBooleanValue((Boolean)item);
                        }
                    });
                    break;
                }
                case "addedBoxedByteValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedByteValue(((Number)item).byteValue());
                        }
                    });
                    break;
                }
                case "addedBoxedCharValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedBoxedCharValue(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    break;
                }
                case "addedBoxedDoubleValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedDoubleValue(((Number)item).doubleValue());
                        }
                    });
                    break;
                }
                case "addedBoxedFloatValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedFloatValue(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    break;
                }
                case "addedBoxedIntValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedIntValue(((Number)item).intValue());
                        }
                    });
                    break;
                }
                case "addedBoxedLongValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedLongValue(((Number)item).longValue());
                        }
                    });
                    break;
                }
                case "addedBoxedShortValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            obj.addAddedBoxedShortValue(((Number)item).shortValue());
                        }
                    });
                    break;
                }
                case "addedBuffers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedBuffer(Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)item)));
                        }
                    });
                    break;
                }
                case "addedHttpMethods": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedHttpMethod(TimeUnit.valueOf((String)item));
                        }
                    });
                    break;
                }
                case "addedJsonArrays": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            obj.addAddedJsonArray(((JsonArray)item).copy());
                        }
                    });
                    break;
                }
                case "addedJsonObjectDataObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addAddedJsonObjectDataObject(new NestedJsonObjectDataObject((JsonObject)item));
                        }
                    });
                    break;
                }
                case "addedJsonObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addAddedJsonObject(((JsonObject)item).copy());
                        }
                    });
                    break;
                }
                case "addedMethodMappeds": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedMethodMapped(TestDataObject.deserializeZonedDateTime((String)item));
                        }
                    });
                    break;
                }
                case "addedObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            obj.addAddedObject(item);
                        }
                    });
                    break;
                }
                case "addedStringDataObjects": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedStringDataObject(new NestedStringDataObject((String)item));
                        }
                    });
                    break;
                }
                case "addedStringValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addAddedStringValue((String)item);
                        }
                    });
                    break;
                }
                case "boxedBoolean": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBoxedBoolean((Boolean)member.getValue());
                    break;
                }
                case "boxedBooleanList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            list.add((Boolean)item);
                        }
                    });
                    obj.setBoxedBooleanList(list);
                    break;
                }
                case "boxedBooleanSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Boolean) {
                            list.add((Boolean)item);
                        }
                    });
                    obj.setBoxedBooleanSet((Set<Boolean>)((Object)list));
                    break;
                }
                case "boxedBooleanValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            map.put((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    obj.setBoxedBooleanValueMap(map);
                    break;
                }
                case "boxedByte": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedByte(((Number)member.getValue()).byteValue());
                    break;
                }
                case "boxedByteList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).byteValue());
                        }
                    });
                    obj.setBoxedByteList(list);
                    break;
                }
                case "boxedByteSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).byteValue());
                        }
                    });
                    obj.setBoxedByteSet((Set<Byte>)((Object)list));
                    break;
                }
                case "boxedByteValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).byteValue());
                        }
                    });
                    obj.setBoxedByteValueMap(map);
                    break;
                }
                case "boxedChar": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBoxedChar(Character.valueOf(((String)member.getValue()).charAt(0)));
                    break;
                }
                case "boxedCharList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    obj.setBoxedCharList(list);
                    break;
                }
                case "boxedCharSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Character.valueOf(((String)item).charAt(0)));
                        }
                    });
                    obj.setBoxedCharSet((Set<Character>)((Object)list));
                    break;
                }
                case "boxedCharValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), Character.valueOf(((String)entry.getValue()).charAt(0)));
                        }
                    });
                    obj.setBoxedCharValueMap(map);
                    break;
                }
                case "boxedDouble": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedDouble(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "boxedDoubleList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleList(list);
                    break;
                }
                case "boxedDoubleSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleSet((Set<Double>)((Object)list));
                    break;
                }
                case "boxedDoubleValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                        }
                    });
                    obj.setBoxedDoubleValueMap(map);
                    break;
                }
                case "boxedFloat": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedFloat(Float.valueOf(((Number)member.getValue()).floatValue()));
                    break;
                }
                case "boxedFloatList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    obj.setBoxedFloatList(list);
                    break;
                }
                case "boxedFloatSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(Float.valueOf(((Number)item).floatValue()));
                        }
                    });
                    obj.setBoxedFloatSet((Set<Float>)((Object)list));
                    break;
                }
                case "boxedFloatValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
                        }
                    });
                    obj.setBoxedFloatValueMap(map);
                    break;
                }
                case "boxedInt": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedInt(((Number)member.getValue()).intValue());
                    break;
                }
                case "boxedIntList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).intValue());
                        }
                    });
                    obj.setBoxedIntList(list);
                    break;
                }
                case "boxedIntSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).intValue());
                        }
                    });
                    obj.setBoxedIntSet((Set<Integer>)((Object)list));
                    break;
                }
                case "boxedIntValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    obj.setBoxedIntValueMap(map);
                    break;
                }
                case "boxedLong": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedLong(((Number)member.getValue()).longValue());
                    break;
                }
                case "boxedLongList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).longValue());
                        }
                    });
                    obj.setBoxedLongList(list);
                    break;
                }
                case "boxedLongSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).longValue());
                        }
                    });
                    obj.setBoxedLongSet((Set<Long>)((Object)list));
                    break;
                }
                case "boxedLongValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).longValue());
                        }
                    });
                    obj.setBoxedLongValueMap(map);
                    break;
                }
                case "boxedShort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBoxedShort(((Number)member.getValue()).shortValue());
                    break;
                }
                case "boxedShortList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).shortValue());
                        }
                    });
                    obj.setBoxedShortList(list);
                    break;
                }
                case "boxedShortSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Number) {
                            list.add(((Number)item).shortValue());
                        }
                    });
                    obj.setBoxedShortSet((Set<Short>)((Object)list));
                    break;
                }
                case "boxedShortValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            map.put((String)entry.getKey(), ((Number)entry.getValue()).shortValue());
                        }
                    });
                    obj.setBoxedShortValueMap(map);
                    break;
                }
                case "buffer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBuffer(Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "bufferList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)item)));
                        }
                    });
                    obj.setBufferList(list);
                    break;
                }
                case "bufferMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)entry.getValue())));
                        }
                    });
                    obj.setBufferMap(map);
                    break;
                }
                case "bufferSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)item)));
                        }
                    });
                    obj.setBufferSet((Set<Buffer>)((Object)list));
                    break;
                }
                case "httpMethod": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHttpMethod(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "httpMethodList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Object)TimeUnit.valueOf((String)item));
                        }
                    });
                    obj.setHttpMethodList(list);
                    break;
                }
                case "httpMethodMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (Object)TimeUnit.valueOf((String)entry.getValue()));
                        }
                    });
                    obj.setHttpMethodMap(map);
                    break;
                }
                case "httpMethodSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((Object)TimeUnit.valueOf((String)item));
                        }
                    });
                    obj.setHttpMethodSet((Set<TimeUnit>)((Object)list));
                    break;
                }
                case "jsonArray": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setJsonArray(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "jsonArrayList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add(((JsonArray)item).copy());
                        }
                    });
                    obj.setJsonArrayList(list);
                    break;
                }
                case "jsonArrayMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            map.put((String)entry.getKey(), ((JsonArray)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonArrayMap(map);
                    break;
                }
                case "jsonArraySet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonArray) {
                            list.add(((JsonArray)item).copy());
                        }
                    });
                    obj.setJsonArraySet((Set<JsonArray>)((Object)list));
                    break;
                }
                case "jsonObject": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJsonObject(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "jsonObjectDataObject": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJsonObjectDataObject(new NestedJsonObjectDataObject((JsonObject)member.getValue()));
                    break;
                }
                case "jsonObjectDataObjectList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new NestedJsonObjectDataObject((JsonObject)item));
                        }
                    });
                    obj.setJsonObjectDataObjectList(list);
                    break;
                }
                case "jsonObjectDataObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), new NestedJsonObjectDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    obj.setJsonObjectDataObjectMap(map);
                    break;
                }
                case "jsonObjectDataObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new NestedJsonObjectDataObject((JsonObject)item));
                        }
                    });
                    obj.setJsonObjectDataObjectSet((Set<NestedJsonObjectDataObject>)((Object)list));
                    break;
                }
                case "jsonObjectList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(((JsonObject)item).copy());
                        }
                    });
                    obj.setJsonObjectList(list);
                    break;
                }
                case "jsonObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), ((JsonObject)entry.getValue()).copy());
                        }
                    });
                    obj.setJsonObjectMap(map);
                    break;
                }
                case "jsonObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(((JsonObject)item).copy());
                        }
                    });
                    obj.setJsonObjectSet((Set<JsonObject>)((Object)list));
                    break;
                }
                case "keyedBoxedBooleanValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Boolean) {
                            obj.addKeyedBoxedBooleanValue((String)entry.getKey(), (Boolean)entry.getValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedByteValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedByteValue((String)entry.getKey(), ((Number)entry.getValue()).byteValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedCharValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedBoxedCharValue((String)entry.getKey(), Character.valueOf(((String)entry.getValue()).charAt(0)));
                        }
                    });
                    break;
                }
                case "keyedBoxedDoubleValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedDoubleValue((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedFloatValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedFloatValue((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
                        }
                    });
                    break;
                }
                case "keyedBoxedIntValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedIntValue((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedLongValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedLongValue((String)entry.getKey(), ((Number)entry.getValue()).longValue());
                        }
                    });
                    break;
                }
                case "keyedBoxedShortValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Number) {
                            obj.addKeyedBoxedShortValue((String)entry.getKey(), ((Number)entry.getValue()).shortValue());
                        }
                    });
                    break;
                }
                case "keyedBufferValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedBufferValue((String)entry.getKey(), Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)entry.getValue())));
                        }
                    });
                    break;
                }
                case "keyedEnumValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedEnumValue((String)entry.getKey(), TimeUnit.valueOf((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedJsonArrayValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonArray) {
                            obj.addKeyedJsonArrayValue((String)entry.getKey(), ((JsonArray)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "keyedJsonObjectDataObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addKeyedJsonObjectDataObjectValue((String)entry.getKey(), new NestedJsonObjectDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedJsonObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            obj.addKeyedJsonObjectValue((String)entry.getKey(), ((JsonObject)entry.getValue()).copy());
                        }
                    });
                    break;
                }
                case "keyedMethodMappedValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedMethodMappedValue((String)entry.getKey(), TestDataObject.deserializeZonedDateTime((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Object) {
                            obj.addKeyedObjectValue((String)entry.getKey(), entry.getValue());
                        }
                    });
                    break;
                }
                case "keyedStringDataObjectValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedStringDataObjectValue((String)entry.getKey(), new NestedStringDataObject((String)entry.getValue()));
                        }
                    });
                    break;
                }
                case "keyedStringValues": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addKeyedStringValue((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    break;
                }
                case "methodMapped": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMethodMapped(TestDataObject.deserializeZonedDateTime((String)member.getValue()));
                    break;
                }
                case "methodMappedList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(TestDataObject.deserializeZonedDateTime((String)item));
                        }
                    });
                    obj.setMethodMappedList(list);
                    break;
                }
                case "methodMappedMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), TestDataObject.deserializeZonedDateTime((String)entry.getValue()));
                        }
                    });
                    obj.setMethodMappedMap(map);
                    break;
                }
                case "methodMappedSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(TestDataObject.deserializeZonedDateTime((String)item));
                        }
                    });
                    obj.setMethodMappedSet((Set<ZonedDateTime>)((Object)list));
                    break;
                }
                case "notConvertibleDataObject": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNotConvertibleDataObject(new NoConverterDataObject((JsonObject)member.getValue()));
                    break;
                }
                case "notConvertibleDataObjectList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new NoConverterDataObject((JsonObject)item));
                        }
                    });
                    obj.setNotConvertibleDataObjectList(list);
                    break;
                }
                case "notConvertibleDataObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof JsonObject) {
                            map.put((String)entry.getKey(), new NoConverterDataObject((JsonObject)entry.getValue()));
                        }
                    });
                    obj.setNotConvertibleDataObjectMap(map);
                    break;
                }
                case "notConvertibleDataObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new NoConverterDataObject((JsonObject)item));
                        }
                    });
                    obj.setNotConvertibleDataObjectSet((Set<NoConverterDataObject>)((Object)list));
                    break;
                }
                case "objectList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            list.add(item);
                        }
                    });
                    obj.setObjectList(list);
                    break;
                }
                case "objectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Object) {
                            map.put((String)entry.getKey(), entry.getValue());
                        }
                    });
                    obj.setObjectMap(map);
                    break;
                }
                case "objectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof Object) {
                            list.add(item);
                        }
                    });
                    obj.setObjectSet((Set<Object>)((Object)list));
                    break;
                }
                case "primitiveBoolean": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPrimitiveBoolean((Boolean)member.getValue());
                    break;
                }
                case "primitiveByte": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveByte(((Number)member.getValue()).byteValue());
                    break;
                }
                case "primitiveChar": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPrimitiveChar(((String)member.getValue()).charAt(0));
                    break;
                }
                case "primitiveDouble": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveDouble(((Number)member.getValue()).doubleValue());
                    break;
                }
                case "primitiveFloat": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveFloat(((Number)member.getValue()).floatValue());
                    break;
                }
                case "primitiveInt": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveInt(((Number)member.getValue()).intValue());
                    break;
                }
                case "primitiveLong": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveLong(((Number)member.getValue()).longValue());
                    break;
                }
                case "primitiveShort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPrimitiveShort(((Number)member.getValue()).shortValue());
                    break;
                }
                case "string": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setString((String)member.getValue());
                    break;
                }
                case "stringDataObject": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStringDataObject(new NestedStringDataObject((String)member.getValue()));
                    break;
                }
                case "stringDataObjectList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(new NestedStringDataObject((String)item));
                        }
                    });
                    obj.setStringDataObjectList(list);
                    break;
                }
                case "stringDataObjectMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), new NestedStringDataObject((String)entry.getValue()));
                        }
                    });
                    obj.setStringDataObjectMap(map);
                    break;
                }
                case "stringDataObjectSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(new NestedStringDataObject((String)item));
                        }
                    });
                    obj.setStringDataObjectSet((Set<NestedStringDataObject>)((Object)list));
                    break;
                }
                case "stringList": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setStringList(list);
                    break;
                }
                case "stringSet": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Object> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setStringSet((Set<String>)((Object)list));
                    break;
                }
                case "stringValueMap": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setStringValueMap(map);
                }
            }
        }
    }

    public static void toJson(TestDataObject obj, JsonObject json) {
        TestDataObjectConverter.toJson(obj, json.getMap());
    }

    public static void toJson(TestDataObject obj, Map<String, Object> json) {
        JsonObject map;
        JsonArray array;
        if (obj.getAddedBoxedBooleanValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedBooleanValues().forEach(item -> array.add(item));
            json.put("addedBoxedBooleanValues", array);
        }
        if (obj.getAddedBoxedByteValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedByteValues().forEach(item -> array.add(item));
            json.put("addedBoxedByteValues", array);
        }
        if (obj.getAddedBoxedCharValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedCharValues().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("addedBoxedCharValues", array);
        }
        if (obj.getAddedBoxedDoubleValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedDoubleValues().forEach(item -> array.add(item));
            json.put("addedBoxedDoubleValues", array);
        }
        if (obj.getAddedBoxedFloatValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedFloatValues().forEach(item -> array.add(item));
            json.put("addedBoxedFloatValues", array);
        }
        if (obj.getAddedBoxedIntValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedIntValues().forEach(item -> array.add(item));
            json.put("addedBoxedIntValues", array);
        }
        if (obj.getAddedBoxedLongValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedLongValues().forEach(item -> array.add(item));
            json.put("addedBoxedLongValues", array);
        }
        if (obj.getAddedBoxedShortValues() != null) {
            array = new JsonArray();
            obj.getAddedBoxedShortValues().forEach(item -> array.add(item));
            json.put("addedBoxedShortValues", array);
        }
        if (obj.getAddedBuffers() != null) {
            array = new JsonArray();
            obj.getAddedBuffers().forEach(item -> array.add((Object)JsonUtil.BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("addedBuffers", array);
        }
        if (obj.getAddedHttpMethods() != null) {
            array = new JsonArray();
            obj.getAddedHttpMethods().forEach(item -> array.add((Object)item.name()));
            json.put("addedHttpMethods", array);
        }
        if (obj.getAddedJsonArrays() != null) {
            array = new JsonArray();
            obj.getAddedJsonArrays().forEach(item -> array.add(item));
            json.put("addedJsonArrays", array);
        }
        if (obj.getAddedJsonObjectDataObjects() != null) {
            array = new JsonArray();
            obj.getAddedJsonObjectDataObjects().forEach(item -> array.add((Object)item.toJson()));
            json.put("addedJsonObjectDataObjects", array);
        }
        if (obj.getAddedJsonObjects() != null) {
            array = new JsonArray();
            obj.getAddedJsonObjects().forEach(item -> array.add(item));
            json.put("addedJsonObjects", array);
        }
        if (obj.getAddedMethodMappeds() != null) {
            array = new JsonArray();
            obj.getAddedMethodMappeds().forEach(item -> array.add((Object)TestDataObject.serializeZonedDateTime(item)));
            json.put("addedMethodMappeds", array);
        }
        if (obj.getAddedObjects() != null) {
            array = new JsonArray();
            obj.getAddedObjects().forEach(item -> array.add(item));
            json.put("addedObjects", array);
        }
        if (obj.getAddedStringDataObjects() != null) {
            array = new JsonArray();
            obj.getAddedStringDataObjects().forEach(item -> array.add((Object)item.toJson()));
            json.put("addedStringDataObjects", array);
        }
        if (obj.getAddedStringValues() != null) {
            array = new JsonArray();
            obj.getAddedStringValues().forEach(item -> array.add(item));
            json.put("addedStringValues", array);
        }
        if (obj.isBoxedBoolean() != null) {
            json.put("boxedBoolean", obj.isBoxedBoolean());
        }
        if (obj.getBoxedBooleanList() != null) {
            array = new JsonArray();
            obj.getBoxedBooleanList().forEach(item -> array.add(item));
            json.put("boxedBooleanList", array);
        }
        if (obj.getBoxedBooleanSet() != null) {
            array = new JsonArray();
            obj.getBoxedBooleanSet().forEach(item -> array.add(item));
            json.put("boxedBooleanSet", array);
        }
        if (obj.getBoxedBooleanValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedBooleanValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedBooleanValueMap", map);
        }
        if (obj.getBoxedByte() != null) {
            json.put("boxedByte", obj.getBoxedByte());
        }
        if (obj.getBoxedByteList() != null) {
            array = new JsonArray();
            obj.getBoxedByteList().forEach(item -> array.add(item));
            json.put("boxedByteList", array);
        }
        if (obj.getBoxedByteSet() != null) {
            array = new JsonArray();
            obj.getBoxedByteSet().forEach(item -> array.add(item));
            json.put("boxedByteSet", array);
        }
        if (obj.getBoxedByteValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedByteValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedByteValueMap", map);
        }
        if (obj.getBoxedChar() != null) {
            json.put("boxedChar", Character.toString(obj.getBoxedChar().charValue()));
        }
        if (obj.getBoxedCharList() != null) {
            array = new JsonArray();
            obj.getBoxedCharList().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("boxedCharList", array);
        }
        if (obj.getBoxedCharSet() != null) {
            array = new JsonArray();
            obj.getBoxedCharSet().forEach(item -> array.add((Object)Character.toString(item.charValue())));
            json.put("boxedCharSet", array);
        }
        if (obj.getBoxedCharValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedCharValueMap().forEach((key, value) -> map.put(key, (Object)Character.toString(value.charValue())));
            json.put("boxedCharValueMap", map);
        }
        if (obj.getBoxedDouble() != null) {
            json.put("boxedDouble", obj.getBoxedDouble());
        }
        if (obj.getBoxedDoubleList() != null) {
            array = new JsonArray();
            obj.getBoxedDoubleList().forEach(item -> array.add(item));
            json.put("boxedDoubleList", array);
        }
        if (obj.getBoxedDoubleSet() != null) {
            array = new JsonArray();
            obj.getBoxedDoubleSet().forEach(item -> array.add(item));
            json.put("boxedDoubleSet", array);
        }
        if (obj.getBoxedDoubleValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedDoubleValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedDoubleValueMap", map);
        }
        if (obj.getBoxedFloat() != null) {
            json.put("boxedFloat", obj.getBoxedFloat());
        }
        if (obj.getBoxedFloatList() != null) {
            array = new JsonArray();
            obj.getBoxedFloatList().forEach(item -> array.add(item));
            json.put("boxedFloatList", array);
        }
        if (obj.getBoxedFloatSet() != null) {
            array = new JsonArray();
            obj.getBoxedFloatSet().forEach(item -> array.add(item));
            json.put("boxedFloatSet", array);
        }
        if (obj.getBoxedFloatValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedFloatValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedFloatValueMap", map);
        }
        if (obj.getBoxedInt() != null) {
            json.put("boxedInt", obj.getBoxedInt());
        }
        if (obj.getBoxedIntList() != null) {
            array = new JsonArray();
            obj.getBoxedIntList().forEach(item -> array.add(item));
            json.put("boxedIntList", array);
        }
        if (obj.getBoxedIntSet() != null) {
            array = new JsonArray();
            obj.getBoxedIntSet().forEach(item -> array.add(item));
            json.put("boxedIntSet", array);
        }
        if (obj.getBoxedIntValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedIntValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedIntValueMap", map);
        }
        if (obj.getBoxedLong() != null) {
            json.put("boxedLong", obj.getBoxedLong());
        }
        if (obj.getBoxedLongList() != null) {
            array = new JsonArray();
            obj.getBoxedLongList().forEach(item -> array.add(item));
            json.put("boxedLongList", array);
        }
        if (obj.getBoxedLongSet() != null) {
            array = new JsonArray();
            obj.getBoxedLongSet().forEach(item -> array.add(item));
            json.put("boxedLongSet", array);
        }
        if (obj.getBoxedLongValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedLongValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedLongValueMap", map);
        }
        if (obj.getBoxedShort() != null) {
            json.put("boxedShort", obj.getBoxedShort());
        }
        if (obj.getBoxedShortList() != null) {
            array = new JsonArray();
            obj.getBoxedShortList().forEach(item -> array.add(item));
            json.put("boxedShortList", array);
        }
        if (obj.getBoxedShortSet() != null) {
            array = new JsonArray();
            obj.getBoxedShortSet().forEach(item -> array.add(item));
            json.put("boxedShortSet", array);
        }
        if (obj.getBoxedShortValueMap() != null) {
            map = new JsonObject();
            obj.getBoxedShortValueMap().forEach((key, value) -> map.put(key, value));
            json.put("boxedShortValueMap", map);
        }
        if (obj.getBuffer() != null) {
            json.put("buffer", JsonUtil.BASE64_ENCODER.encodeToString(obj.getBuffer().getBytes()));
        }
        if (obj.getBufferList() != null) {
            array = new JsonArray();
            obj.getBufferList().forEach(item -> array.add((Object)JsonUtil.BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("bufferList", array);
        }
        if (obj.getBufferMap() != null) {
            map = new JsonObject();
            obj.getBufferMap().forEach((key, value) -> map.put(key, (Object)JsonUtil.BASE64_ENCODER.encodeToString(value.getBytes())));
            json.put("bufferMap", map);
        }
        if (obj.getBufferSet() != null) {
            array = new JsonArray();
            obj.getBufferSet().forEach(item -> array.add((Object)JsonUtil.BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("bufferSet", array);
        }
        if (obj.getHttpMethod() != null) {
            json.put("httpMethod", obj.getHttpMethod().name());
        }
        if (obj.getHttpMethodList() != null) {
            array = new JsonArray();
            obj.getHttpMethodList().forEach(item -> array.add((Object)item.name()));
            json.put("httpMethodList", array);
        }
        if (obj.getHttpMethodMap() != null) {
            map = new JsonObject();
            obj.getHttpMethodMap().forEach((key, value) -> map.put(key, (Object)value.name()));
            json.put("httpMethodMap", map);
        }
        if (obj.getHttpMethodSet() != null) {
            array = new JsonArray();
            obj.getHttpMethodSet().forEach(item -> array.add((Object)item.name()));
            json.put("httpMethodSet", array);
        }
        if (obj.getJsonArray() != null) {
            json.put("jsonArray", obj.getJsonArray());
        }
        if (obj.getJsonArrayList() != null) {
            array = new JsonArray();
            obj.getJsonArrayList().forEach(item -> array.add(item));
            json.put("jsonArrayList", array);
        }
        if (obj.getJsonArrayMap() != null) {
            map = new JsonObject();
            obj.getJsonArrayMap().forEach((key, value) -> map.put(key, value));
            json.put("jsonArrayMap", map);
        }
        if (obj.getJsonArraySet() != null) {
            array = new JsonArray();
            obj.getJsonArraySet().forEach(item -> array.add(item));
            json.put("jsonArraySet", array);
        }
        if (obj.getJsonObject() != null) {
            json.put("jsonObject", obj.getJsonObject());
        }
        if (obj.getJsonObjectDataObject() != null) {
            json.put("jsonObjectDataObject", obj.getJsonObjectDataObject().toJson());
        }
        if (obj.getJsonObjectDataObjectList() != null) {
            array = new JsonArray();
            obj.getJsonObjectDataObjectList().forEach(item -> array.add((Object)item.toJson()));
            json.put("jsonObjectDataObjectList", array);
        }
        if (obj.getJsonObjectDataObjectMap() != null) {
            map = new JsonObject();
            obj.getJsonObjectDataObjectMap().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("jsonObjectDataObjectMap", map);
        }
        if (obj.getJsonObjectDataObjectSet() != null) {
            array = new JsonArray();
            obj.getJsonObjectDataObjectSet().forEach(item -> array.add((Object)item.toJson()));
            json.put("jsonObjectDataObjectSet", array);
        }
        if (obj.getJsonObjectList() != null) {
            array = new JsonArray();
            obj.getJsonObjectList().forEach(item -> array.add(item));
            json.put("jsonObjectList", array);
        }
        if (obj.getJsonObjectMap() != null) {
            map = new JsonObject();
            obj.getJsonObjectMap().forEach((key, value) -> map.put(key, value));
            json.put("jsonObjectMap", map);
        }
        if (obj.getJsonObjectSet() != null) {
            array = new JsonArray();
            obj.getJsonObjectSet().forEach(item -> array.add(item));
            json.put("jsonObjectSet", array);
        }
        if (obj.getKeyedBoxedBooleanValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedBooleanValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedBooleanValues", map);
        }
        if (obj.getKeyedBoxedByteValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedByteValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedByteValues", map);
        }
        if (obj.getKeyedBoxedCharValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedCharValues().forEach((key, value) -> map.put(key, (Object)Character.toString(value.charValue())));
            json.put("keyedBoxedCharValues", map);
        }
        if (obj.getKeyedBoxedDoubleValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedDoubleValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedDoubleValues", map);
        }
        if (obj.getKeyedBoxedFloatValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedFloatValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedFloatValues", map);
        }
        if (obj.getKeyedBoxedIntValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedIntValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedIntValues", map);
        }
        if (obj.getKeyedBoxedLongValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedLongValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedLongValues", map);
        }
        if (obj.getKeyedBoxedShortValues() != null) {
            map = new JsonObject();
            obj.getKeyedBoxedShortValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedBoxedShortValues", map);
        }
        if (obj.getKeyedBufferValues() != null) {
            map = new JsonObject();
            obj.getKeyedBufferValues().forEach((key, value) -> map.put(key, (Object)JsonUtil.BASE64_ENCODER.encodeToString(value.getBytes())));
            json.put("keyedBufferValues", map);
        }
        if (obj.getKeyedEnumValues() != null) {
            map = new JsonObject();
            obj.getKeyedEnumValues().forEach((key, value) -> map.put(key, (Object)value.name()));
            json.put("keyedEnumValues", map);
        }
        if (obj.getKeyedJsonArrayValues() != null) {
            map = new JsonObject();
            obj.getKeyedJsonArrayValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedJsonArrayValues", map);
        }
        if (obj.getKeyedJsonObjectDataObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedJsonObjectDataObjectValues().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("keyedJsonObjectDataObjectValues", map);
        }
        if (obj.getKeyedJsonObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedJsonObjectValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedJsonObjectValues", map);
        }
        if (obj.getKeyedMethodMappedValues() != null) {
            map = new JsonObject();
            obj.getKeyedMethodMappedValues().forEach((key, value) -> map.put(key, (Object)TestDataObject.serializeZonedDateTime(value)));
            json.put("keyedMethodMappedValues", map);
        }
        if (obj.getKeyedObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedObjectValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedObjectValues", map);
        }
        if (obj.getKeyedStringDataObjectValues() != null) {
            map = new JsonObject();
            obj.getKeyedStringDataObjectValues().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("keyedStringDataObjectValues", map);
        }
        if (obj.getKeyedStringValues() != null) {
            map = new JsonObject();
            obj.getKeyedStringValues().forEach((key, value) -> map.put(key, value));
            json.put("keyedStringValues", map);
        }
        if (obj.getMethodMapped() != null) {
            json.put("methodMapped", TestDataObject.serializeZonedDateTime(obj.getMethodMapped()));
        }
        if (obj.getMethodMappedList() != null) {
            array = new JsonArray();
            obj.getMethodMappedList().forEach(item -> array.add((Object)TestDataObject.serializeZonedDateTime(item)));
            json.put("methodMappedList", array);
        }
        if (obj.getMethodMappedMap() != null) {
            map = new JsonObject();
            obj.getMethodMappedMap().forEach((key, value) -> map.put(key, (Object)TestDataObject.serializeZonedDateTime(value)));
            json.put("methodMappedMap", map);
        }
        if (obj.getMethodMappedSet() != null) {
            array = new JsonArray();
            obj.getMethodMappedSet().forEach(item -> array.add((Object)TestDataObject.serializeZonedDateTime(item)));
            json.put("methodMappedSet", array);
        }
        if (obj.getObjectList() != null) {
            array = new JsonArray();
            obj.getObjectList().forEach(item -> array.add(item));
            json.put("objectList", array);
        }
        if (obj.getObjectMap() != null) {
            map = new JsonObject();
            obj.getObjectMap().forEach((key, value) -> map.put(key, value));
            json.put("objectMap", map);
        }
        if (obj.getObjectSet() != null) {
            array = new JsonArray();
            obj.getObjectSet().forEach(item -> array.add(item));
            json.put("objectSet", array);
        }
        json.put("primitiveBoolean", obj.isPrimitiveBoolean());
        json.put("primitiveByte", obj.getPrimitiveByte());
        json.put("primitiveChar", Character.toString(obj.getPrimitiveChar()));
        json.put("primitiveDouble", obj.getPrimitiveDouble());
        json.put("primitiveFloat", Float.valueOf(obj.getPrimitiveFloat()));
        json.put("primitiveInt", obj.getPrimitiveInt());
        json.put("primitiveLong", obj.getPrimitiveLong());
        json.put("primitiveShort", obj.getPrimitiveShort());
        if (obj.getString() != null) {
            json.put("string", obj.getString());
        }
        if (obj.getStringDataObject() != null) {
            json.put("stringDataObject", obj.getStringDataObject().toJson());
        }
        if (obj.getStringDataObjectList() != null) {
            array = new JsonArray();
            obj.getStringDataObjectList().forEach(item -> array.add((Object)item.toJson()));
            json.put("stringDataObjectList", array);
        }
        if (obj.getStringDataObjectMap() != null) {
            map = new JsonObject();
            obj.getStringDataObjectMap().forEach((key, value) -> map.put(key, (Object)value.toJson()));
            json.put("stringDataObjectMap", map);
        }
        if (obj.getStringDataObjectSet() != null) {
            array = new JsonArray();
            obj.getStringDataObjectSet().forEach(item -> array.add((Object)item.toJson()));
            json.put("stringDataObjectSet", array);
        }
        if (obj.getStringList() != null) {
            array = new JsonArray();
            obj.getStringList().forEach(item -> array.add(item));
            json.put("stringList", array);
        }
        if (obj.getStringSet() != null) {
            array = new JsonArray();
            obj.getStringSet().forEach(item -> array.add(item));
            json.put("stringSet", array);
        }
        if (obj.getStringValueMap() != null) {
            map = new JsonObject();
            obj.getStringValueMap().forEach((key, value) -> map.put(key, value));
            json.put("stringValueMap", map);
        }
    }
}

