/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.generator.gen2;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.annotations.VertxGen;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class TestGenerator
extends Generator<ClassModel> {
    public TestGenerator() {
        this.name = "testgen2";
        this.incremental = true;
        this.kinds = new HashSet<String>(Arrays.asList("class"));
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class);
    }

    public String filename(ClassModel model) {
        return "testgen2.incremental_class.java";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        StringBuilder sb = new StringBuilder();
        if (index == 0) {
            sb.append("package testgen2;\n\nimport java.util.*;\nimport java.util.concurrent.Callable;\n\npublic class incremental_class implements Callable<Set<String>> {\n  public Set<String> call() throws Exception {\n    Set<String> strings = new HashSet<>();\n");
        }
        sb.append("    strings.add(\"").append(model.getType().toString()).append("\");\n");
        if (index + 1 == size) {
            sb.append("    return strings;\n  }\n}\n");
        }
        return sb.toString();
    }
}

