/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.ModelBuilder;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class CodeTranslator {
    private final Trees trees;
    private final DeclaredType SystemType;
    private final Attr attr;
    private final TypeInfo.Factory factory;

    public CodeTranslator(ProcessingEnvironment processingEnv) {
        this.trees = Trees.instance(processingEnv);
        this.SystemType = (DeclaredType)processingEnv.getElementUtils().getTypeElement(System.class.getName()).asType();
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.attr = Attr.instance(context);
        this.factory = new TypeInfo.Factory(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
    }

    public String translate(ExecutableElement methodElt, Lang lang) {
        TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
        this.attributeClass(typeElt);
        TreePath path = this.trees.getPath(methodElt);
        ModelBuilder builder = new ModelBuilder(this.SystemType, this.factory, lang);
        CodeModel model = builder.build(path);
        CodeWriter writer = new CodeWriter(lang);
        model.render(writer);
        return writer.getBuffer().toString();
    }

    private void attributeClass(Element classElement) {
        assert (classElement.getKind() == ElementKind.CLASS);
        JCTree.JCClassDecl ct = (JCTree.JCClassDecl)this.trees.getTree(classElement);
        if (ct.sym != null && (ct.sym.flags_field & 0x10000000L) != 0L) {
            this.attr.attribClass(ct.pos(), ct.sym);
        }
    }
}

