/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.codetrans.Lang;

public class CodeWriter
implements Appendable {
    private final Lang lang;
    private int indent = 0;
    private boolean first = true;
    private StringBuilder buffer = new StringBuilder();

    public CodeWriter(Lang lang) {
        this.lang = lang;
    }

    public Lang getLang() {
        return this.lang;
    }

    public void indent() {
        this.indent += 2;
    }

    public void unindent() {
        if (this.indent < 2) {
            throw new IllegalStateException();
        }
        this.indent -= 2;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public CodeWriter append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CodeWriter append(CharSequence csq, int start, int end) {
        while (start < end) {
            this.append(csq.charAt(start++));
        }
        return this;
    }

    @Override
    public CodeWriter append(char c) {
        if (c == '\n') {
            this.first = true;
        } else if (this.first) {
            this.first = false;
            for (int i = 0; i < this.indent; ++i) {
                this.buffer.append(' ');
            }
        }
        this.buffer.append(c);
        return this;
    }
}

