/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.codetrans.ConvertingProcessor;
import io.vertx.codetrans.GroovyLang;
import io.vertx.codetrans.JavaScriptLang;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.Runner;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConversionRunner {
    public static void main(String[] args) throws Exception {
        Lang lang = new JavaScriptLang();
        switch (System.getProperty("lang")) {
            case "groovy": {
                lang = new GroovyLang();
                break;
            }
            case "js": {
                lang = new JavaScriptLang();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Map<String, String> result = ConvertingProcessor.convert(ConversionRunner.class.getClassLoader(), lang, "echo/EchoServer.java", "echo/EchoClient.java", "http/Client.java", "http/Server.java", "https/Client.java", "https/Server.java", "proxy/Proxy.java", "proxy/Server.java", "proxy/Client.java", "eventbus_pointtopoint/Sender.java", "eventbus_pointtopoint/Receiver.java", "eventbus_pubsub/Sender.java", "eventbus_pubsub/Receiver.java", "eventbusbridge/BridgeServer.java", "sendfile/SendFile.java", "route_match/RouteMatchServer.java", "simpleform/SimpleFormServer.java", "simpleformupload/SimpleFormUploadServer.java", "sockjs/SockJSExample.java", "ssl/Server.java", "ssl/Client.java", "upload/Client.java", "upload/Server.java", "websockets/WebSocketsServer.java", "websockets/WebSocketsClient.java");
        List<String> resources = Arrays.asList("server-keystore.jks", "route_match/index.html", "eventbusbridge/index.html", "eventbusbridge/vertxbus.js", "sendfile/index.html", "sendfile/page1.html", "sendfile/page2.html", "simpleform/index.html", "simpleformupload/index.html", "sockjs/index.html", "upload/upload.txt", "websockets/ws.html");
        for (String string : resources) {
            InputStream in = ConversionRunner.class.getClassLoader().getResourceAsStream(string);
            File dst = new File(string).getAbsoluteFile();
            dst.getParentFile().mkdirs();
            Files.copy(in, dst.toPath(), new CopyOption[0]);
        }
        for (Map.Entry entry : result.entrySet()) {
            File dst = new File((String)entry.getKey());
            dst.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(dst);
            Throwable throwable = null;
            try {
                writer.append((CharSequence)entry.getValue());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{new File(".").getAbsoluteFile().toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Runner.main(new String[0]);
    }
}

