/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.annotations.CodeTranslate;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class ConvertingProcessor
extends AbstractProcessor {
    private static final JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
    private static final Locale locale = Locale.getDefault();
    private static final Charset charset = Charset.forName("UTF-8");
    private Map<String, String> result = new HashMap<String, String>();
    private Lang lang;
    private CodeTranslator translator;

    public static Map<String, String> convert(ClassLoader loader, Lang lang, String ... sources) throws Exception {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager manager = javac.getStandardFileManager(diagnostics, locale, charset);
        ArrayList<File> files = new ArrayList<File>();
        for (String source : sources) {
            URL url = loader.getResource(source);
            if (url == null) {
                throw new Exception("Cannot resolve source " + source + "");
            }
            files.add(new File(url.toURI()));
        }
        Iterable<? extends JavaFileObject> fileObjects = manager.getJavaFileObjects(files.toArray(new File[files.size()]));
        StringWriter out = new StringWriter();
        JavaCompiler.CompilationTask task = javac.getTask(out, manager, diagnostics, Collections.emptyList(), Collections.emptyList(), fileObjects);
        task.setLocale(locale);
        ConvertingProcessor processor = new ConvertingProcessor(lang);
        task.setProcessors(Collections.singletonList(processor));
        if (task.call().booleanValue()) {
            return processor.getResult();
        }
        StringWriter message = new StringWriter();
        PrintWriter writer = new PrintWriter(message);
        writer.append("Compilation of ").append(Arrays.toString(sources)).println(" failed:");
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            writer.append(diagnostic.getMessage(locale));
        }
        writer.println("console:");
        writer.append(out.getBuffer());
        throw new Exception(message.toString());
    }

    public ConvertingProcessor(Lang lang) {
        this.lang = lang;
    }

    public Map<String, String> getResult() {
        return this.result;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(CodeTranslate.class.getName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.translator = new CodeTranslator(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(CodeTranslate.class)) {
            ExecutableElement methodElt = (ExecutableElement)element;
            TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
            String translation = this.translator.translate(methodElt, this.lang);
            this.result.put(typeElt.toString().replace('.', '/') + "_" + methodElt.getSimpleName() + '.' + this.lang.getExtension(), translation);
        }
        return false;
    }
}

