/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExpressionModel
extends CodeModel {
    public ExpressionModel onMemberSelect(String identifier) {
        if (identifier.equals("equals")) {
            return ExpressionModel.forMethodInvocation(args -> {
                if (args.size() == 1) {
                    return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderEquals(this, (ExpressionModel)args.get(0), (CodeWriter)renderer));
                }
                throw new UnsupportedOperationException("Not yet implemented");
            });
        }
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderMemberSelect(this, identifier, (CodeWriter)renderer));
    }

    public ExpressionModel onNew(List<ExpressionModel> arguments) {
        throw new UnsupportedOperationException("Not implemented with arguments " + arguments);
    }

    public ExpressionModel onMethodInvocation(List<ExpressionModel> arguments) {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderMethodInvocation(this, arguments, (CodeWriter)renderer));
    }

    public ExpressionModel onPostFixIncrement() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderPostfixIncrement(this, (CodeWriter)renderer));
    }

    public ExpressionModel onPrefixIncrement() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderPrefixIncrement(this, (CodeWriter)renderer));
    }

    public ExpressionModel onPostFixDecrement() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderPostfixDecrement(this, (CodeWriter)renderer));
    }

    public ExpressionModel onPrefixDecrement() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderPrefixDecrement(this, (CodeWriter)renderer));
    }

    public ExpressionModel onLogicalComplement() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderLogicalComplement(this, (CodeWriter)renderer));
    }

    public ExpressionModel unaryMinus() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderUnaryMinus(this, (CodeWriter)renderer));
    }

    public ExpressionModel unaryPlus() {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderUnaryPlus(this, (CodeWriter)renderer));
    }

    public static ExpressionModel forNew(final Function<List<ExpressionModel>, ExpressionModel> f) {
        return new ExpressionModel(){

            @Override
            public ExpressionModel onNew(List<ExpressionModel> arguments) {
                return (ExpressionModel)f.apply(arguments);
            }
        };
    }

    public static ExpressionModel forMemberSelect(final String expected, final Supplier<ExpressionModel> f) {
        return new ExpressionModel(){

            @Override
            public ExpressionModel onMemberSelect(String identifier) {
                if (expected.equals(identifier)) {
                    return (ExpressionModel)f.get();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ExpressionModel forMemberSelect(final Function<String, ExpressionModel> f) {
        return new ExpressionModel(){

            @Override
            public ExpressionModel onMemberSelect(String identifier) {
                return (ExpressionModel)f.apply(identifier);
            }
        };
    }

    public static ExpressionModel forParenthesized(ExpressionModel expression) {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderParenthesized(expression, (CodeWriter)renderer));
    }

    public static ExpressionModel forConditionalExpression(ExpressionModel condition, ExpressionModel trueExpression, ExpressionModel falseExpression) {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderConditionalExpression(condition, trueExpression, falseExpression, (CodeWriter)renderer));
    }

    public static ExpressionModel forAssign(ExpressionModel variable, ExpressionModel expression) {
        return ExpressionModel.render((CodeWriter renderer) -> renderer.getLang().renderAssign(variable, expression, (CodeWriter)renderer));
    }

    public static ExpressionModel forMethodInvocation(final Function<List<ExpressionModel>, ExpressionModel> f) {
        return new ExpressionModel(){

            @Override
            public ExpressionModel onMethodInvocation(List<ExpressionModel> arguments) {
                return (ExpressionModel)f.apply(arguments);
            }
        };
    }

    public static ExpressionModel render(final Consumer<CodeWriter> c) {
        return new ExpressionModel(){

            @Override
            public void render(CodeWriter writer) {
                c.accept(writer);
            }
        };
    }

    public static ExpressionModel render(final Supplier<String> f) {
        return new ExpressionModel(){

            @Override
            public void render(CodeWriter writer) {
                writer.append((CharSequence)f.get());
            }
        };
    }

    public static ExpressionModel render(final String s) {
        return new ExpressionModel(){

            @Override
            public void render(CodeWriter writer) {
                writer.append(s);
            }
        };
    }
}

