/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.ExpressionModel;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.JsonArrayModel;
import io.vertx.codetrans.JsonObjectModel;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.Member;
import io.vertx.codetrans.OptionsModel;
import io.vertx.codetrans.StatementModel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

public class GroovyLang
implements Lang {
    @Override
    public Callable<?> compile(ClassLoader loader, String path) throws Exception {
        InputStream resource = loader.getResourceAsStream(path + ".groovy");
        if (resource != null) {
            try (InputStreamReader reader = new InputStreamReader(resource);){
                GroovyClassLoader compiler = new GroovyClassLoader(loader);
                Class clazz = compiler.parseClass(new GroovyCodeSource((Reader)reader, path.replace('/', '.'), "/"));
                Callable<Object> callable = () -> {
                    Script script = (Script)clazz.newInstance();
                    return script.run();
                };
                return callable;
            }
        }
        throw new Exception("Could not compile " + path);
    }

    @Override
    public void renderBlock(List<StatementModel> statements, CodeWriter writer) {
        if (writer instanceof GroovyRenderer) {
            Lang.super.renderBlock(statements, writer);
        } else {
            GroovyRenderer langRenderer = new GroovyRenderer(this);
            Lang.super.renderBlock(statements, langRenderer);
            for (TypeInfo.Class importedType : langRenderer.imports) {
                writer.append("import ").append(importedType.getName().replace("io.vertx.", "io.vertx.groovy.")).append('\n');
            }
            writer.append(langRenderer.getBuffer());
        }
    }

    @Override
    public String getExtension() {
        return "groovy";
    }

    private static GStringLiteralModel gstring(final Consumer<CodeWriter> characters) {
        return new GStringLiteralModel(){

            @Override
            protected void renderCharacters(CodeWriter writer) {
                characters.accept(writer);
            }
        };
    }

    @Override
    public ExpressionModel stringLiteral(String value) {
        return GroovyLang.gstring(renderer -> Lang.super.renderCharacters(value, (CodeWriter)renderer));
    }

    @Override
    public ExpressionModel combine(ExpressionModel left, String op, ExpressionModel right) {
        if (op.equals("+")) {
            if (left instanceof GStringLiteralModel) {
                GStringLiteralModel gleft = (GStringLiteralModel)left;
                if (right instanceof GStringLiteralModel) {
                    GStringLiteralModel gright = (GStringLiteralModel)right;
                    return GroovyLang.gstring(renderer -> {
                        gleft.renderCharacters((CodeWriter)renderer);
                        gright.renderCharacters((CodeWriter)renderer);
                    });
                }
                return GroovyLang.gstring(renderer -> {
                    gleft.renderCharacters((CodeWriter)renderer);
                    renderer.append("${");
                    right.render((CodeWriter)renderer);
                    renderer.append("}");
                });
            }
            if (right instanceof GStringLiteralModel) {
                GStringLiteralModel gright = (GStringLiteralModel)right;
                return GroovyLang.gstring(renderer -> {
                    renderer.append("${");
                    left.render((CodeWriter)renderer);
                    renderer.append("}");
                    gright.renderCharacters((CodeWriter)renderer);
                });
            }
        }
        return Lang.super.combine(left, op, right);
    }

    @Override
    public ExpressionModel classExpression(TypeInfo.Class type) {
        return ExpressionModel.render(type.getName());
    }

    @Override
    public ExpressionModel lambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        return ExpressionModel.render(renderer -> {
            renderer.append("{");
            for (int i = 0; i < parameterNames.size(); ++i) {
                if (i == 0) {
                    renderer.append(" ");
                } else {
                    renderer.append(", ");
                }
                renderer.append((CharSequence)parameterNames.get(i));
            }
            renderer.append(" ->\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public ExpressionModel asyncResult(String identifier) {
        return ExpressionModel.render(renderer -> renderer.append(identifier));
    }

    @Override
    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind bodyKind, String resultName, CodeModel body) {
        return this.lambda(null, null, Arrays.asList(resultName), body);
    }

    @Override
    public ExpressionModel staticFactory(TypeInfo.Class type, String methodName) {
        return ExpressionModel.render(renderer -> {
            GroovyRenderer jsRenderer = (GroovyRenderer)renderer;
            jsRenderer.imports.add(type);
            renderer.append(type.getSimpleName()).append('.').append(methodName);
        });
    }

    @Override
    public StatementModel variable(TypeInfo type, String name, ExpressionModel initializer) {
        return StatementModel.render(renderer -> {
            renderer.append("def ").append(name);
            if (initializer != null) {
                renderer.append(" = ");
                initializer.render((CodeWriter)renderer);
            }
        });
    }

    @Override
    public StatementModel enhancedForLoop(String variableName, ExpressionModel expression, StatementModel body) {
        return StatementModel.render(renderer -> {
            expression.render((CodeWriter)renderer);
            renderer.append(".each { ").append(variableName).append(" ->\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public StatementModel forLoop(StatementModel initializer, ExpressionModel condition, ExpressionModel update, StatementModel body) {
        return StatementModel.render(renderer -> {
            renderer.append("for (");
            initializer.render((CodeWriter)renderer);
            renderer.append(';');
            condition.render((CodeWriter)renderer);
            renderer.append(';');
            update.render((CodeWriter)renderer);
            renderer.append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public void renderOptions(OptionsModel options, CodeWriter writer) {
        this.renderJsonObject(options.getMembers(), writer, false);
    }

    @Override
    public void renderJsonObject(JsonObjectModel jsonObject, CodeWriter writer) {
        this.renderJsonObject(jsonObject.getMembers(), writer, true);
    }

    @Override
    public void renderJsonArray(JsonArrayModel jsonArray, CodeWriter writer) {
        this.renderJsonArray(jsonArray.getValues(), writer);
    }

    private void renderJsonObject(Iterable<Member> members, CodeWriter writer, boolean unquote) {
        Iterator<Member> iterator = members.iterator();
        if (iterator.hasNext()) {
            writer.append("[");
            while (iterator.hasNext()) {
                Member member = iterator.next();
                String name = member.name.render(writer.getLang());
                if (unquote) {
                    name = Helper.unwrapQuotedString(name);
                }
                writer.append(name);
                writer.append(":");
                if (member instanceof Member.Single) {
                    ((Member.Single)member).value.render(writer);
                } else {
                    this.renderJsonArray(((Member.Array)member).values, writer);
                }
                if (!iterator.hasNext()) continue;
                writer.append(", ");
            }
            writer.append("]");
        } else {
            writer.append("[:]");
        }
    }

    private void renderJsonArray(List<ExpressionModel> values, CodeWriter writer) {
        writer.append('[');
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            values.get(i).render(writer);
        }
        writer.append(']');
    }

    @Override
    public ExpressionModel console(ExpressionModel expression) {
        return ExpressionModel.render(renderer -> {
            renderer.append("println(");
            expression.render((CodeWriter)renderer);
            renderer.append(")");
        });
    }

    static abstract class GStringLiteralModel
    extends ExpressionModel {
        GStringLiteralModel() {
        }

        @Override
        public final void render(CodeWriter writer) {
            writer.append('\"');
            this.renderCharacters(writer);
            writer.append('\"');
        }

        protected abstract void renderCharacters(CodeWriter var1);
    }

    static class GroovyRenderer
    extends CodeWriter {
        LinkedHashSet<TypeInfo.Class> imports = new LinkedHashSet();

        GroovyRenderer(Lang lang) {
            super(lang);
        }
    }
}

