/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.ExpressionModel;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.JsonArrayModel;
import io.vertx.codetrans.JsonObjectModel;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.Member;
import io.vertx.codetrans.OptionsModel;
import io.vertx.codetrans.StatementModel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavaScriptLang
implements Lang {
    @Override
    public void renderBinary(ExpressionModel left, String op, ExpressionModel right, CodeWriter writer) {
        switch (op) {
            case "==": {
                op = "===";
                break;
            }
            case "!=": {
                op = "!==";
            }
        }
        Lang.super.renderBinary(left, op, right, writer);
    }

    @Override
    public Callable<?> compile(ClassLoader loader, String path) throws Exception {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("nashorn");
        engine.put("__engine", engine);
        InputStream require = this.getClass().getClassLoader().getResourceAsStream("vertx-js/util/require.js");
        if (require == null) {
            throw new Exception("Not require.js");
        }
        engine.put("javax.script.filename", "require.js");
        engine.eval(new InputStreamReader(require));
        engine.eval("var console = require('vertx-js/util/console')");
        InputStream source = loader.getResourceAsStream(path + ".js");
        if (source == null) {
            throw new Exception("Could not find " + path + ".js");
        }
        return () -> engine.eval(new InputStreamReader(source));
    }

    @Override
    public void renderBlock(List<StatementModel> statements, CodeWriter writer) {
        if (writer instanceof JavaScriptRenderer) {
            Lang.super.renderBlock(statements, writer);
        } else {
            JavaScriptRenderer langRenderer = new JavaScriptRenderer(this);
            Lang.super.renderBlock(statements, langRenderer);
            for (TypeInfo.Class module : langRenderer.modules) {
                writer.append("var ").append(module.getSimpleName()).append(" = require(\"").append(module.getModuleName()).append("-js/").append(io.vertx.codegen.Helper.convertCamelCaseToUnderscores((String)module.getSimpleName())).append("\");\n");
            }
            writer.append(langRenderer.getBuffer());
        }
    }

    @Override
    public String getExtension() {
        return "js";
    }

    @Override
    public ExpressionModel classExpression(TypeInfo.Class type) {
        return ExpressionModel.render("Java.type(\"" + type.getName() + "\")");
    }

    @Override
    public ExpressionModel console(ExpressionModel expression) {
        return ExpressionModel.render(renderer -> {
            renderer.append("console.log(");
            expression.render((CodeWriter)renderer);
            renderer.append(")");
        });
    }

    @Override
    public void renderOptions(OptionsModel options, CodeWriter writer) {
        this.renderJsonObject(options.getMembers(), writer, false);
    }

    @Override
    public void renderJsonObject(JsonObjectModel jsonObject, CodeWriter writer) {
        this.renderJsonObject(jsonObject.getMembers(), writer, true);
    }

    @Override
    public void renderJsonArray(JsonArrayModel jsonArray, CodeWriter writer) {
        this.renderJsonArray(jsonArray.getValues(), writer);
    }

    private void renderJsonObject(Iterable<Member> members, CodeWriter writer, boolean unquote) {
        writer.append("{");
        Iterator<Member> iterator = members.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            String name = member.name.render(writer.getLang());
            if (unquote) {
                name = Helper.unwrapQuotedString(name);
            }
            writer.append("\"").append(name).append("\" : ");
            if (member instanceof Member.Single) {
                ((Member.Single)member).value.render(writer);
            } else {
                this.renderJsonArray(((Member.Array)member).values, writer);
            }
            if (!iterator.hasNext()) continue;
            writer.append(", ");
        }
        writer.append("}");
    }

    private void renderJsonArray(List<ExpressionModel> values, CodeWriter writer) {
        writer.append('[');
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            values.get(i).render(writer);
        }
        writer.append(']');
    }

    @Override
    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind bodyKind, String resultName, CodeModel body) {
        return this.lambda(null, null, Arrays.asList(resultName, resultName + "_err"), body);
    }

    @Override
    public ExpressionModel lambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        return ExpressionModel.render(renderer -> {
            renderer.append("function (");
            for (int i = 0; i < parameterNames.size(); ++i) {
                if (i > 0) {
                    renderer.append(", ");
                }
                renderer.append((CharSequence)parameterNames.get(i));
            }
            renderer.append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public ExpressionModel staticFactory(TypeInfo.Class type, String methodName) {
        return ExpressionModel.render(renderer -> {
            JavaScriptRenderer jsRenderer = (JavaScriptRenderer)renderer;
            jsRenderer.modules.add(type);
            renderer.append(type.getSimpleName()).append('.').append(methodName);
        });
    }

    @Override
    public StatementModel variable(TypeInfo type, String name, ExpressionModel initializer) {
        return StatementModel.render(renderer -> {
            renderer.append("var ").append(name);
            if (initializer != null) {
                renderer.append(" = ");
                initializer.render((CodeWriter)renderer);
            }
        });
    }

    @Override
    public StatementModel enhancedForLoop(String variableName, ExpressionModel expression, StatementModel body) {
        return StatementModel.render(renderer -> {
            renderer.append("Array.prototype.forEach.call(");
            expression.render((CodeWriter)renderer);
            renderer.append(", function(").append(variableName).append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("})");
        });
    }

    @Override
    public StatementModel forLoop(StatementModel initializer, ExpressionModel condition, ExpressionModel update, StatementModel body) {
        return StatementModel.render(renderer -> {
            renderer.append("for (");
            initializer.render((CodeWriter)renderer);
            renderer.append(';');
            condition.render((CodeWriter)renderer);
            renderer.append(';');
            update.render((CodeWriter)renderer);
            renderer.append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public ExpressionModel asyncResult(String identifier) {
        return ExpressionModel.forMemberSelect(member -> {
            switch (member) {
                case "succeeded": {
                    return ExpressionModel.forMethodInvocation(args -> ExpressionModel.render("(" + identifier + " != null)"));
                }
                case "result": {
                    return ExpressionModel.forMethodInvocation(args -> ExpressionModel.render(identifier));
                }
                case "cause": {
                    return ExpressionModel.forMethodInvocation(args -> ExpressionModel.render(identifier + "_err"));
                }
                case "failed": {
                    return ExpressionModel.forMethodInvocation(args -> ExpressionModel.render("(" + identifier + " == null)"));
                }
            }
            throw new UnsupportedOperationException("Not implemented");
        });
    }

    static class JavaScriptRenderer
    extends CodeWriter {
        LinkedHashSet<TypeInfo.Class> modules = new LinkedHashSet();

        JavaScriptRenderer(Lang lang) {
            super(lang);
        }
    }
}

