/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.ExpressionModel;
import io.vertx.codetrans.JsonArrayModel;
import io.vertx.codetrans.JsonObjectModel;
import io.vertx.codetrans.OptionsModel;
import io.vertx.codetrans.StatementModel;
import java.util.List;
import java.util.concurrent.Callable;

public interface Lang {
    public Callable<?> compile(ClassLoader var1, String var2) throws Exception;

    default public void renderIfThenElse(ExpressionModel condition, StatementModel thenBody, StatementModel elseBody, CodeWriter writer) {
        writer.append("if ");
        condition.render(writer);
        writer.append(" {\n");
        writer.indent();
        thenBody.render(writer);
        writer.unindent();
        writer.append("}");
        if (elseBody != null) {
            writer.append(" else {\n");
            writer.indent();
            elseBody.render(writer);
            writer.unindent();
            writer.append("}");
        }
    }

    default public void renderParenthesized(ExpressionModel expression, CodeWriter writer) {
        writer.append('(');
        expression.render(writer);
        writer.append(')');
    }

    default public void renderEquals(ExpressionModel expression, ExpressionModel arg, CodeWriter writer) {
        expression.render(writer);
        writer.append(" == ");
        arg.render(writer);
    }

    default public void renderConditionalExpression(ExpressionModel condition, ExpressionModel trueExpression, ExpressionModel falseExpression, CodeWriter writer) {
        condition.render(writer);
        writer.append(" ? ");
        trueExpression.render(writer);
        writer.append(" : ");
        falseExpression.render(writer);
    }

    default public void renderAssign(ExpressionModel variable, ExpressionModel expression, CodeWriter writer) {
        variable.render(writer);
        writer.append(" = ");
        expression.render(writer);
    }

    default public void renderBlock(List<StatementModel> statements, CodeWriter writer) {
        statements.forEach(statement -> {
            statement.render(writer);
            writer.append(";\n");
        });
    }

    default public void renderMemberSelect(ExpressionModel expression, String identifier, CodeWriter writer) {
        expression.render(writer);
        writer.append('.').append(identifier);
    }

    default public void renderMethodInvocation(ExpressionModel expression, List<ExpressionModel> arguments, CodeWriter writer) {
        expression.render(writer);
        writer.append('(');
        for (int i = 0; i < arguments.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            arguments.get(i).render(writer);
        }
        writer.append(')');
    }

    default public void renderBinary(ExpressionModel left, String op, ExpressionModel right, CodeWriter writer) {
        left.render(writer);
        writer.append(" ").append(op).append(" ");
        right.render(writer);
    }

    default public void renderCharacters(String value, CodeWriter writer) {
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': {
                    writer.append("\\n");
                    continue block5;
                }
                case '\"': {
                    writer.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    writer.append("\\\\");
                    continue block5;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    default public void renderNullLiteral(CodeWriter writer) {
        writer.append("null");
    }

    default public void renderStringLiteral(String value, CodeWriter writer) {
        writer.append('\"');
        this.renderCharacters(value, writer);
        writer.append('\"');
    }

    default public void renderCharLiteral(char value, CodeWriter writer) {
        writer.append('\'');
        this.renderCharacters(Character.toString(value), writer);
        writer.append('\'');
    }

    default public void renderBooleanLiteral(String value, CodeWriter writer) {
        writer.append(value);
    }

    default public void renderIntegerLiteral(String value, CodeWriter writer) {
        writer.append(value);
    }

    default public void renderPostfixIncrement(ExpressionModel expression, CodeWriter writer) {
        expression.render(writer);
        writer.append("++");
    }

    default public void renderPrefixIncrement(ExpressionModel expression, CodeWriter writer) {
        writer.append("++");
        expression.render(writer);
    }

    default public void renderPostfixDecrement(ExpressionModel expression, CodeWriter writer) {
        expression.render(writer);
        writer.append("--");
    }

    default public void renderPrefixDecrement(ExpressionModel expression, CodeWriter writer) {
        writer.append("--");
        expression.render(writer);
    }

    default public void renderLogicalComplement(ExpressionModel expression, CodeWriter writer) {
        writer.append("!");
        expression.render(writer);
    }

    default public void renderUnaryMinus(ExpressionModel expression, CodeWriter writer) {
        writer.append("-");
        expression.render(writer);
    }

    default public void renderUnaryPlus(ExpressionModel expression, CodeWriter writer) {
        writer.append("+");
        expression.render(writer);
    }

    public String getExtension();

    public void renderJsonObject(JsonObjectModel var1, CodeWriter var2);

    public void renderJsonArray(JsonArrayModel var1, CodeWriter var2);

    public void renderOptions(OptionsModel var1, CodeWriter var2);

    default public ExpressionModel nullLiteral() {
        return ExpressionModel.render(renderer -> renderer.getLang().renderNullLiteral((CodeWriter)renderer));
    }

    default public ExpressionModel stringLiteral(String value) {
        return ExpressionModel.render(renderer -> renderer.getLang().renderStringLiteral(value, (CodeWriter)renderer));
    }

    default public ExpressionModel combine(ExpressionModel left, String op, ExpressionModel right) {
        return ExpressionModel.render(renderer -> renderer.getLang().renderBinary(left, op, right, (CodeWriter)renderer));
    }

    public ExpressionModel classExpression(TypeInfo.Class var1);

    public ExpressionModel lambda(LambdaExpressionTree.BodyKind var1, List<TypeInfo> var2, List<String> var3, CodeModel var4);

    public ExpressionModel asyncResult(String var1);

    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind var1, String var2, CodeModel var3);

    public ExpressionModel staticFactory(TypeInfo.Class var1, String var2);

    public StatementModel variable(TypeInfo var1, String var2, ExpressionModel var3);

    public StatementModel enhancedForLoop(String var1, ExpressionModel var2, StatementModel var3);

    public StatementModel forLoop(StatementModel var1, ExpressionModel var2, ExpressionModel var3, StatementModel var4);

    public ExpressionModel console(ExpressionModel var1);
}

