/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.ExpressionModel;
import io.vertx.codetrans.Member;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OptionsModel
extends ExpressionModel {
    private final TypeInfo.Class type;
    private final Map<String, Member> members;

    public static ExpressionModel create(TypeInfo.Class type) {
        return OptionsModel.forNew(args -> new OptionsModel(type));
    }

    private OptionsModel(TypeInfo.Class type) {
        this(type, Collections.emptyMap());
    }

    private OptionsModel(TypeInfo.Class type, Map<String, Member> members) {
        this.type = type;
        this.members = members;
    }

    public TypeInfo.Class getType() {
        return this.type;
    }

    public Iterable<Member> getMembers() {
        return this.members.values();
    }

    @Override
    public ExpressionModel onMemberSelect(String identifier) {
        Function<String, Member> memberFactory;
        String name;
        if (identifier.length() > 3 && identifier.startsWith("set")) {
            name = Character.toLowerCase(identifier.charAt(3)) + identifier.substring(4);
            memberFactory = $ -> new Member.Single(OptionsModel.render(name));
        } else if (identifier.length() > 3 && identifier.startsWith("add")) {
            name = Character.toLowerCase(identifier.charAt(3)) + identifier.substring(4) + "s";
            memberFactory = $ -> new Member.Array(OptionsModel.render(name));
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
        return new ExpressionModel(){

            @Override
            public ExpressionModel onMethodInvocation(List<ExpressionModel> arguments) {
                if (arguments.size() == 1) {
                    LinkedHashMap<String, Member> copy = new LinkedHashMap<String, Member>(OptionsModel.this.members);
                    ExpressionModel value = arguments.get(0);
                    Member member = (Member)copy.computeIfAbsent(name, memberFactory);
                    member.append(value);
                    copy.put(name, member);
                    return new OptionsModel(OptionsModel.this.type, copy);
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    @Override
    public void render(CodeWriter writer) {
        writer.getLang().renderOptions(this, writer);
    }
}

