/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;

public class Runner {
    private static final String LANG = System.getProperty("lang", "groovy");
    private static Vertx vertx = Vertx.vertx();
    private static BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws Exception {
        ArrayList<Method> examples = new ArrayList<Method>();
        for (Method m : Runner.class.getDeclaredMethods()) {
            int mods = m.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || m.getParameterTypes().length != 0) continue;
            examples.add(m);
        }
        examples.sort((m1, m2) -> m1.getName().compareTo(m2.getName()));
        System.out.println("##########################\n# Vert.x examples runner #\n##########################\n");
        while (true) {
            Method example;
            block9: {
                if (args.length > 0 && args[0] != null) {
                    example = null;
                    for (Method m : examples) {
                        if (!m.getName().equals(args[0].trim())) continue;
                        example = m;
                    }
                    args = new String[]{};
                } else {
                    System.out.println("Choose an example:");
                    int index = 1;
                    for (Method m : examples) {
                        System.out.println(index++ + ":" + m.getName());
                    }
                    System.out.print("> ");
                    String s = reader.readLine();
                    try {
                        index = Integer.parseInt(s) - 1;
                        if (index >= 0 && index < examples.size()) {
                            example = (Method)examples.get(index);
                            break block9;
                        }
                        System.out.println("Invalid example <" + s + ">");
                    }
                    catch (NumberFormatException ignore) {
                        System.out.println("Invalid example <" + s + ">");
                    }
                    continue;
                }
            }
            Runner.run(example);
        }
    }

    private static void run(Method m) throws Exception {
        m.invoke(null, new Object[0]);
    }

    public static void echo() {
        Runner.deployInLang("echo/EchoServer", "echo/EchoClient");
    }

    public static void eventbus_pointtopoint() {
        Runner.deployInLang("eventbus_pointtopoint/Receiver", "eventbus_pointtopoint/Sender");
    }

    public static void eventbus_pubsub() {
        Runner.deployInLang("eventbus_pubsub/Receiver", "eventbus_pubsub/Sender");
    }

    public static void eventbusbridge() {
        Runner.deployInLang("eventbusbridge/BridgeServer");
    }

    public static void fanout() {
        Runner.deployInLang("fanout/FanoutServer");
    }

    public static void http() {
        Runner.deployInLang("http/Server", "http/Client");
    }

    public static void https() {
        Runner.deployInLang("https/Server", "https/Client");
    }

    public static void proxy() {
        Runner.deployInLang("proxy/Server", "proxy/Proxy", "proxy/Client");
    }

    public static void route_matcher() {
        Runner.deployInLang("route_match/RouteMatchServer");
    }

    public static void sendfile() {
        Runner.deployInLang("sendfile/SendFile");
    }

    public static void simpleform() {
        Runner.deployInLang("simpleform/SimpleFormServer");
    }

    public static void simpleformupload() {
        Runner.deployInLang("simpleformupload/SimpleFormUploadServer");
    }

    public static void sockjs() {
        Runner.deployInLang("sockjs/SockJSExample");
    }

    public static void ssl() {
        Runner.deployInLang("ssl/Server", "ssl/Client");
    }

    public static void upload() {
        Runner.deployInLang("upload/Server", "upload/Client");
    }

    public static void websockets() {
        Runner.deployInLang("websockets/WebSocketsServer", "websockets/WebSocketsClient");
    }

    private static void deployInLang(String ... verticles) {
        verticles = (String[])verticles.clone();
        for (int i = 0; i < verticles.length; ++i) {
            verticles[i] = LANG + ':' + verticles[i] + '.' + LANG;
        }
        Runner.deploy(verticles);
    }

    public static void deploy(String ... verticles) {
        AsyncResult result;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Runner.deploy(Arrays.asList(verticles), new String[0], (Handler<AsyncResult<String[]>>)((Handler)queue::add));
        try {
            result = (AsyncResult)queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (result.succeeded()) {
            System.out.println("Press a key after run...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            CountDownLatch done = new CountDownLatch(1);
            Runner.undeploy((String[])result.result(), (Handler<Void>)((Handler)d -> done.countDown()));
            try {
                done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        System.out.println("Failed to deploy:");
        result.cause().printStackTrace();
    }

    private static void deploy(List<String> verticles, String[] previousDepl, Handler<AsyncResult<String[]>> resultHandler) {
        if (verticles.size() > 0) {
            String verticle = verticles.get(0);
            vertx.deployVerticle(verticle, result -> {
                if (result.succeeded()) {
                    System.out.println("Deployed: " + verticle + " as " + (String)result.result());
                    String[] nextDepl = Arrays.copyOf(previousDepl, previousDepl.length + 1);
                    nextDepl[stringArray.length] = (String)result.result();
                    Runner.deploy(verticles.subList(1, verticles.size()), nextDepl, resultHandler);
                } else {
                    Runner.undeploy(previousDepl, (Handler<Void>)((Handler)done -> resultHandler.handle((Object)Future.failedFuture((Throwable)result.cause()))));
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture((Object)previousDepl));
        }
    }

    private static void undeploy(String[] deployments, Handler<Void> doneHandler) {
        if (deployments.length == 0) {
            doneHandler.handle(null);
        } else {
            String[] next = Arrays.copyOf(deployments, deployments.length - 1);
            vertx.undeployVerticle(deployments[deployments.length - 1], result -> Runner.undeploy(next, doneHandler));
        }
    }
}

