/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.BlockModel;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.FragmentParser;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.BinaryExpressionModel;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.statement.ConditionalBlockModel;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Iterator;
import java.util.List;

public abstract class CodeWriter
implements Appendable {
    protected final CodeBuilder builder;
    private int indent = 0;
    private boolean first = true;
    private StringBuilder buffer = new StringBuilder();

    public CodeWriter(CodeBuilder builder) {
        this.builder = builder;
    }

    public CodeBuilder getBuilder() {
        return this.builder;
    }

    public CodeWriter indent() {
        this.indent += 2;
        return this;
    }

    public CodeWriter unindent() {
        if (this.indent < 2) {
            throw new IllegalStateException();
        }
        this.indent -= 2;
        return this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public CodeWriter append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CodeWriter append(CharSequence csq, int start, int end) {
        while (start < end) {
            this.append(csq.charAt(start++));
        }
        return this;
    }

    @Override
    public CodeWriter append(char c) {
        if (c == '\n') {
            this.first = true;
        } else if (this.first) {
            this.first = false;
            for (int i = 0; i < this.indent; ++i) {
                this.buffer.append(' ');
            }
        }
        this.buffer.append(c);
        return this;
    }

    public void renderChars(String value) {
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    this.append("\\b");
                    continue block9;
                }
                case '\f': {
                    this.append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.append("\\n");
                    continue block9;
                }
                case '\t': {
                    this.append("\\t");
                    continue block9;
                }
                case '\r': {
                    this.append("\\r");
                    continue block9;
                }
                case '\"': {
                    this.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String s = Integer.toHexString(c).toUpperCase();
                        while (s.length() < 4) {
                            s = "0" + s;
                        }
                        this.append("\\u").append(s);
                        continue block9;
                    }
                    this.append(c);
                }
            }
        }
    }

    public void renderConditionals(List<ConditionalBlockModel> conditionals, StatementModel otherwise) {
        for (int i = 0; i < conditionals.size(); ++i) {
            ConditionalBlockModel conditional = conditionals.get(i);
            this.append(i == 0 ? "if " : " else if ");
            conditional.getCondition().render(this);
            this.append(" {\n");
            this.indent();
            conditional.getBody().render(this);
            this.unindent();
            this.append("}");
        }
        if (otherwise != null) {
            this.append(" else {\n");
            this.indent();
            otherwise.render(this);
            this.unindent();
            this.append("}");
        }
    }

    public void renderParenthesized(ExpressionModel expression) {
        this.append('(');
        expression.render(this);
        this.append(')');
    }

    public void renderEquals(ExpressionModel expression, ExpressionModel arg) {
        expression.render(this);
        this.append(" == ");
        arg.render(this);
    }

    public void renderConditionalExpression(ExpressionModel condition, ExpressionModel trueExpression, ExpressionModel falseExpression) {
        condition.render(this);
        this.append(" ? ");
        trueExpression.render(this);
        this.append(" : ");
        falseExpression.render(this);
    }

    public void renderAssign(ExpressionModel variable, ExpressionModel expression) {
        variable.render(this);
        this.append(" = ");
        expression.render(this);
    }

    public void renderIdentifier(String name, VariableScope scope) {
        this.append(name);
    }

    public abstract void renderStatement(StatementModel var1);

    public void renderBlock(BlockModel block) {
        block.render(this);
    }

    public abstract void renderTryCatch(StatementModel var1, StatementModel var2);

    public void renderMemberSelect(ExpressionModel expression, String identifier) {
        expression.render(this);
        this.append('.').append(identifier);
    }

    public abstract void renderMethodReference(ExpressionModel var1, String var2);

    public abstract void renderNew(ExpressionModel var1, TypeInfo var2, List<ExpressionModel> var3);

    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        expression.render(this);
        this.append('.');
        this.append(method.getName());
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    public void renderStringLiteral(List<?> parts) {
        Iterator<?> it = parts.iterator();
        while (it.hasNext()) {
            Object part = it.next();
            if (part instanceof ExpressionModel) {
                ExpressionModel ex = (ExpressionModel)part;
                ex.render(this);
            } else {
                this.append("\"");
                this.renderChars(part.toString());
                this.append("\"");
            }
            if (!it.hasNext()) continue;
            this.append(" + ");
        }
    }

    public void renderBinary(BinaryExpressionModel expression) {
        expression.getLeft().render(this);
        this.append(" ").append(expression.getOp()).append(" ");
        expression.getRight().render(this);
    }

    public void renderNullLiteral() {
        this.append("null");
    }

    public void renderStringLiteral(String value) {
        this.append('\"');
        this.renderChars(value);
        this.append('\"');
    }

    public void renderCharLiteral(char value) {
        this.append('\'');
        this.renderChars(Character.toString(value));
        this.append('\'');
    }

    public void renderFloatLiteral(String value) {
        this.renderChars(value);
    }

    public void renderDoubleLiteral(String value) {
        this.renderChars(value);
    }

    public void renderBooleanLiteral(String value) {
        this.append(value);
    }

    public void renderLongLiteral(String value) {
        this.renderChars(value);
    }

    public void renderIntegerLiteral(String value) {
        this.append(value);
    }

    public void renderPostfixIncrement(ExpressionModel expression) {
        expression.render(this);
        this.append("++");
    }

    public void renderPrefixIncrement(ExpressionModel expression, CodeWriter writer) {
        writer.append("++");
        expression.render(writer);
    }

    public void renderPostfixDecrement(ExpressionModel expression) {
        expression.render(this);
        this.append("--");
    }

    public void renderPrefixDecrement(ExpressionModel expression) {
        this.append("--");
        expression.render(this);
    }

    public void renderLogicalComplement(ExpressionModel expression) {
        this.append("!");
        expression.render(this);
    }

    public void renderUnaryMinus(ExpressionModel expression) {
        this.append("-");
        expression.render(this);
    }

    public void renderUnaryPlus(ExpressionModel expression) {
        this.append("+");
        expression.render(this);
    }

    public abstract void renderListAdd(ExpressionModel var1, ExpressionModel var2);

    public abstract void renderListSize(ExpressionModel var1);

    public abstract void renderListGet(ExpressionModel var1, ExpressionModel var2);

    public abstract void renderListLiteral(List<ExpressionModel> var1);

    public abstract void renderMapGet(ExpressionModel var1, ExpressionModel var2);

    public abstract void renderMapPut(ExpressionModel var1, ExpressionModel var2, ExpressionModel var3);

    public abstract void renderMapForEach(ExpressionModel var1, String var2, TypeInfo var3, String var4, TypeInfo var5, LambdaExpressionTree.BodyKind var6, CodeModel var7);

    public abstract void renderJsonObject(JsonObjectLiteralModel var1);

    public abstract void renderJsonArray(JsonArrayLiteralModel var1);

    public abstract void renderDataObject(DataObjectLiteralModel var1);

    public abstract void renderJsonObjectAssign(ExpressionModel var1, String var2, ExpressionModel var3);

    public abstract void renderDataObjectAssign(ExpressionModel var1, String var2, ExpressionModel var3);

    public abstract void renderJsonObjectToString(ExpressionModel var1);

    public abstract void renderJsonArrayToString(ExpressionModel var1);

    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        throw new UnsupportedOperationException("todo");
    }

    public abstract void renderJsonObjectMemberSelect(ExpressionModel var1, String var2);

    public abstract void renderDataObjectMemberSelect(ExpressionModel var1, String var2);

    public void renderJsonArrayGet(ExpressionModel expression, ExpressionModel index) {
        expression.render(this);
        this.append('[');
        index.render(this);
        this.append(']');
    }

    public void renderReturn(ExpressionModel expression) {
        this.append("return");
        if (expression != null) {
            this.append(" ");
            expression.render(this);
        }
    }

    public abstract void renderNewMap();

    public abstract void renderNewList();

    public abstract void renderAsyncResultSucceeded(TypeInfo var1, String var2);

    public abstract void renderAsyncResultFailed(TypeInfo var1, String var2);

    public abstract void renderAsyncResultCause(TypeInfo var1, String var2);

    public abstract void renderAsyncResultValue(TypeInfo var1, String var2);

    public abstract void renderLambda(LambdaExpressionTree.BodyKind var1, List<TypeInfo> var2, List<String> var3, CodeModel var4);

    public abstract void renderEnumConstant(EnumTypeInfo var1, String var2);

    public abstract void renderSystemOutPrintln(ExpressionModel var1);

    public abstract void renderSystemErrPrintln(ExpressionModel var1);

    public abstract void renderThrow(String var1, ExpressionModel var2);

    public abstract void renderThis();

    public abstract void renderApiType(ApiTypeInfo var1);

    public abstract void renderJavaType(ClassTypeInfo var1);

    public void renderFragment(String fragment) {
        FragmentParser renderer = new FragmentParser(){

            @Override
            public void onNewline() {
                CodeWriter.this.append('\n');
            }

            @Override
            public void onComment(char c) {
                CodeWriter.this.append(c);
            }

            @Override
            public void onBeginComment(boolean multiline) {
                CodeWriter.this.append(multiline ? "/*" : "//");
            }

            @Override
            public void onEndComment(boolean multiline) {
                if (multiline) {
                    CodeWriter.this.append("*/");
                }
            }
        };
        renderer.parse(fragment);
    }
}

