/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.Member;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DataObjectLiteralModel
extends ExpressionModel {
    private final ClassTypeInfo type;
    private final Map<String, Member> members;

    public DataObjectLiteralModel(CodeBuilder builder, ClassTypeInfo type) {
        this(builder, type, Collections.emptyMap());
    }

    private DataObjectLiteralModel(CodeBuilder builder, ClassTypeInfo type, Map<String, Member> members) {
        super(builder);
        this.type = type;
        this.members = members;
    }

    public ClassTypeInfo getType() {
        return this.type;
    }

    public Iterable<Member> getMembers() {
        return this.members.values();
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        Function<String, Member> memberFactory;
        String name;
        String methodName = method.getName();
        if (DataObjectLiteralModel.isSet(methodName)) {
            name = DataObjectLiteralModel.unwrapSet(methodName);
            memberFactory = $ -> new Member.Single(name);
        } else if (DataObjectLiteralModel.isAdd(methodName)) {
            name = DataObjectLiteralModel.unwrapAdd(methodName);
            memberFactory = $ -> new Member.Array(name);
        } else {
            throw this.unsupported("Method " + method);
        }
        if (argumentModels.size() == 1) {
            LinkedHashMap<String, Member> copy = new LinkedHashMap<String, Member>(this.members);
            ExpressionModel value = argumentModels.get(0);
            Member member = copy.computeIfAbsent(name, memberFactory);
            member.append(value);
            copy.put(name, member);
            return new DataObjectLiteralModel(this.builder, this.type, copy);
        }
        throw this.unsupported("Method " + method + " must be invoked with a single argument");
    }

    @Override
    public ExpressionModel as(TypeInfo type) {
        if (!type.equals((Object)this.type)) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public void render(CodeWriter writer) {
        writer.renderDataObject(this);
    }

    static boolean isGet(String identifier) {
        return identifier.startsWith("get") && identifier.length() > 3 || identifier.startsWith("is") && identifier.length() > 2;
    }

    private static String unwrapGet(String identifier) {
        if (identifier.startsWith("get")) {
            return Character.toLowerCase(identifier.charAt(3)) + identifier.substring(4);
        }
        return Character.toLowerCase(identifier.charAt(2)) + identifier.substring(3);
    }

    static boolean isSet(String identifier) {
        return identifier.startsWith("set") && identifier.length() > 3;
    }

    static String unwrapSet(String identifier) {
        return Character.toLowerCase(identifier.charAt(3)) + identifier.substring(4);
    }

    static boolean isAdd(String identifier) {
        return identifier.startsWith("add") && identifier.length() > 3;
    }

    static String unwrapAdd(String identifier) {
        return Character.toLowerCase(identifier.charAt(3)) + identifier.substring(4) + "s";
    }
}

