/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.DataObjectModel;
import io.vertx.codetrans.expression.JsonArrayModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.ListModel;
import io.vertx.codetrans.expression.MapModel;
import io.vertx.codetrans.expression.MethodInvocationModel;
import java.util.List;

public class ExpressionModel
extends CodeModel {
    protected final CodeBuilder builder;

    public ExpressionModel(CodeBuilder builder) {
        this.builder = builder;
    }

    public ExpressionModel as(TypeInfo type) {
        switch (type.getKind()) {
            case JSON_OBJECT: {
                return new JsonObjectModel(this.builder, this);
            }
            case JSON_ARRAY: {
                return new JsonArrayModel(this.builder, this);
            }
            case DATA_OBJECT: {
                return new DataObjectModel(this.builder, this);
            }
            case MAP: {
                return new MapModel(this.builder, this);
            }
            case LIST: {
                return new ListModel(this.builder, this);
            }
        }
        return this;
    }

    boolean isStringDecl() {
        return false;
    }

    void collectParts(List<Object> parts) {
        parts.add(this);
    }

    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        if (method.getName().equals("equals") && method.getParameterTypes().size() == 1) {
            return this.builder.render((CodeWriter writer) -> writer.renderEquals(this, (ExpressionModel)argumentModels.get(0)));
        }
        return new MethodInvocationModel(this.builder, this, receiverType, method, returnType, argumentModels, argumenTypes);
    }

    public ExpressionModel onField(String identifier) {
        return this.builder.render((CodeWriter renderer) -> renderer.renderMemberSelect(this, identifier));
    }

    public ExpressionModel onMethodReference(String methodName) {
        return this.builder.render((CodeWriter renderer) -> renderer.renderMethodReference(this, methodName));
    }

    public ExpressionModel onPostFixIncrement() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderPostfixIncrement(this));
    }

    public ExpressionModel onPrefixIncrement() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderPrefixIncrement(this, (CodeWriter)renderer));
    }

    public ExpressionModel onPostFixDecrement() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderPostfixDecrement(this));
    }

    public ExpressionModel onPrefixDecrement() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderPrefixDecrement(this));
    }

    public ExpressionModel onLogicalComplement() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderLogicalComplement(this));
    }

    public ExpressionModel unaryMinus() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderUnaryMinus(this));
    }

    public ExpressionModel unaryPlus() {
        return this.builder.render((CodeWriter renderer) -> renderer.renderUnaryPlus(this));
    }
}

