/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import java.util.List;

public class DataObjectModel
extends ExpressionModel {
    final ExpressionModel expression;

    public DataObjectModel(CodeBuilder builder, ExpressionModel expression) {
        super(builder);
        this.expression = expression;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        String methodName = method.getName();
        if (DataObjectLiteralModel.isSet(methodName)) {
            return this.builder.render((CodeWriter writer) -> writer.renderDataObjectAssign(this.expression, DataObjectLiteralModel.unwrapSet(methodName), (ExpressionModel)argumentModels.get(0)));
        }
        if (DataObjectLiteralModel.isGet(methodName)) {
            return this.builder.render((CodeWriter writer) -> writer.renderDataObjectMemberSelect(this.expression, DataObjectLiteralModel.unwrapSet(methodName)));
        }
        throw new UnsupportedOperationException("Unsupported method " + method + " on object model");
    }

    @Override
    public void render(CodeWriter writer) {
        this.expression.render(writer);
    }
}

