/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codetrans.BlockModel;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.MethodModel;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.VisitContext;
import io.vertx.codetrans.expression.ArraysModel;
import io.vertx.codetrans.expression.ClassModel;
import io.vertx.codetrans.expression.DataObjectClassModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JavaClassModel;
import io.vertx.codetrans.expression.JsonArrayClassModel;
import io.vertx.codetrans.expression.JsonObjectClassModel;
import io.vertx.codetrans.expression.LambdaExpressionModel;
import io.vertx.codetrans.expression.ListClassModel;
import io.vertx.codetrans.expression.MapClassModel;
import io.vertx.codetrans.expression.ParenthesizedModel;
import io.vertx.codetrans.expression.StringLiteralModel;
import io.vertx.codetrans.expression.SystemModel;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.expression.ThrowableClassModel;
import io.vertx.codetrans.expression.ThrowableModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.statement.ConditionalBlockModel;
import io.vertx.codetrans.statement.ReturnModel;
import io.vertx.codetrans.statement.StatementModel;
import io.vertx.codetrans.statement.TryCatchModel;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ModelBuilder
extends TreePathScanner<CodeModel, VisitContext> {
    private final Trees trees;
    private final TreePath path;
    private final DeclaredType systemType;
    private final DeclaredType throwableType;
    private final Types typeUtils;
    private final TypeMirrorFactory factory;

    public ModelBuilder(Trees trees, TreePath path, DeclaredType systemType, DeclaredType throwableType, TypeMirrorFactory factory, Types typeUtils, Lang lang) {
        this.path = path;
        this.trees = trees;
        this.systemType = systemType;
        this.throwableType = throwableType;
        this.factory = factory;
        this.typeUtils = typeUtils;
    }

    public CodeModel build(TreePath path, VisitContext context) {
        return (CodeModel)this.scan(path, context);
    }

    public StatementModel scan(StatementTree tree, VisitContext context) {
        return (StatementModel)this.scan((Tree)tree, context);
    }

    public ExpressionModel scan(ExpressionTree tree, VisitContext context) {
        return (ExpressionModel)this.scan((Tree)tree, context);
    }

    @Override
    public CodeModel visitReturn(ReturnTree node, VisitContext context) {
        ExpressionModel expression = this.scan(node.getExpression(), context);
        return new ReturnModel(expression);
    }

    @Override
    public ExpressionModel visitParameterizedType(ParameterizedTypeTree tree, VisitContext context) {
        return (ExpressionModel)this.scan(tree.getType(), context);
    }

    @Override
    public CodeModel visitForLoop(ForLoopTree node, VisitContext context) {
        if (node.getInitializer().size() != 1) {
            throw new UnsupportedOperationException();
        }
        if (node.getUpdate().size() != 1) {
            throw new UnsupportedOperationException();
        }
        StatementModel initializer = this.scan(node.getInitializer().get(0), context);
        ExpressionModel update = this.scan(node.getUpdate().get(0).getExpression(), context);
        StatementModel body = this.scan(node.getStatement(), context);
        ExpressionModel condition = this.scan(node.getCondition(), context);
        return context.builder.forLoop(initializer, condition, update, body);
    }

    @Override
    public CodeModel visitEnhancedForLoop(EnhancedForLoopTree node, VisitContext context) {
        ExpressionModel expression = this.scan(node.getExpression(), context);
        StatementModel body = this.scan(node.getStatement(), context);
        return context.builder.enhancedForLoop(node.getVariable().getName().toString(), expression, body);
    }

    @Override
    public CodeModel visitAssignment(AssignmentTree node, VisitContext context) {
        ExpressionModel variable = this.scan(node.getVariable(), context);
        ExpressionModel expression = this.scan(node.getExpression(), context);
        return context.builder.forAssign(variable, expression);
    }

    @Override
    public StatementModel visitVariable(VariableTree node, VisitContext context) {
        JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)node;
        ExpressionModel initializer = node.getInitializer() != null ? this.scan(node.getInitializer(), context) : null;
        TypeInfo type = this.factory.create((TypeMirror)decl.type);
        ElementKind kind = decl.sym.getKind();
        VariableScope scope = this.resolvescope(context, kind, decl.getName().toString());
        return context.builder.variableDecl(scope, type, decl.name.toString(), initializer);
    }

    @Override
    public CodeModel visitTry(TryTree node, VisitContext context) {
        if (node.getCatches().size() != 1) {
            throw new UnsupportedOperationException("Expecting a single catch block");
        }
        StatementModel tryBlock = this.scan(node.getBlock(), context);
        StatementModel catchBlock = this.scan(node.getCatches().get(0).getBlock(), context);
        return new TryCatchModel(tryBlock, catchBlock);
    }

    @Override
    public StatementModel visitIf(IfTree node, VisitContext context) {
        ArrayList<ConditionalBlockModel> conditionals = new ArrayList<ConditionalBlockModel>();
        StatementModel otherwise = this.build(conditionals, node, context);
        return StatementModel.conditionals(conditionals, otherwise);
    }

    private StatementModel build(List<ConditionalBlockModel> conditionals, IfTree node, VisitContext context) {
        ExpressionModel condition = this.scan(node.getCondition(), context);
        StatementModel body = this.scan(node.getThenStatement(), context);
        conditionals.add(new ConditionalBlockModel(condition, body));
        StatementTree elseStatement = node.getElseStatement();
        if (elseStatement != null) {
            if (elseStatement instanceof IfTree) {
                IfTree next = (IfTree)elseStatement;
                return this.build(conditionals, next, context);
            }
            return this.scan(node.getElseStatement(), context);
        }
        return null;
    }

    @Override
    public CodeModel visitInstanceOf(InstanceOfTree node, VisitContext p) {
        ExpressionModel classModel = this.scan(node.getExpression(), p);
        TypeElement type = (TypeElement)((Object)((JCTree.JCIdent)node.getType()).sym);
        return classModel.onInstanceOf(type);
    }

    @Override
    public CodeModel visitConditionalExpression(ConditionalExpressionTree node, VisitContext context) {
        ExpressionModel condition = this.scan(node.getCondition(), context);
        ExpressionModel trueExpression = this.scan(node.getTrueExpression(), context);
        ExpressionModel falseExpression = this.scan(node.getFalseExpression(), context);
        return context.builder.forConditionalExpression(condition, trueExpression, falseExpression);
    }

    @Override
    public ExpressionModel visitUnary(UnaryTree node, VisitContext p) {
        ExpressionModel expression = this.scan(node.getExpression(), p);
        switch (node.getKind()) {
            case POSTFIX_INCREMENT: {
                return expression.onPostFixIncrement();
            }
            case POSTFIX_DECREMENT: {
                return expression.onPostFixDecrement();
            }
            case PREFIX_INCREMENT: {
                return expression.onPrefixIncrement();
            }
            case PREFIX_DECREMENT: {
                return expression.onPrefixDecrement();
            }
            case LOGICAL_COMPLEMENT: {
                return expression.onLogicalComplement();
            }
            case UNARY_MINUS: {
                return expression.unaryMinus();
            }
            case UNARY_PLUS: {
                return expression.unaryPlus();
            }
        }
        throw new UnsupportedOperationException("Unary operator " + node.getKind().name() + " not yet implemented");
    }

    @Override
    public CodeModel visitExpressionStatement(ExpressionStatementTree node, VisitContext context) {
        ExpressionModel expression = this.scan(node.getExpression(), context);
        return StatementModel.render(expression::render);
    }

    @Override
    public ExpressionModel visitBinary(BinaryTree node, VisitContext context) {
        String op;
        ExpressionModel left = this.scan(node.getLeftOperand(), context);
        ExpressionModel right = this.scan(node.getRightOperand(), context);
        switch (node.getKind()) {
            case CONDITIONAL_AND: {
                op = "&&";
                break;
            }
            case CONDITIONAL_OR: {
                op = "||";
                break;
            }
            case EQUAL_TO: {
                op = "==";
                break;
            }
            case NOT_EQUAL_TO: {
                op = "!=";
                break;
            }
            case PLUS: {
                op = "+";
                break;
            }
            case LESS_THAN: {
                op = "<";
                break;
            }
            case LESS_THAN_EQUAL: {
                op = "<=";
                break;
            }
            case GREATER_THAN: {
                op = ">";
                break;
            }
            case GREATER_THAN_EQUAL: {
                op = ">=";
                break;
            }
            case MULTIPLY: {
                op = "*";
                break;
            }
            case DIVIDE: {
                op = "/";
                break;
            }
            case AND: {
                op = "&";
                break;
            }
            case OR: {
                op = "|";
                break;
            }
            case XOR: {
                op = "^";
                break;
            }
            case MINUS: {
                op = "-";
                break;
            }
            case REMAINDER: {
                op = "%";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Binary operator " + node.getKind().name() + " not yet implemented");
            }
        }
        return context.builder.combine(left, op, right);
    }

    @Override
    public ExpressionModel visitLiteral(LiteralTree node, VisitContext context) {
        switch (node.getKind()) {
            case NULL_LITERAL: {
                return context.builder.render(writer -> writer.renderNullLiteral());
            }
            case STRING_LITERAL: {
                return new StringLiteralModel(context.builder, node.getValue().toString());
            }
            case BOOLEAN_LITERAL: {
                return context.builder.render(writer -> writer.renderBooleanLiteral(node.getValue().toString()));
            }
            case INT_LITERAL: {
                return context.builder.render(writer -> writer.renderIntegerLiteral(node.getValue().toString()));
            }
            case LONG_LITERAL: {
                return context.builder.render(writer -> writer.renderLongLiteral(node.getValue().toString()));
            }
            case CHAR_LITERAL: {
                return context.builder.render(writer -> writer.renderCharLiteral(node.getValue().toString().charAt(0)));
            }
            case FLOAT_LITERAL: {
                return context.builder.render(writer -> writer.renderFloatLiteral(node.getValue().toString()));
            }
            case DOUBLE_LITERAL: {
                return context.builder.render(writer -> writer.renderDoubleLiteral(node.getValue().toString()));
            }
        }
        throw new UnsupportedOperationException("Literal " + node.getKind().name() + " not yet implemented");
    }

    @Override
    public ExpressionModel visitIdentifier(IdentifierTree node, VisitContext context) {
        JCTree.JCIdent ident = (JCTree.JCIdent)node;
        if (node.getName().toString().equals("this")) {
            return new ThisModel(context.builder);
        }
        if (ident.sym instanceof TypeElement) {
            ClassTypeInfo type = (ClassTypeInfo)this.factory.create((TypeMirror)ident.type);
            if (ident.type.equals(this.systemType)) {
                return new SystemModel(context.builder);
            }
            if (type.getName().equals("java.util.Arrays")) {
                return new ArraysModel(context.builder);
            }
            if (this.typeUtils.isSubtype(ident.type, this.throwableType)) {
                return new ThrowableClassModel(context.builder, type);
            }
            if (type.getKind() == ClassKind.API) {
                return context.builder.apiType((ApiTypeInfo)type);
            }
            if (type.getKind() == ClassKind.JSON_OBJECT) {
                return new JsonObjectClassModel(context.builder);
            }
            if (type.getKind() == ClassKind.JSON_ARRAY) {
                return new JsonArrayClassModel(context.builder);
            }
            if (type.getKind() == ClassKind.DATA_OBJECT) {
                return new DataObjectClassModel(context.builder, type);
            }
            if (type.getKind() == ClassKind.ENUM) {
                return context.builder.enumType((EnumTypeInfo)type);
            }
            switch (type.getName()) {
                case "java.util.HashMap": {
                    return new MapClassModel(context.builder);
                }
                case "java.util.ArrayList": {
                    return new ListClassModel(context.builder);
                }
            }
            return new JavaClassModel(context.builder, type);
        }
        ExpressionModel alias = context.getAlias(ident.sym);
        if (alias != null) {
            return alias;
        }
        ElementKind kind = ident.sym.getKind();
        String name = node.getName().toString();
        TypeInfo type = this.factory.create((TypeMirror)ident.type);
        VariableScope scope = this.resolvescope(context, kind, name);
        return context.builder.identifier(name, scope).as(type);
    }

    private VariableScope resolvescope(VisitContext context, ElementKind kind, final String name) {
        VariableScope scope;
        switch (kind) {
            case LOCAL_VARIABLE: {
                scope = VariableScope.VARIABLE;
                break;
            }
            case PARAMETER: {
                scope = VariableScope.PARAMETER;
                break;
            }
            case FIELD: {
                final AtomicReference<VariableScope> resolvedScope = new AtomicReference<VariableScope>(VariableScope.GLOBAL);
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitVariable(VariableTree node, Void aVoid) {
                        if (node.getName().toString().equals(name)) {
                            resolvedScope.set(VariableScope.FIELD);
                        }
                        return null;
                    }
                }.scan(this.path.getParentPath(), (Void)null);
                if (resolvedScope.get() == VariableScope.FIELD) {
                    context.getReferencedFields().add(name);
                }
                scope = resolvedScope.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported kind " + (Object)((Object)kind));
            }
        }
        return scope;
    }

    @Override
    public CodeModel visitNewClass(NewClassTree node, VisitContext context) {
        ClassModel identifier = (ClassModel)this.scan(node.getIdentifier(), context);
        List<ExpressionModel> arguments = node.getArguments().stream().map(arg -> this.scan((ExpressionTree)arg, context)).collect(Collectors.toList());
        JCTree.JCNewClass newClass = (JCTree.JCNewClass)node;
        return identifier.onNew(arguments);
    }

    @Override
    public CodeModel visitThrow(ThrowTree node, VisitContext context) {
        ThrowableModel throwableExpression = (ThrowableModel)this.scan(node.getExpression(), context);
        return StatementModel.render(writer -> writer.renderThrow(throwableExpression.getType(), throwableExpression.getReason()));
    }

    @Override
    public CodeModel visitParenthesized(ParenthesizedTree node, VisitContext context) {
        ExpressionModel expression = this.scan(node.getExpression(), context);
        return new ParenthesizedModel(context.builder, expression);
    }

    @Override
    public ExpressionModel visitMemberSelect(MemberSelectTree node, VisitContext p) {
        ExpressionModel expression = this.scan(node.getExpression(), p);
        TypeInfo fieldType = this.factory.create((TypeMirror)((JCTree)((Object)node)).type);
        ExpressionModel fieldExpression = expression.onField(node.getIdentifier().toString());
        return fieldExpression.as(fieldType);
    }

    @Override
    public CodeModel visitMemberReference(MemberReferenceTree node, VisitContext p) {
        if (node.getMode() == MemberReferenceTree.ReferenceMode.INVOKE) {
            ExpressionModel expression = this.scan(node.getQualifierExpression(), p);
            if (expression instanceof ThisModel) {
                p.getReferencedMethods().add(node.getName().toString());
            }
            ExpressionModel methodReferenceExpression = expression.onMethodReference(node.getName().toString());
            return methodReferenceExpression;
        }
        throw new UnsupportedOperationException("New reference not implemented yet");
    }

    @Override
    public ExpressionModel visitMethodInvocation(MethodInvocationTree node, VisitContext context) {
        boolean addToRefedMethods;
        Symbol.MethodSymbol sym;
        ExpressionModel memberSelectExpression;
        String name;
        ExecutableElement exec = (ExecutableElement)this.trees.getElement(this.trees.getPath(this.path.getCompilationUnit(), node));
        boolean varargs = exec.isVarArgs();
        ArrayList<TypeInfo> argumentTypes = new ArrayList<TypeInfo>();
        for (JCTree.JCExpression argument2 : ((JCTree.JCMethodInvocation)node).getArguments()) {
            TypeInfo argumentType = null;
            if (argument2.type.getKind() != TypeKind.NULL) {
                argumentType = this.factory.create((TypeMirror)argument2.type);
            }
            argumentTypes.add(argumentType);
        }
        List<ExpressionModel> argumentModels = node.getArguments().stream().map(argument -> this.scan((ExpressionTree)argument, context)).collect(Collectors.toList());
        TypeInfo returnType = this.factory.create((TypeMirror)((JCTree)((Object)node)).type);
        if (node.getMethodSelect() instanceof IdentifierTree) {
            JCTree.JCIdent def = (JCTree.JCIdent)node.getMethodSelect();
            name = def.getName().toString();
            memberSelectExpression = context.builder.thisModel();
            sym = (Symbol.MethodSymbol)def.sym;
            addToRefedMethods = true;
        } else {
            JCTree.JCFieldAccess memberSelect = (JCTree.JCFieldAccess)node.getMethodSelect();
            memberSelectExpression = this.scan(memberSelect.getExpression(), context);
            name = memberSelect.getIdentifier().toString();
            sym = (Symbol.MethodSymbol)memberSelect.sym;
            addToRefedMethods = false;
        }
        ExecutableType methodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)((Object)((Symbol)sym.getEnclosingElement()).asType()), sym);
        ArrayList<TypeInfo> parameterTypes = new ArrayList<TypeInfo>();
        Iterator<? extends TypeMirror> it = methodType.getParameterTypes().iterator();
        while (it.hasNext()) {
            TypeMirror type = it.next();
            if (!it.hasNext() && varargs) {
                ArrayType arrayType = (ArrayType)type;
                type = arrayType.getComponentType();
            }
            TypeInfo parameterType = this.factory.create(type);
            parameterTypes.add(parameterType);
        }
        TypeInfo type = this.factory.create((TypeMirror)sym.owner.type);
        MethodSignature signature = new MethodSignature(name, parameterTypes, varargs);
        if (addToRefedMethods) {
            context.getReferencedMethods().add(name);
        }
        ExpressionModel expression = memberSelectExpression.onMethodInvocation(type, signature, returnType, argumentModels, argumentTypes);
        return expression.as(returnType);
    }

    @Override
    public StatementModel visitBlock(BlockTree node, VisitContext p) {
        List<? extends StatementTree> statements = node.getStatements();
        List models = statements.stream().map(statement -> this.scan((StatementTree)statement, p)).collect(Collectors.toList());
        LinkedList<String> fragments = new LinkedList<String>();
        CompilationUnitTree unit = this.path.getCompilationUnit();
        StringBuilder buffer = new StringBuilder();
        try (Reader reader = unit.getSourceFile().openReader(true);){
            int blockBegin;
            int len;
            char[] tmp = new char[256];
            while ((len = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, len);
            }
            String source = buffer.toString();
            int blockEnd = (int)this.trees.getSourcePositions().getEndPosition(unit, node) - 1;
            for (blockBegin = (int)this.trees.getSourcePositions().getStartPosition(unit, node); blockBegin < blockEnd && source.charAt(blockBegin) != '{'; ++blockBegin) {
            }
            while (blockBegin < blockEnd && source.charAt(blockBegin - 1) != '\n') {
                ++blockBegin;
            }
            while (blockEnd >= blockBegin && source.charAt(blockEnd - 1) != '\n') {
                --blockEnd;
            }
            int prev = blockBegin;
            for (StatementTree statementTree : statements) {
                int statementEnd;
                int statementBegin;
                for (statementBegin = (int)this.trees.getSourcePositions().getStartPosition(unit, statementTree); statementBegin > prev && source.charAt(statementBegin - 1) != '\n'; --statementBegin) {
                }
                fragments.add(source.substring(prev, statementBegin));
                for (statementEnd = (int)this.trees.getSourcePositions().getEndPosition(unit, statementTree); statementEnd < blockEnd && source.charAt(statementEnd - 1) != '\n'; ++statementEnd) {
                }
                prev = statementEnd;
            }
            fragments.add(source.substring(prev, blockEnd));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StatementModel.render(writer -> writer.renderBlock(new BlockModel(){

            @Override
            public void render(CodeWriter writer) {
                for (int i = 0; i < models.size(); ++i) {
                    StatementModel model = (StatementModel)models.get(i);
                    writer.renderFragment((String)fragments.get(i));
                    writer.renderStatement(model);
                }
                writer.renderFragment((String)fragments.getLast());
            }
        }));
    }

    @Override
    public ExpressionModel visitLambdaExpression(LambdaExpressionTree node, VisitContext context) {
        List<String> parameterNames = node.getParameters().stream().map(parameter -> parameter.getName().toString()).collect(Collectors.toList());
        List<TypeInfo> parameterTypes = node.getParameters().stream().map(parameter -> this.factory.create((TypeMirror)((JCTree.JCVariableDecl)parameter).type)).collect(Collectors.toList());
        int size = parameterNames.size();
        if (size > 0) {
            TypeInfo type;
            ParameterizedTypeTree typeApply;
            JCTree.JCVariableDecl last = (JCTree.JCVariableDecl)node.getParameters().get(size - 1);
            if (last.vartype instanceof ParameterizedTypeTree && (typeApply = (ParameterizedTypeTree)((Object)last.getType())).getType() instanceof MemberSelectTree && (type = this.factory.create((TypeMirror)last.getType().type)).getKind() == ClassKind.ASYNC_RESULT) {
                ExpressionModel result = context.builder.asyncResult(last.name.toString(), (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0));
                CodeModel body = (CodeModel)this.scan(node.getBody(), context.putAlias(last.sym, result));
                ParameterizedTypeInfo parameterized = (ParameterizedTypeInfo)type;
                return context.builder.asyncResultHandler(node.getBodyKind(), parameterized, last.name.toString(), body);
            }
        }
        CodeModel body = (CodeModel)this.scan(node.getBody(), context);
        return new LambdaExpressionModel(context.builder, node.getBodyKind(), parameterTypes, parameterNames, body);
    }

    @Override
    public MethodModel visitMethod(MethodTree node, VisitContext p) {
        ArrayList<TypeInfo> parameterTypes = new ArrayList<TypeInfo>();
        for (VariableTree variableTree : node.getParameters()) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)variableTree;
            TypeInfo parameterType = this.factory.create(decl.sym.asType());
            parameterTypes.add(parameterType);
        }
        return new MethodModel(this.scan(node.getBody(), p), new MethodSignature(node.getName().toString(), parameterTypes, false), node.getParameters().stream().map(param -> param.getName().toString()).collect(Collectors.toList()));
    }
}

