/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.RunnableCompilationUnit;
import io.vertx.codetrans.expression.ApiTypeModel;
import io.vertx.codetrans.expression.AsyncResultModel;
import io.vertx.codetrans.expression.BinaryExpressionModel;
import io.vertx.codetrans.expression.EnumExpressionModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.statement.StatementModel;
import java.util.function.Consumer;

public interface CodeBuilder {
    public CodeWriter newWriter();

    public String render(RunnableCompilationUnit var1);

    default public ExpressionModel combine(ExpressionModel left, String op, ExpressionModel right) {
        return new BinaryExpressionModel(this, left, op, right);
    }

    default public ExpressionModel asyncResult(String identifier, TypeInfo type) {
        return new AsyncResultModel(this, identifier, type);
    }

    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind var1, ParameterizedTypeInfo var2, String var3, CodeModel var4);

    default public ApiTypeModel apiType(ApiTypeInfo type) {
        return new ApiTypeModel(this, type);
    }

    default public EnumExpressionModel enumType(EnumTypeInfo type) {
        return new EnumExpressionModel(this, type);
    }

    default public ExpressionModel identifier(String name, VariableScope scope) {
        return new IdentifierModel(this, name, scope);
    }

    public StatementModel variableDecl(VariableScope var1, TypeInfo var2, String var3, ExpressionModel var4);

    public StatementModel enhancedForLoop(String var1, ExpressionModel var2, StatementModel var3);

    public StatementModel forLoop(StatementModel var1, ExpressionModel var2, ExpressionModel var3, StatementModel var4);

    default public ExpressionModel jsonArrayEncoder(ExpressionModel expression) {
        return this.render((CodeWriter writer) -> writer.renderJsonArrayToString(expression));
    }

    default public ExpressionModel jsonObjectEncoder(ExpressionModel expression) {
        return this.render((CodeWriter writer) -> writer.renderJsonObjectToString(expression));
    }

    default public ExpressionModel thisModel() {
        return new ThisModel(this);
    }

    default public ExpressionModel forConditionalExpression(ExpressionModel condition, ExpressionModel trueExpression, ExpressionModel falseExpression) {
        return this.render((CodeWriter renderer) -> renderer.renderConditionalExpression(condition, trueExpression, falseExpression));
    }

    default public ExpressionModel forAssign(ExpressionModel variable, ExpressionModel expression) {
        return this.render((CodeWriter renderer) -> renderer.renderAssign(variable, expression));
    }

    default public ExpressionModel render(final Consumer<CodeWriter> c) {
        CodeBuilder builder = this;
        return new ExpressionModel(builder){

            @Override
            public void render(CodeWriter writer) {
                c.accept(writer);
            }
        };
    }
}

