/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.js;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.Helper;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodModel;
import io.vertx.codetrans.RenderMode;
import io.vertx.codetrans.RunnableCompilationUnit;
import io.vertx.codetrans.expression.ApiTypeModel;
import io.vertx.codetrans.expression.EnumFieldExpressionModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.LambdaExpressionModel;
import io.vertx.codetrans.expression.StringLiteralModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.lang.js.JavaScriptWriter;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

class JavaScriptCodeBuilder
implements CodeBuilder {
    LinkedHashSet<ClassTypeInfo> modules = new LinkedHashSet();

    JavaScriptCodeBuilder() {
    }

    @Override
    public CodeWriter newWriter() {
        return new JavaScriptWriter(this);
    }

    @Override
    public String render(RunnableCompilationUnit unit, RenderMode renderMode) {
        CodeWriter writer = this.newWriter();
        for (ClassTypeInfo classTypeInfo : this.modules) {
            writer.append("var ").append(classTypeInfo.getSimpleName()).append(" = require(\"").append(classTypeInfo.getModuleName()).append("-js/").append(Helper.convertCamelCaseToUnderscores((String)classTypeInfo.getSimpleName())).append("\");\n");
        }
        for (Map.Entry entry : unit.getFields().entrySet()) {
            ((StatementModel)entry.getValue()).render(writer);
            writer.append(";\n");
        }
        for (Map.Entry entry : unit.getMethods().entrySet()) {
            writer.append("var ").append((CharSequence)entry.getKey()).append(" = function(");
            Iterator<String> it = ((MethodModel)entry.getValue()).getParameterNames().iterator();
            while (it.hasNext()) {
                String paramName = it.next();
                writer.append(paramName);
                if (!it.hasNext()) continue;
                writer.append(", ");
            }
            writer.append(") {\n");
            writer.indent();
            ((MethodModel)entry.getValue()).render(writer);
            writer.unindent();
            writer.append("};\n");
        }
        unit.getMain().render(writer);
        return writer.getBuffer().toString();
    }

    @Override
    public ApiTypeModel apiType(ApiTypeInfo type) {
        this.modules.add((ClassTypeInfo)type);
        return CodeBuilder.super.apiType(type);
    }

    @Override
    public ExpressionModel toDataObjectValue(EnumFieldExpressionModel enumField) {
        return new StringLiteralModel(this, enumField.identifier);
    }

    @Override
    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind bodyKind, ParameterizedTypeInfo resultType, String resultName, CodeModel body, CodeModel succeededBody, CodeModel failedBody) {
        return new LambdaExpressionModel(this, bodyKind, Arrays.asList((TypeInfo)resultType.getArgs().get(0), TypeReflectionFactory.create(Throwable.class)), Arrays.asList(resultName, resultName + "_err"), body);
    }

    @Override
    public StatementModel variableDecl(VariableScope scope, TypeInfo type, String name, ExpressionModel initializer) {
        return StatementModel.render(renderer -> {
            renderer.append("var ").append(name);
            if (initializer != null) {
                renderer.append(" = ");
                initializer.render((CodeWriter)renderer);
            }
        });
    }

    @Override
    public StatementModel enhancedForLoop(String variableName, ExpressionModel expression, StatementModel body) {
        return StatementModel.render(renderer -> {
            renderer.append("Array.prototype.forEach.call(");
            expression.render((CodeWriter)renderer);
            renderer.append(", function(").append(variableName).append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("})");
        });
    }

    @Override
    public StatementModel forLoop(StatementModel initializer, ExpressionModel condition, ExpressionModel update, StatementModel body) {
        return StatementModel.conditional(renderer -> {
            renderer.append("for (");
            initializer.render((CodeWriter)renderer);
            renderer.append("; ");
            condition.render((CodeWriter)renderer);
            renderer.append("; ");
            update.render((CodeWriter)renderer);
            renderer.append(") {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }

    @Override
    public StatementModel sequenceForLoop(String variableName, ExpressionModel fromValue, ExpressionModel toValue, StatementModel body) {
        return StatementModel.conditional(renderer -> {
            renderer.append("for (var ").append(variableName).append(" = ");
            fromValue.render((CodeWriter)renderer);
            renderer.append(";").append(variableName).append(" < ");
            toValue.render((CodeWriter)renderer);
            renderer.append(";").append(variableName).append("++) {\n");
            renderer.indent();
            body.render((CodeWriter)renderer);
            renderer.unindent();
            renderer.append("}");
        });
    }
}

