/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.scala;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodModel;
import io.vertx.codetrans.RenderMode;
import io.vertx.codetrans.RunnableCompilationUnit;
import io.vertx.codetrans.expression.ApiModel;
import io.vertx.codetrans.expression.ApiTypeModel;
import io.vertx.codetrans.expression.EnumExpressionModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.lang.scala.ScalaApiModel;
import io.vertx.codetrans.lang.scala.ScalaCodeWriter;
import io.vertx.codetrans.statement.StatementModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class ScalaCodeBuilder
implements CodeBuilder {
    private Set<String> imports = new HashSet<String>();
    private List<String> asyncResults = new ArrayList<String>();

    @Override
    public CodeWriter newWriter() {
        return new ScalaCodeWriter(this);
    }

    @Override
    public ApiTypeModel apiType(ApiTypeInfo type) {
        this.imports.add(type.translateName("scala"));
        return CodeBuilder.super.apiType(type);
    }

    @Override
    public EnumExpressionModel enumType(EnumTypeInfo type) {
        this.imports.add(type.getName());
        return CodeBuilder.super.enumType(type);
    }

    @Override
    public StatementModel variableDecl(VariableScope scope, TypeInfo type, String name, ExpressionModel initializer) {
        return StatementModel.render(renderer -> {
            renderer.append("var ").append(name);
            if (initializer != null) {
                renderer.append(" = ");
                initializer.render((CodeWriter)renderer);
            } else {
                renderer.append(" = null.asInstanceOf[").append(type.getName()).append(']');
            }
        });
    }

    @Override
    public ExpressionModel asyncResultHandler(LambdaExpressionTree.BodyKind bodyKind, ParameterizedTypeInfo parameterizedTypeInfo, final String s, CodeModel codeModel, final CodeModel codeModel1, final CodeModel codeModel2) {
        this.imports.add("scala.util.Failure");
        this.imports.add("scala.util.Success");
        return new ExpressionModel(this){

            @Override
            public void render(CodeWriter writer) {
                ScalaCodeBuilder.this.asyncResults.add(s);
                writer.append("{\n");
                writer.indent();
                writer.append("case Success(result) => ");
                writer.indent();
                if (codeModel1 != null) {
                    writer.append("{\n");
                    codeModel1.render(writer);
                    writer.unindent();
                    writer.append("}\n");
                } else {
                    writer.append("println(\"Success\")\n");
                    writer.unindent();
                }
                writer.append("case Failure(cause) => ");
                writer.indent();
                if (codeModel2 != null) {
                    writer.append("{\n");
                    writer.append("println(s\"$cause\")");
                    writer.unindent();
                    writer.append("\n}\n");
                } else {
                    writer.append("println(\"Failure\")\n");
                    writer.unindent();
                }
                writer.unindent();
                writer.append("}");
            }
        };
    }

    @Override
    public StatementModel enhancedForLoop(final String variableName, final ExpressionModel expression, final StatementModel body) {
        return new StatementModel(){

            @Override
            public void render(CodeWriter renderer) {
                expression.render(renderer);
                renderer.append(".foreach(");
                renderer.append(variableName);
                renderer.append(" => {");
                renderer.append("\n");
                renderer.indent();
                body.render(renderer);
                renderer.unindent();
                renderer.append("})\n");
            }
        };
    }

    @Override
    public StatementModel forLoop(final StatementModel initializer, final ExpressionModel condition, final ExpressionModel update, final StatementModel body) {
        return new StatementModel(){

            @Override
            public void render(CodeWriter renderer) {
                initializer.render(renderer);
                renderer.append("\nwhile(");
                condition.render(renderer);
                renderer.append("){\n");
                renderer.indent();
                body.render(renderer);
                renderer.append("\n");
                update.render(renderer);
                renderer.unindent();
                renderer.append("}\n");
            }
        };
    }

    @Override
    public StatementModel sequenceForLoop(final String variableName, final ExpressionModel fromValue, final ExpressionModel toValue, final StatementModel body) {
        return new StatementModel(){

            @Override
            public void render(CodeWriter renderer) {
                renderer.append("for ( " + variableName + " <- ");
                fromValue.render(renderer);
                renderer.append(" until ");
                toValue.render(renderer);
                renderer.append(") {\n");
                renderer.indent();
                body.render(renderer);
                renderer.unindent();
                renderer.append("}\n");
            }
        };
    }

    @Override
    public ApiModel api(ExpressionModel expr) {
        return new ScalaApiModel(this, expr);
    }

    @Override
    public String render(RunnableCompilationUnit unit, RenderMode renderMode) {
        CodeWriter writer = this.newWriter();
        for (String string : this.imports) {
            writer.append("import ").append(string).append('\n');
        }
        for (StatementModel statementModel : unit.getFields().values()) {
            statementModel.render(writer);
            writer.append("\n");
        }
        for (Map.Entry entry : unit.getMethods().entrySet()) {
            writer.append("def ").append((CharSequence)entry.getKey()).append("(");
            IntStream.range(0, ((MethodModel)entry.getValue()).getParameterNames().size()).forEach(i -> {
                if (i > 0) {
                    writer.append(", ");
                }
                writer.append(((MethodModel)method.getValue()).getParameterNames().get(i));
                writer.append(":");
                writer.append(((MethodModel)method.getValue()).getSignature().getParameterTypes().get(i).getName());
            });
            writer.append(") = {\n");
            writer.indent();
            ((MethodModel)entry.getValue()).render(writer);
            writer.unindent();
            writer.append("}\n");
        }
        unit.getMain().render(writer);
        String ret = writer.getBuffer().toString();
        ret = ret.replace("return ", "");
        ret = this.convertLeftoverUsageOfAsyncResultMethods(ret);
        ret = this.removeThisIfStringRepresentsAScript(ret);
        if (renderMode == RenderMode.TEST) {
            String string = unit.getMain().getClassName();
            ret = "package " + string + "\nclass " + unit.getMain().getSignature().getName() + " extends (() => Any) {\n  def apply() = {\n" + ret + "  }\n}\n";
        }
        return ret;
    }

    private String removeThisIfStringRepresentsAScript(String ret) {
        if (!ret.contains("class")) {
            return ret.replace("this.", "");
        }
        return ret;
    }

    private String convertLeftoverUsageOfAsyncResultMethods(String ret) {
        return this.asyncResults.stream().reduce(ret, (identity, value) -> identity.replace(value + ".result()", "result").replace(value + ".succeeded()", "true"));
    }
}

