/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

public abstract class FragmentParser {
    public void parse(String s) {
        int width = 0;
        int status = 0;
        int margin = 0;
        block22: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            width = c == '\n' ? 0 : ++width;
            if (status == 0) {
                switch (c) {
                    case '/': {
                        status = 1;
                        break;
                    }
                    case '\n': {
                        this.onNewline();
                        break;
                    }
                }
                continue;
            }
            if (status == 1) {
                switch (c) {
                    case '/': {
                        status = 2;
                        this.onBeginComment(false);
                        break;
                    }
                    case '*': {
                        margin = width - 2;
                        status = 3;
                        this.onBeginComment(true);
                    }
                }
                continue;
            }
            if (status == 2) {
                switch (c) {
                    case '\n': {
                        this.onEndComment(false);
                        this.onNewline();
                        status = 0;
                        break;
                    }
                    default: {
                        this.onComment(c);
                        break;
                    }
                }
                continue;
            }
            if (status == 3) {
                block11 : switch (c) {
                    case '*': {
                        status = 4;
                        break;
                    }
                    case '\n': {
                        this.onComment('\n');
                        break;
                    }
                    case ' ': {
                        if (width <= margin) {
                            for (int j = 0; j < width; ++j) {
                                if (s.charAt(i - j) == ' ') continue;
                                this.onComment(' ');
                                break block11;
                            }
                            continue block22;
                        }
                        this.onComment(' ');
                        break;
                    }
                    default: {
                        this.onComment(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '/': {
                    status = 0;
                    this.onEndComment(true);
                    continue block22;
                }
                default: {
                    status = 3;
                    this.onComment('*');
                    this.onComment(c);
                }
            }
        }
        switch (status) {
            case 2: {
                this.onEndComment(false);
            }
        }
    }

    protected abstract void onNewline();

    protected abstract void onComment(char var1);

    protected abstract void onBeginComment(boolean var1);

    protected abstract void onEndComment(boolean var1);
}

