/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.expression.ClassModel;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.DataObjectModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.Member;
import java.util.HashMap;
import java.util.List;

public class DataObjectClassModel
extends ClassModel {
    final ClassTypeInfo type;

    public DataObjectClassModel(CodeBuilder builder, ClassTypeInfo type) {
        super(builder);
        this.type = type;
    }

    @Override
    public ExpressionModel onNew(List<ExpressionModel> arguments) {
        switch (arguments.size()) {
            case 0: {
                return new DataObjectLiteralModel(this.builder, this.type);
            }
            case 1: {
                ExpressionModel em = arguments.get(0);
                if (em instanceof JsonObjectLiteralModel) {
                    JsonObjectLiteralModel jsonModel = (JsonObjectLiteralModel)em;
                    HashMap<String, Member> copy = new HashMap<String, Member>();
                    jsonModel.getMembers().forEach(member -> copy.put(member.name, (Member)member));
                    return new DataObjectLiteralModel(this.builder, this.type, copy);
                }
                if (!(em instanceof JsonObjectModel)) break;
                JsonObjectModel jsonModel = (JsonObjectModel)em;
                return new DataObjectModel(this.builder, this.builder.render((CodeWriter writer) -> writer.renderToDataObject(jsonModel, this.type)));
            }
        }
        throw new UnsupportedOperationException("Cannot build a data object using " + arguments + " constructor");
    }
}

