/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.kotlin;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.BinaryExpressionModel;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.expression.StringLiteralModel;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.lang.kotlin.KotlinCodeBuilder;
import io.vertx.codetrans.statement.StatementModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public class KotlinCodeWriter
extends CodeWriter {
    private static final Map<String, String> BASIC_TYPES = new HashMap<String, String>();
    private int jsonLevel = 0;
    private static final Set<String> reservedWords;

    public KotlinCodeWriter(CodeBuilder builder) {
        super(builder);
    }

    @Override
    public KotlinCodeBuilder getBuilder() {
        return (KotlinCodeBuilder)super.getBuilder();
    }

    @Override
    public void renderStringLiteral(List<?> parts) {
        this.append('\"');
        for (Object part : parts) {
            if (part instanceof ExpressionModel) {
                this.append("${");
                ((ExpressionModel)part).render(this);
                this.append("}");
                continue;
            }
            this.renderChars(part.toString());
        }
        this.append('\"');
    }

    @Override
    public void renderChars(String value) {
        block10: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    this.append("\\b");
                    continue block10;
                }
                case '\f': {
                    this.append("\\u000c");
                    continue block10;
                }
                case '\n': {
                    this.append("\\n");
                    continue block10;
                }
                case '\t': {
                    this.append("\\t");
                    continue block10;
                }
                case '\r': {
                    this.append("\\r");
                    continue block10;
                }
                case '\"': {
                    this.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.append("\\\\");
                    continue block10;
                }
                case '$': {
                    this.append("\\$");
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String s = Integer.toHexString(c).toUpperCase();
                        while (s.length() < 4) {
                            s = "0" + s;
                        }
                        this.append("\\u").append(s);
                        continue block10;
                    }
                    this.append(c);
                }
            }
        }
    }

    @Override
    public void renderNewList() {
        this.append("mutableListOf<Any?>()");
    }

    @Override
    public void renderNewMap() {
        this.append("mutableMapOf<String, Any?>()");
    }

    @Override
    public void renderThis() {
        this.append("this");
    }

    @Override
    public void renderMethodReference(ExpressionModel expression, MethodSignature signature) {
        this.append("{ ");
        ArrayList<ExpressionModel> arguments = new ArrayList<ExpressionModel>();
        if (!signature.getParameterTypes().isEmpty()) {
            int i;
            int m = signature.getParameterTypes().size();
            for (i = 0; i < m; ++i) {
                String name = m == 1 ? "it" : "p" + Integer.toString(i);
                arguments.add(new IdentifierModel(this.builder, name, VariableScope.VARIABLE));
            }
            if (arguments.size() > 1) {
                m = arguments.size();
                for (i = 0; i < m; ++i) {
                    if (i > 0) {
                        this.append(", ");
                    }
                    this.append(((IdentifierModel)arguments.get((int)i)).name);
                }
                this.append(" -> ");
            }
        }
        this.renderMethodInvocation(expression, VoidTypeInfo.INSTANCE, signature, VoidTypeInfo.INSTANCE, Collections.emptyList(), arguments, Collections.emptyList());
        this.append(" }");
    }

    @Override
    public void renderLongLiteral(String value) {
        this.renderChars(value);
        this.append('L');
    }

    @Override
    public void renderFloatLiteral(String value) {
        this.renderChars(value);
        this.append('f');
    }

    @Override
    public void renderDoubleLiteral(String value) {
        this.renderChars(value);
    }

    @Override
    public void renderBinary(BinaryExpressionModel expression) {
        expression.getLeft().render(this);
        this.append(" ");
        switch (expression.getOp()) {
            case "&": {
                this.append("and");
                break;
            }
            case "|": {
                this.append("or");
                break;
            }
            case "^": {
                this.append("xor");
                break;
            }
            default: {
                this.append(expression.getOp());
            }
        }
        this.append(" ");
        expression.getRight().render(this);
    }

    @Override
    public void renderStatement(StatementModel statement) {
        statement.render(this);
        this.append("\n");
    }

    @Override
    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("try {\n");
        this.indent();
        tryBlock.render(this);
        this.unindent();
        this.append("} catch(e: Exception) {\n");
        this.indent();
        catchBlock.render(this);
        this.unindent();
        this.append("}\n");
    }

    @Override
    public void renderThrow(String throwableType, ExpressionModel reason) {
        this.append("throw ");
        this.append(throwableType);
        this.append("(");
        if (reason != null) {
            reason.render(this);
        }
        this.append(")");
    }

    @Override
    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("System.err.println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("{");
        if (!parameterNames.isEmpty()) {
            for (int i = 0; i < parameterNames.size(); ++i) {
                if (i == 0) {
                    this.append(" ");
                } else {
                    this.append(", ");
                }
                this.append(parameterNames.get(i));
            }
            this.append(" ->\n");
        } else {
            this.append("\n");
        }
        this.indent();
        body.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append("\n");
        }
        this.unindent();
        this.append("}");
    }

    @Override
    public void renderApiType(ApiTypeInfo apiType) {
        this.append(apiType.getSimpleName());
    }

    @Override
    public void renderJavaType(ClassTypeInfo javaType) {
        switch (javaType.getKind()) {
            case STRING: {
                this.append("String");
                break;
            }
            case VOID: {
                this.append("Unit");
                break;
            }
            case BOXED_PRIMITIVE: {
                this.renderBasicType((TypeInfo)javaType);
                break;
            }
            default: {
                this.append(javaType.getName());
            }
        }
    }

    @Override
    public void renderIdentifier(String name, VariableScope scope) {
        if (reservedWords.contains(name)) {
            this.append("`");
            this.append(name);
            this.append("`");
        } else {
            this.append(name);
        }
    }

    public void renderBasicType(TypeInfo type) {
        this.append(BASIC_TYPES.getOrDefault(type.getName(), type.getName()));
    }

    @Override
    public void renderAsyncResultSucceeded(TypeInfo resultType, String name) {
        this.append(name).append(".succeeded()");
    }

    @Override
    public void renderAsyncResultFailed(TypeInfo resultType, String name) {
        this.append(name).append(".failed()");
    }

    @Override
    public void renderAsyncResultCause(TypeInfo resultType, String name) {
        this.append(name).append(".cause()");
    }

    @Override
    public void renderAsyncResultValue(TypeInfo resultType, String name) {
        this.append(name).append(".result()");
    }

    @Override
    public void renderEnumConstant(EnumTypeInfo type, String constant) {
        this.append(type.getSimpleName()).append('.').append(constant);
    }

    @Override
    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render(this);
        this.append(".add(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderListSize(ExpressionModel list) {
        list.render(this);
        this.append(".size");
    }

    @Override
    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render(this);
        this.append("[");
        index.render(this);
        this.append("]");
    }

    @Override
    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render(this);
        this.append("[");
        key.render(this);
        this.append("]");
    }

    @Override
    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render(this);
        this.append("[");
        key.render(this);
        this.append("] = ");
        value.render(this);
    }

    @Override
    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        this.append("for ((").append(keyName).append(", ").append(valueName).append(") in ");
        map.render(this);
        this.append(") {\n");
        this.indent();
        block.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append("\n");
        }
        this.unindent();
        this.append("}\n");
    }

    @Override
    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        expression.render(this);
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderInstanceOf(ExpressionModel expression, TypeElement type) {
        expression.render(this);
        this.append(" is ");
        this.append(type.getQualifiedName());
    }

    @Override
    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("listOf(");
        for (int i = 0; i < arguments.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            arguments.get(i).render(this);
        }
        this.append(")");
    }

    @Override
    public void renderJsonArrayToString(ExpressionModel expression) {
        expression.render(this);
        this.append(".toString()");
    }

    @Override
    public void renderJsonObjectToString(ExpressionModel expression) {
        expression.render(this);
        this.append(".toString()");
    }

    @Override
    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.renderJsonArray(jsonArray.getValues());
    }

    @Override
    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render(this);
        if (value instanceof NullLiteralModel) {
            this.append(".addNull()");
        } else {
            this.append(".add(");
            value.render(this);
            this.append(")");
        }
    }

    private void jsonEnter() {
        if (this.jsonLevel == 0) {
            this.append("json {\n");
            this.indent();
        }
        ++this.jsonLevel;
    }

    private void jsonLeave() {
        --this.jsonLevel;
        if (this.jsonLevel == 0) {
            this.unindent();
            this.append("\n}");
        }
    }

    @Override
    public void renderJsonArrayGet(ExpressionModel expression, Class<?> type, ExpressionModel index) {
        expression.render(this);
        this.append(".");
        if (type == Object.class) {
            this.append("get<Any?>(");
        } else {
            this.append("get");
            this.append(type.getSimpleName());
        }
        this.append("(");
        index.render(this);
        this.append(')');
    }

    private void renderJsonArray(List<ExpressionModel> entries) {
        this.jsonEnter();
        this.append("array(");
        for (int i = 0; i < entries.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            entries.get(i).render(this);
        }
        this.append(")");
        this.jsonLeave();
    }

    @Override
    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.jsonEnter();
        this.renderMapStructure("obj", jsonObject.getMembers());
        this.jsonLeave();
    }

    @Override
    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        ArrayList<ExpressionModel> args = new ArrayList<ExpressionModel>();
        args.add(new StringLiteralModel(this.getBuilder(), name));
        if (value instanceof NullLiteralModel) {
            this.renderMethodInvocation(expression, VoidTypeInfo.INSTANCE, new MethodSignature("putNull", Collections.emptyList(), false, VoidTypeInfo.INSTANCE), VoidTypeInfo.INSTANCE, Collections.emptyList(), args, Collections.emptyList());
        } else {
            args.add(value);
            this.renderMethodInvocation(expression, VoidTypeInfo.INSTANCE, new MethodSignature("put", Collections.emptyList(), false, VoidTypeInfo.INSTANCE), VoidTypeInfo.INSTANCE, Collections.emptyList(), args, Collections.emptyList());
        }
    }

    @Override
    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        if (!(expression instanceof ThisModel)) {
            expression.render(this);
            this.append('.');
        }
        this.renderIdentifier(method.getName(), VariableScope.FIELD);
        if (typeArguments.size() > 0) {
            boolean needed;
            boolean bl = needed = typeArguments.stream().filter(typeArg -> typeArg == null || !typeArg.resolved).count() > 0L;
            if (needed) {
                this.append('<');
                this.append(typeArguments.stream().map(ti -> {
                    if (ti != null) {
                        return ti.value.getSimpleName();
                    }
                    return "Any";
                }).collect(Collectors.joining(", ")));
                this.append('>');
            }
        }
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderJsonObjectMemberSelect(ExpressionModel expression, Class<?> type, String name) {
        expression.render(this);
        this.append(".");
        if (type == Object.class) {
            this.append("get<Any?>");
        } else {
            this.append("get");
            this.append(type.getSimpleName());
        }
        this.append("(");
        this.renderStringLiteral(name);
        this.append(")");
    }

    @Override
    public void renderToDataObject(JsonObjectModel model, ClassTypeInfo type) {
        this.append(type.getSimpleName());
        this.append("(");
        model.render(this);
        this.append(")");
    }

    @Override
    public void renderDataObject(DataObjectLiteralModel model) {
        this.append(model.getType().getSimpleName());
        this.append("(");
        if (model.getMembers().iterator().hasNext()) {
            this.append("\n");
            this.indent();
            int index = 0;
            for (Member m : model.getMembers()) {
                if (index > 0) {
                    this.append(",\n");
                }
                this.append(m.getName()).append(" = ");
                this.renderMember(m);
                ++index;
            }
            this.unindent();
        }
        this.append(")");
    }

    @Override
    public void renderDataObjectToJson(IdentifierModel model) {
        model.render(this);
        this.append(".toJson()");
    }

    @Override
    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        this.renderDataObjectMemberSelect(expression, name);
        this.append(" = ");
        value.render(this);
    }

    @Override
    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        expression.render(this);
        this.append(".");
        this.renderIdentifier(name, VariableScope.FIELD);
    }

    @Override
    public void renderJsonObjectSize(ExpressionModel expression) {
        expression.render(this);
        this.append(".size()");
    }

    @Override
    public void renderJsonArraySize(ExpressionModel expression) {
        expression.render(this);
        this.append(".size()");
    }

    @Override
    public void renderMemberSelect(ExpressionModel expression, String identifier) {
        expression.render(this);
        this.append('.');
        this.renderIdentifier(identifier, VariableScope.FIELD);
    }

    private void renderMapStructure(String builderFunctionName, Iterable<Member> members) {
        ArrayList membersList = new ArrayList();
        members.forEach(membersList::add);
        boolean feedLine = membersList.size() > 1;
        this.append(builderFunctionName);
        this.append("(");
        if (feedLine) {
            this.append("\n");
        }
        this.indent();
        int i = 0;
        for (Member m : membersList) {
            if (i > 0) {
                this.append(",");
                if (feedLine) {
                    this.append("\n");
                }
            }
            this.renderStringLiteral(m.getName());
            this.append(" to ");
            this.renderMember(m);
            ++i;
        }
        this.unindent();
        if (feedLine) {
            this.append("\n");
        }
        this.append(")");
    }

    private void renderMap(Iterable<Member> members) {
        this.renderMapStructure("mapOf", members);
    }

    private void renderMember(Member m) {
        if (m instanceof Member.Single) {
            ((Member.Single)m).getValue().render(this);
        } else if (m instanceof Member.Sequence) {
            this.renderListLiteral(((Member.Sequence)m).getValues());
        } else if (m instanceof Member.Entries) {
            this.renderMap(((Member.Entries)m).entries());
        }
    }

    static {
        BASIC_TYPES.put(Byte.class.getName(), "Byte");
        BASIC_TYPES.put(Byte.TYPE.getName(), "Byte");
        BASIC_TYPES.put(Short.class.getName(), "Short");
        BASIC_TYPES.put(Short.TYPE.getName(), "Short");
        BASIC_TYPES.put(Integer.class.getName(), "Int");
        BASIC_TYPES.put(Integer.TYPE.getName(), "Int");
        BASIC_TYPES.put(Long.class.getName(), "Long");
        BASIC_TYPES.put(Long.TYPE.getName(), "Long");
        BASIC_TYPES.put(Float.class.getName(), "Float");
        BASIC_TYPES.put(Float.TYPE.getName(), "Float");
        BASIC_TYPES.put(Double.class.getName(), "Double");
        BASIC_TYPES.put(Double.TYPE.getName(), "Double");
        BASIC_TYPES.put(Character.class.getName(), "Char");
        BASIC_TYPES.put(Character.TYPE.getName(), "Char");
        BASIC_TYPES.put(Boolean.class.getName(), "Boolean");
        BASIC_TYPES.put(Boolean.TYPE.getName(), "Boolean");
        reservedWords = new HashSet<String>(Arrays.asList("object", "class"));
    }
}

