/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.js;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.BinaryExpressionModel;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.lang.js.JavaScriptCodeBuilder;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.TypeElement;

class JavaScriptWriter
extends CodeWriter {
    final JavaScriptCodeBuilder builder;

    JavaScriptWriter(JavaScriptCodeBuilder builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    public void renderBinary(BinaryExpressionModel expression) {
        String op;
        ExpressionModel left = expression.getLeft();
        ExpressionModel right = expression.getRight();
        switch (op = expression.getOp()) {
            case "==": {
                op = "===";
                if (right instanceof NullLiteralModel) {
                    ExpressionModel tmp = right;
                    right = left;
                    left = tmp;
                }
                if (!(left instanceof NullLiteralModel)) break;
                this.append("(");
                right.render(this);
                this.append(" === null || ");
                right.render(this);
                this.append(" === undefined)");
                return;
            }
            case "!=": {
                if (right instanceof NullLiteralModel) {
                    ExpressionModel tmp = right;
                    right = left;
                    left = tmp;
                }
                if (left instanceof NullLiteralModel) {
                    this.append("(");
                    right.render(this);
                    this.append(" !== null && ");
                    right.render(this);
                    this.append(" !== undefined)");
                    return;
                }
                op = "!==";
            }
        }
        super.renderBinary(new BinaryExpressionModel(this.builder, expression.getLeft(), op, expression.getRight()));
    }

    @Override
    public void renderStatement(StatementModel statement) {
        statement.render(this);
        if (statement instanceof StatementModel.Expression) {
            this.append(";");
        }
        this.append("\n");
    }

    @Override
    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("try {\n");
        this.indent();
        tryBlock.render(this);
        this.unindent();
        this.append("} catch(err) {\n");
        this.indent();
        catchBlock.render(this);
        this.unindent();
        this.append("}\n");
    }

    @Override
    public void renderThis() {
        this.append("this");
    }

    @Override
    public void renderNewMap() {
        this.append("{}");
    }

    @Override
    public void renderNewList() {
        this.append("[]");
    }

    @Override
    public void renderDataObject(DataObjectLiteralModel model) {
        this.renderJsonObject(model.getMembers());
    }

    @Override
    public void renderDataObjectToJson(IdentifierModel model) {
        model.render(this);
    }

    @Override
    public void renderToDataObject(JsonObjectModel model, ClassTypeInfo type) {
        model.render(this);
    }

    @Override
    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.renderJsonObject(jsonObject.getMembers());
    }

    @Override
    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.renderJsonArray(jsonArray.getValues());
    }

    private void renderJsonObject(Iterable<Member> members) {
        this.append("{\n");
        this.indent();
        Iterator<Member> iterator = members.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            String name = member.getName();
            this.append("\"");
            this.renderChars(name);
            this.append("\" : ");
            if (member instanceof Member.Single) {
                ((Member.Single)member).getValue().render(this);
            } else if (member instanceof Member.Sequence) {
                this.renderJsonArray(((Member.Sequence)member).getValues());
            } else if (member instanceof Member.Entries) {
                this.renderJsonObject(((Member.Entries)member).entries());
            }
            if (iterator.hasNext()) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append("}");
    }

    private void renderJsonArray(List<ExpressionModel> values) {
        this.append("[\n").indent();
        for (int i = 0; i < values.size(); ++i) {
            values.get(i).render(this);
            if (i < values.size() - 1) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append(']');
    }

    @Override
    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render(this);
        this.append('.');
        this.append(name);
        this.append(" = ");
        value.render(this);
    }

    @Override
    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render(this);
        this.append(".push(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        this.renderJsonObjectAssign(expression, name, value);
    }

    @Override
    public void renderJsonObjectMemberSelect(ExpressionModel expression, Class<?> type, String name) {
        expression.render(this);
        this.append('.');
        this.append(name);
    }

    @Override
    public void renderJsonObjectToString(ExpressionModel expression) {
        this.append("JSON.stringify(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonArrayToString(ExpressionModel expression) {
        this.append("JSON.stringify(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        this.renderJsonObjectMemberSelect(expression, Object.class, name);
    }

    @Override
    public void renderJsonObjectSize(ExpressionModel expression) {
        this.append("Object.keys(");
        expression.render(this);
        this.append(").length");
    }

    @Override
    public void renderJsonArraySize(ExpressionModel expression) {
        expression.render(this);
        this.append(".length");
    }

    @Override
    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("function (");
        for (int i = 0; i < parameterNames.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.append(parameterNames.get(i));
        }
        this.append(") {\n");
        this.indent();
        body.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append(";\n");
        }
        this.unindent();
        this.append("}");
    }

    @Override
    public void renderEnumConstant(EnumTypeInfo type, String constant) {
        this.append('\'').append(constant).append('\'');
    }

    @Override
    public void renderThrow(String throwableType, ExpressionModel reason) {
        if (reason == null) {
            this.append("throw ").append("\"an error occured\"");
        } else {
            this.append("throw ");
            reason.render(this);
        }
    }

    @Override
    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("console.log(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("console.error(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render(this);
        this.append(".push(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderListSize(ExpressionModel list) {
        list.render(this);
        this.append(".length");
    }

    @Override
    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render(this);
        this.append("[");
        index.render(this);
        this.append("]");
    }

    @Override
    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("[");
        Iterator<ExpressionModel> it = arguments.iterator();
        while (it.hasNext()) {
            it.next().render(this);
            if (!it.hasNext()) continue;
            this.append(", ");
        }
        this.append("]");
    }

    @Override
    public void renderNewArray(String primitiveType, List<ExpressionModel> arguments) {
        this.renderListLiteral(arguments);
    }

    @Override
    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append(']');
    }

    @Override
    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append("] = ");
        value.render(this);
    }

    @Override
    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        map.render(this);
        this.append(".forEach(");
        this.renderLambda(bodyKind, Arrays.asList(valueType, keyType), Arrays.asList(valueName, keyName), block);
        this.append(")");
    }

    @Override
    public void renderMethodReference(ExpressionModel expression, MethodSignature signature) {
        if (!(expression instanceof ThisModel)) {
            expression.render(this);
            this.append('.');
        }
        this.append(signature.getName());
    }

    @Override
    public void renderApiType(ApiTypeInfo apiType) {
        this.append(apiType.getSimpleName());
    }

    @Override
    public void renderJavaType(ClassTypeInfo javaType) {
        this.append("Java.type(\"" + javaType.getName() + "\")");
    }

    @Override
    public void renderAsyncResultSucceeded(TypeInfo resultType, String name) {
        this.append(name).append("_err == null");
    }

    @Override
    public void renderAsyncResultFailed(TypeInfo resultType, String name) {
        this.append(name).append("_err != null");
    }

    @Override
    public void renderAsyncResultCause(TypeInfo resultType, String name) {
        this.append(name).append("_err");
    }

    @Override
    public void renderAsyncResultValue(TypeInfo resultType, String name) {
        this.append(name);
    }

    @Override
    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        int i;
        List<TypeInfo> parameterTypes = method.getParameterTypes();
        for (i = 0; i < parameterTypes.size(); ++i) {
            TypeInfo parameterType = parameterTypes.get(i);
            TypeInfo argumentType = argumentTypes.get(i);
            if (!Helper.isHandler(parameterType) || !Helper.isInstanceOfHandler(argumentType)) continue;
            ExpressionModel expressionModel = argumentModels.get(i);
            argumentModels.set(i, this.builder.render(cw -> {
                expressionModel.render((CodeWriter)cw);
                cw.append(".handle");
            }));
        }
        if (!(expression instanceof ThisModel)) {
            expression.render(this);
            this.append('.');
        }
        this.append(method.getName());
        this.append('(');
        for (i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        this.append("new (");
        expression.render(this);
        this.append(")");
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderInstanceOf(ExpressionModel expression, TypeElement type) {
        expression.render(this);
        this.append(".getClass().getSimpleName() == '");
        this.append(type.getSimpleName());
        this.append("'");
    }
}

